﻿---
title: Kibana fields
description: Kibana module Kibana cluster actions metrics. Kibana cluster rule metrics. Kibana node actions metrics. Kibana node rule metrics. Kibana stats and run-time...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-kibana
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Kibana fields
Kibana module
<definitions>
  <definition term="kibana_stats.timestamp">
    type: alias
    alias to: @timestamp
  </definition>
  <definition term="kibana_stats.kibana.response_time.max">
    type: alias
    alias to: kibana.stats.response_time.max.ms
  </definition>
  <definition term="kibana_stats.kibana.status">
    type: alias
    alias to: kibana.stats.kibana.status
  </definition>
  <definition term="kibana_stats.os.memory.free_in_bytes">
    type: alias
    alias to: kibana.stats.os.memory.free_in_bytes
  </definition>
  <definition term="kibana_stats.process.uptime_in_millis">
    type: alias
    alias to: kibana.stats.process.uptime.ms
  </definition>
  <definition term="kibana_stats.process.memory.heap.size_limit">
    type: alias
    alias to: kibana.stats.process.memory.heap.size_limit.bytes
  </definition>
  <definition term="kibana_stats.concurrent_connections">
    type: alias
    alias to: kibana.stats.concurrent_connections
  </definition>
  <definition term="kibana_stats.process.memory.resident_set_size_in_bytes">
    type: alias
    alias to: kibana.stats.process.memory.resident_set_size.bytes
  </definition>
  <definition term="kibana_stats.os.load.1m">
    type: alias
    alias to: kibana.stats.os.load.1m
  </definition>
  <definition term="kibana_stats.os.load.5m">
    type: alias
    alias to: kibana.stats.os.load.5m
  </definition>
  <definition term="kibana_stats.os.load.15m">
    type: alias
    alias to: kibana.stats.os.load.15m
  </definition>
  <definition term="kibana_stats.process.event_loop_delay">
    type: alias
    alias to: kibana.stats.process.event_loop_delay.ms
  </definition>
  <definition term="kibana_stats.process.event_loop_utilization.active">
    type: alias
    alias to: kibana.stats.process.event_loop_utilization.active
  </definition>
  <definition term="kibana_stats.process.event_loop_utilization.idle">
    type: alias
    alias to: kibana.stats.process.event_loop_utilization.idle
  </definition>
  <definition term="kibana_stats.process.event_loop_utilization.utilization">
    type: alias
    alias to: kibana.stats.process.event_loop_utilization.utilization
  </definition>
  <definition term="kibana_stats.requests.total">
    type: alias
    alias to: kibana.stats.request.total
  </definition>
  <definition term="kibana_stats.requests.disconnects">
    type: alias
    alias to: kibana.stats.request.disconnects
  </definition>
  <definition term="kibana_stats.response_times.max">
    type: alias
    alias to: kibana.stats.response_time.max.ms
  </definition>
  <definition term="kibana_stats.response_times.average">
    type: alias
    alias to: kibana.stats.response_time.avg.ms
  </definition>
  <definition term="kibana_stats.kibana.uuid">
    type: alias
    alias to: service.id
  </definition>
  <definition term="kibana.elasticsearch.cluster.id">
    type: keyword
  </definition>
</definitions>


## cluster_actions

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Kibana cluster actions metrics.
<definitions>
  <definition term="kibana.cluster_actions.kibana.status">
    type: keyword
  </definition>
  <definition term="kibana.cluster_actions.overdue.count">
    type: long
  </definition>
  <definition term="kibana.cluster_actions.overdue.delay.p50">
    type: float
  </definition>
  <definition term="kibana.cluster_actions.overdue.delay.p99">
    type: float
  </definition>
</definitions>


## cluster_rules

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Kibana cluster rule metrics.
<definitions>
  <definition term="kibana.cluster_rules.kibana.status">
    type: keyword
  </definition>
  <definition term="kibana.cluster_rules.overdue.count">
    type: long
  </definition>
  <definition term="kibana.cluster_rules.overdue.delay.p50">
    type: float
  </definition>
  <definition term="kibana.cluster_rules.overdue.delay.p99">
    type: float
  </definition>
</definitions>


## node_actions

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Kibana node actions metrics.
<definitions>
  <definition term="kibana.node_actions.kibana.status">
    type: keyword
  </definition>
  <definition term="kibana.node_actions.failures">
    type: long
  </definition>
  <definition term="kibana.node_actions.executions">
    type: long
  </definition>
  <definition term="kibana.node_actions.timeouts">
    type: long
  </definition>
</definitions>


## node_rules

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Kibana node rule metrics.
<definitions>
  <definition term="kibana.node_rules.kibana.status">
    type: keyword
  </definition>
  <definition term="kibana.node_rules.failures">
    type: long
  </definition>
  <definition term="kibana.node_rules.executions">
    type: long
  </definition>
  <definition term="kibana.node_rules.timeouts">
    type: long
  </definition>
</definitions>


## stats

Kibana stats and run-time metrics.
<definitions>
  <definition term="kibana.stats.kibana.status">
    type: keyword
  </definition>
  <definition term="kibana.stats.usage.index">
    type: keyword
  </definition>
  <definition term="kibana.stats.uuid">
    Kibana instance UUID
    type: alias
    alias to: service.id
  </definition>
  <definition term="kibana.stats.name">
    Kibana instance name
    type: keyword
  </definition>
  <definition term="kibana.stats.index">
    Name of Kibana's internal index
    type: keyword
  </definition>
  <definition term="kibana.stats.host.name">
    Kibana instance hostname
    type: keyword
  </definition>
  <definition term="kibana.stats.transport_address">
    Kibana server's hostname and port
    type: alias
    alias to: service.address
  </definition>
  <definition term="kibana.stats.version">
    Kibana version
    type: alias
    alias to: service.version
  </definition>
  <definition term="kibana.stats.snapshot">
    Whether the Kibana build is a snapshot build
    type: boolean
  </definition>
  <definition term="kibana.stats.status">
    Kibana instance's health status
    type: keyword
  </definition>
  <definition term="kibana.stats.os.distro">
    type: keyword
  </definition>
  <definition term="kibana.stats.os.distroRelease">
    type: keyword
  </definition>
  <definition term="kibana.stats.os.platform">
    type: keyword
  </definition>
  <definition term="kibana.stats.os.platformRelease">
    type: keyword
  </definition>
  <definition term="kibana.stats.os.memory.free_in_bytes">
    type: long
  </definition>
  <definition term="kibana.stats.os.memory.total_in_bytes">
    type: long
  </definition>
  <definition term="kibana.stats.os.memory.used_in_bytes">
    type: long
  </definition>
  <definition term="kibana.stats.os.cpuacct.control_group">
    type: keyword
  </definition>
  <definition term="kibana.stats.os.cpuacct.usage_nanos">
    type: long
  </definition>
  <definition term="kibana.stats.os.cgroup_memory.current_in_bytes">
    type: long
  </definition>
  <definition term="kibana.stats.os.cgroup_memory.swap_current_in_bytes">
    type: long
  </definition>
  <definition term="kibana.stats.os.load.1m">
    type: half_float
  </definition>
  <definition term="kibana.stats.os.load.5m">
    type: half_float
  </definition>
  <definition term="kibana.stats.os.load.15m">
    type: half_float
  </definition>
  <definition term="kibana.stats.concurrent_connections">
    Number of client connections made to the server. Note that browsers can send multiple simultaneous connections to request multiple server assets at once, and they can re-use established connections.
    type: long
  </definition>
</definitions>


## process

Process metrics
<definitions>
  <definition term="kibana.stats.process.memory.resident_set_size.bytes">
    type: long
  </definition>
  <definition term="kibana.stats.process.memory.array_buffers.bytes">
    type: long
  </definition>
  <definition term="kibana.stats.process.memory.external.bytes">
    type: long
  </definition>
  <definition term="kibana.stats.process.uptime.ms">
    type: long
  </definition>
  <definition term="kibana.stats.process.event_loop_delay.ms">
    Event loop delay in milliseconds
    type: scaled_float
  </definition>
</definitions>


## event_loop_utilization

The ratio of time the event loop is not idling in the event provider to the total time the event loop is running.
<definitions>
  <definition term="kibana.stats.process.event_loop_utilization.active">
    Duration of time event loop has been active since last measurement.
    type: scaled_float
  </definition>
  <definition term="kibana.stats.process.event_loop_utilization.idle">
    Duration of time event loop has been idle since last measurement.
    type: scaled_float
  </definition>
  <definition term="kibana.stats.process.event_loop_utilization.utilization">
    Computed utilization value representing ratio of active to idle time since last measurement.
    type: scaled_float
  </definition>
</definitions>


## memory.heap

Process heap metrics
<definitions>
  <definition term="kibana.stats.process.memory.heap.total.bytes">
    Total heap allocated to process in bytes
    type: long
    format: bytes
  </definition>
  <definition term="kibana.stats.process.memory.heap.used.bytes">
    Heap used by process in bytes
    type: long
    format: bytes
  </definition>
  <definition term="kibana.stats.process.memory.heap.size_limit.bytes">
    Max. old space size allocated to Node.js process, in bytes
    type: long
    format: bytes
  </definition>
  <definition term="kibana.stats.process.memory.heap.uptime.ms">
    Uptime of process in milliseconds
    type: long
  </definition>
</definitions>


## request

Request count metrics
<definitions>
  <definition term="kibana.stats.request.disconnects">
    Number of requests that were disconnected
    type: long
  </definition>
  <definition term="kibana.stats.request.total">
    Total number of requests
    type: long
  </definition>
</definitions>


## response_time

Response times metrics
<definitions>
  <definition term="kibana.stats.response_time.avg.ms">
    Average response time in milliseconds
    type: long
  </definition>
  <definition term="kibana.stats.response_time.max.ms">
    Maximum response time in milliseconds
    type: long
  </definition>
</definitions>


## elasticsearch_client

Elasticsearch Client's stats
<definitions>
  <definition term="kibana.stats.elasticsearch_client.total_active_sockets">
    Total number of active sockets
    type: integer
  </definition>
  <definition term="kibana.stats.elasticsearch_client.total_idle_sockets">
    Total number of idle sockets
    type: integer
  </definition>
  <definition term="kibana.stats.elasticsearch_client.total_queued_requests">
    Total number of queued requests
    type: integer
  </definition>
</definitions>


## status

Status fields
<definitions>
  <definition term="kibana.status.name">
    Kibana instance name.
    type: keyword
  </definition>
  <definition term="kibana.status.uuid">
    Kibana instance uuid.
    type: alias
    alias to: service.id
  </definition>
  <definition term="kibana.status.version.number">
    Kibana version number.
    type: alias
    alias to: service.version
  </definition>
  <definition term="kibana.status.status.overall.state">
    Kibana overall state (v7 format).
    type: keyword
  </definition>
  <definition term="kibana.status.status.overall.level">
    Kibana overall level (v8 format).
    type: keyword
  </definition>
  <definition term="kibana.status.status.overall.summary">
    Kibana overall state in a human-readable format.
    type: text
  </definition>
  <definition term="kibana.status.status.core.elasticsearch.level">
    Kibana Elasticsearch client's status
    type: keyword
  </definition>
  <definition term="kibana.status.status.core.elasticsearch.summary">
    Kibana Elasticsearch client's status in a human-readable format.
    type: text
  </definition>
  <definition term="kibana.status.status.core.savedObjects.level">
    Kibana Saved Objects client's status
    type: keyword
  </definition>
  <definition term="kibana.status.status.core.savedObjects.summary">
    Kibana Saved Objects client's status in a human-readable format.
    type: text
  </definition>
</definitions>


## metrics

Metrics fields
<definitions>
  <definition term="kibana.status.metrics.concurrent_connections">
    Current concurrent connections.
    type: long
  </definition>
</definitions>


## requests

Request statistics.
<definitions>
  <definition term="kibana.status.metrics.requests.disconnects">
    Total number of disconnected connections.
    type: long
  </definition>
  <definition term="kibana.status.metrics.requests.total">
    Total number of connections.
    type: long
  </definition>
</definitions>