﻿---
title: IIS fields
description: iis module Application pool process stats. Worker process overview. Common Language Runtime overview. Memory overview. LocksAndThreads overview. Webserver...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-iis
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# IIS fields
iis module

## iis


## application_pool

Application pool process stats.
<definitions>
  <definition term="iis.application_pool.name">
    application pool name
    type: keyword
  </definition>
</definitions>


## process

Worker process overview.
<definitions>
  <definition term="iis.application_pool.process.handle_count">
    The number of handles.
    type: long
  </definition>
  <definition term="iis.application_pool.process.io_read_operations_per_sec">
    IO read operations per sec.
    type: float
  </definition>
  <definition term="iis.application_pool.process.io_write_operations_per_sec">
    IO write operations per sec.
    type: float
  </definition>
  <definition term="iis.application_pool.process.virtual_bytes">
    Memory virtual bytes.
    type: float
  </definition>
  <definition term="iis.application_pool.process.cpu_usage_perc">
    The CPU usage percentage.
    type: float
  </definition>
  <definition term="iis.application_pool.process.thread_count">
    The number of threats.
    type: long
  </definition>
  <definition term="iis.application_pool.process.working_set">
    Memory working set.
    type: float
  </definition>
  <definition term="iis.application_pool.process.private_bytes">
    Memory private bytes.
    type: float
  </definition>
  <definition term="iis.application_pool.process.page_faults_per_sec">
    Memory page faults.
    type: float
  </definition>
</definitions>


## net_clr

Common Language Runtime overview.
<definitions>
  <definition term="iis.application_pool.net_clr.finallys_per_sec">
    The number of finallys per sec.
    type: float
  </definition>
  <definition term="iis.application_pool.net_clr.throw_to_catch_depth_per_sec">
    Throw to catch depth count per sec.
    type: float
  </definition>
  <definition term="iis.application_pool.net_clr.total_exceptions_thrown">
    Total number of exceptions thrown.
    type: long
  </definition>
  <definition term="iis.application_pool.net_clr.filters_per_sec">
    Number of filters per sec.
    type: float
  </definition>
  <definition term="iis.application_pool.net_clr.exceptions_thrown_per_sec">
    Number of Exceptions Thrown / sec.
    type: float
  </definition>
</definitions>


## memory

Memory overview.
<definitions>
  <definition term="iis.application_pool.net_clr.memory.bytes_in_all_heaps">
    Number of bytes in all heaps.
    type: float
  </definition>
  <definition term="iis.application_pool.net_clr.memory.gen_0_collections">
    Number of Gen 0 Collections.
    type: float
  </definition>
  <definition term="iis.application_pool.net_clr.memory.gen_1_collections">
    Number of Gen 1 Collections.
    type: float
  </definition>
  <definition term="iis.application_pool.net_clr.memory.gen_2_collections">
    Number of Gen 2 Collections.
    type: float
  </definition>
  <definition term="iis.application_pool.net_clr.memory.total_committed_bytes">
    Number of total committed bytes.
    type: float
  </definition>
  <definition term="iis.application_pool.net_clr.memory.allocated_bytes_per_sec">
    Allocated Bytes/sec.
    type: float
  </definition>
  <definition term="iis.application_pool.net_clr.memory.gen_0_heap_size">
    Gen 0 heap size.
    type: float
  </definition>
  <definition term="iis.application_pool.net_clr.memory.gen_1_heap_size">
    Gen 1 heap size.
    type: float
  </definition>
  <definition term="iis.application_pool.net_clr.memory.gen_2_heap_size">
    Gen 2 heap size.
    type: float
  </definition>
  <definition term="iis.application_pool.net_clr.memory.large_object_heap_size">
    Large Object Heap size.
    type: float
  </definition>
  <definition term="iis.application_pool.net_clr.memory.time_in_gc_perc">
    type: float
  </definition>
</definitions>


## locks_and_threads

LocksAndThreads overview.
<definitions>
  <definition term="iis.application_pool.net_clr.locks_and_threads.contention_rate_per_sec">
    Contention Rate / sec.
    type: float
  </definition>
  <definition term="iis.application_pool.net_clr.locks_and_threads.current_queue_length">
    Current Queue Length.
    type: float
  </definition>
</definitions>


## webserver

Webserver related metrics.

## process

The process related stats.
<definitions>
  <definition term="iis.webserver.process.cpu_usage_perc">
    The CPU usage percentage.
    type: float
  </definition>
  <definition term="iis.webserver.process.handle_count">
    The number of handles.
    type: float
  </definition>
  <definition term="iis.webserver.process.virtual_bytes">
    Memory virtual bytes.
    type: float
  </definition>
  <definition term="iis.webserver.process.thread_count">
    The number of threads.
    type: long
  </definition>
  <definition term="iis.webserver.process.working_set">
    Memory working set.
    type: float
  </definition>
  <definition term="iis.webserver.process.private_bytes">
    Memory private bytes.
    type: float
  </definition>
  <definition term="iis.webserver.process.worker_process_count">
    Number of worker processes running.
    type: float
  </definition>
  <definition term="iis.webserver.process.page_faults_per_sec">
    Memory page faults.
    type: float
  </definition>
  <definition term="iis.webserver.process.io_read_operations_per_sec">
    IO read operations per sec.
    type: float
  </definition>
  <definition term="iis.webserver.process.io_write_operations_per_sec">
    IO write operations per sec.
    type: float
  </definition>
</definitions>


## asp_net

Common Language Runtime overview.
<definitions>
  <definition term="iis.webserver.asp_net.application_restarts">
    Number of applications restarts.
    type: float
  </definition>
  <definition term="iis.webserver.asp_net.request_wait_time">
    Request wait time.
    type: long
  </definition>
</definitions>


## asp_net_application

ASP.NET application overview.
<definitions>
  <definition term="iis.webserver.asp_net_application.errors_total_per_sec">
    Total number of errors per sec.
    type: float
  </definition>
  <definition term="iis.webserver.asp_net_application.pipeline_instance_count">
    The pipeline instance count.
    type: float
  </definition>
  <definition term="iis.webserver.asp_net_application.requests_per_sec">
    Number of requests per sec.
    type: float
  </definition>
  <definition term="iis.webserver.asp_net_application.requests_executing">
    Number of requests executing.
    type: float
  </definition>
  <definition term="iis.webserver.asp_net_application.requests_in_application_queue">
    Number of requests in the application queue.
    type: float
  </definition>
</definitions>


## cache

The cache overview.
<definitions>
  <definition term="iis.webserver.cache.current_file_cache_memory_usage">
    The current file cache memory usage size.
    type: float
  </definition>
  <definition term="iis.webserver.cache.current_files_cached">
    The number of current files cached.
    type: float
  </definition>
  <definition term="iis.webserver.cache.current_uris_cached">
    The number of current uris cached.
    type: float
  </definition>
  <definition term="iis.webserver.cache.file_cache_hits">
    The number of file cache hits.
    type: float
  </definition>
  <definition term="iis.webserver.cache.file_cache_misses">
    The number of file cache misses.
    type: float
  </definition>
  <definition term="iis.webserver.cache.maximum_file_cache_memory_usage">
    The max file cache size.
    type: float
  </definition>
  <definition term="iis.webserver.cache.output_cache_current_items">
    The number of output cache current items.
    type: float
  </definition>
  <definition term="iis.webserver.cache.output_cache_current_memory_usage">
    The output cache memory usage size.
    type: float
  </definition>
  <definition term="iis.webserver.cache.output_cache_total_hits">
    The output cache total hits count.
    type: float
  </definition>
  <definition term="iis.webserver.cache.output_cache_total_misses">
    The output cache total misses count.
    type: float
  </definition>
  <definition term="iis.webserver.cache.total_files_cached">
    the total number of files cached.
    type: float
  </definition>
  <definition term="iis.webserver.cache.total_uris_cached">
    The total number of URIs cached.
    type: float
  </definition>
  <definition term="iis.webserver.cache.uri_cache_hits">
    The number of URIs cached hits.
    type: float
  </definition>
  <definition term="iis.webserver.cache.uri_cache_misses">
    The number of URIs cache misses.
    type: float
  </definition>
</definitions>


## network

The network related stats.
<definitions>
  <definition term="iis.webserver.network.anonymous_users_per_sec">
    The number of anonymous users per sec.
    type: float
  </definition>
  <definition term="iis.webserver.network.bytes_received_per_sec">
    The size of bytes received per sec.
    type: float
  </definition>
  <definition term="iis.webserver.network.bytes_sent_per_sec">
    The size of bytes sent per sec.
    type: float
  </definition>
  <definition term="iis.webserver.network.current_anonymous_users">
    The number of current anonymous users.
    type: float
  </definition>
  <definition term="iis.webserver.network.current_connections">
    The number of current connections.
    type: float
  </definition>
  <definition term="iis.webserver.network.current_non_anonymous_users">
    The number of current non anonymous users.
    type: float
  </definition>
  <definition term="iis.webserver.network.delete_requests_per_sec">
    Number of DELETE requests per sec.
    type: float
  </definition>
  <definition term="iis.webserver.network.get_requests_per_sec">
    Number of GET requests per sec.
    type: float
  </definition>
  <definition term="iis.webserver.network.maximum_connections">
    Number of maximum connections.
    type: float
  </definition>
  <definition term="iis.webserver.network.post_requests_per_sec">
    Number of POST requests per sec.
    type: float
  </definition>
  <definition term="iis.webserver.network.service_uptime">
    Service uptime.
    type: float
  </definition>
  <definition term="iis.webserver.network.total_anonymous_users">
    Total number of anonymous users.
    type: float
  </definition>
  <definition term="iis.webserver.network.total_bytes_received">
    Total size of bytes received.
    type: float
  </definition>
  <definition term="iis.webserver.network.total_bytes_sent">
    Total size of bytes sent.
    type: float
  </definition>
  <definition term="iis.webserver.network.total_connection_attempts">
    The total number of connection attempts.
    type: float
  </definition>
  <definition term="iis.webserver.network.total_delete_requests">
    The total number of DELETE requests.
    type: float
  </definition>
  <definition term="iis.webserver.network.total_get_requests">
    The total number of GET requests.
    type: float
  </definition>
  <definition term="iis.webserver.network.total_non_anonymous_users">
    The total number of non anonymous users.
    type: float
  </definition>
  <definition term="iis.webserver.network.total_post_requests">
    The total number of POST requests.
    type: float
  </definition>
</definitions>


## website

Website related metrics.
<definitions>
  <definition term="iis.website.name">
    website name
    type: keyword
  </definition>
</definitions>


## network

The network overview.
<definitions>
  <definition term="iis.website.network.bytes_received_per_sec">
    The bytes received per sec size.
    type: float
  </definition>
  <definition term="iis.website.network.bytes_sent_per_sec">
    The bytes sent per sec size.
    type: float
  </definition>
  <definition term="iis.website.network.current_connections">
    The number of current connections.
    type: float
  </definition>
  <definition term="iis.website.network.delete_requests_per_sec">
    The number of DELETE requests per sec.
    type: float
  </definition>
  <definition term="iis.website.network.get_requests_per_sec">
    The number of GET requests per sec.
    type: float
  </definition>
  <definition term="iis.website.network.maximum_connections">
    The number of maximum connections.
    type: float
  </definition>
  <definition term="iis.website.network.post_requests_per_sec">
    The number of POST requests per sec.
    type: float
  </definition>
  <definition term="iis.website.network.put_requests_per_sec">
    The number of PUT requests per sec.
    type: float
  </definition>
  <definition term="iis.website.network.service_uptime">
    The service uptime.
    type: float
  </definition>
  <definition term="iis.website.network.total_bytes_received">
    The total number of bytes received.
    type: float
  </definition>
  <definition term="iis.website.network.total_bytes_sent">
    The  total number of bytes sent.
    type: float
  </definition>
  <definition term="iis.website.network.total_connection_attempts">
    The total number of connection attempts.
    type: float
  </definition>
  <definition term="iis.website.network.total_delete_requests">
    The total number of DELETE requests.
    type: float
  </definition>
  <definition term="iis.website.network.total_get_requests">
    The total number of GET requests.
    type: float
  </definition>
  <definition term="iis.website.network.total_post_requests">
    The total number of POST requests.
    type: float
  </definition>
  <definition term="iis.website.network.total_put_requests">
    The total number of PUT requests.
    type: float
  </definition>
</definitions>