﻿---
title: Golang fields
description: Golang module expvar The Go program heap information exposed by expvar. Garbage collector summary. Total GC pause duration over lifetime of process. Last...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-golang
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Golang fields
Golang module

## golang


## expvar

expvar
<definitions>
  <definition term="golang.expvar.cmdline">
    The cmdline of this Go program start with.
    type: keyword
  </definition>
</definitions>


## heap

The Go program heap information exposed by expvar.
<definitions>
  <definition term="golang.heap.cmdline">
    The cmdline of this Go program start with.
    type: keyword
  </definition>
</definitions>


## gc

Garbage collector summary.

## total_pause

Total GC pause duration over lifetime of process.
<definitions>
  <definition term="golang.heap.gc.total_pause.ns">
    Duration in Ns.
    type: long
  </definition>
  <definition term="golang.heap.gc.total_count">
    Total number of GC was happened.
    type: long
  </definition>
  <definition term="golang.heap.gc.next_gc_limit">
    Next collection will happen when HeapAlloc > this amount.
    type: long
    format: bytes
  </definition>
  <definition term="golang.heap.gc.cpu_fraction">
    Fraction of CPU time used by GC.
    type: float
  </definition>
</definitions>


## pause

Last GC pause durations during the monitoring period.
<definitions>
  <definition term="golang.heap.gc.pause.count">
    Count of GC pause duration during this collect period.
    type: long
  </definition>
</definitions>


## sum

Total GC pause duration during this collect period.
<definitions>
  <definition term="golang.heap.gc.pause.sum.ns">
    Duration in Ns.
    type: long
  </definition>
</definitions>


## max

Max GC pause duration during this collect period.
<definitions>
  <definition term="golang.heap.gc.pause.max.ns">
    Duration in Ns.
    type: long
  </definition>
</definitions>


## avg

Average GC pause duration during this collect period.
<definitions>
  <definition term="golang.heap.gc.pause.avg.ns">
    Duration in Ns.
    type: long
  </definition>
</definitions>


## system

Heap summary,which bytes was obtained from system.
<definitions>
  <definition term="golang.heap.system.total">
    Total bytes obtained from system (sum of XxxSys below).
    type: long
    format: bytes
  </definition>
  <definition term="golang.heap.system.obtained">
    Via HeapSys, bytes obtained from system. heap_sys = heap_idle + heap_inuse.
    type: long
    format: bytes
  </definition>
  <definition term="golang.heap.system.stack">
    Bytes used by stack allocator, and these bytes was obtained from system.
    type: long
    format: bytes
  </definition>
  <definition term="golang.heap.system.released">
    Bytes released to the OS.
    type: long
    format: bytes
  </definition>
</definitions>


## allocations

Heap allocations summary.
<definitions>
  <definition term="golang.heap.allocations.mallocs">
    Number of mallocs.
    type: long
  </definition>
  <definition term="golang.heap.allocations.frees">
    Number of frees.
    type: long
  </definition>
  <definition term="golang.heap.allocations.objects">
    Total number of allocated objects.
    type: long
  </definition>
  <definition term="golang.heap.allocations.total">
    Bytes allocated (even if freed) throughout the lifetime.
    type: long
    format: bytes
  </definition>
  <definition term="golang.heap.allocations.allocated">
    Bytes allocated and not yet freed (same as Alloc above).
    type: long
    format: bytes
  </definition>
  <definition term="golang.heap.allocations.idle">
    Bytes in idle spans.
    type: long
    format: bytes
  </definition>
  <definition term="golang.heap.allocations.active">
    Bytes in non-idle span.
    type: long
    format: bytes
  </definition>
</definitions>