﻿---
title: Google Cloud Platform fields
description: GCP module Google Cloud Billing metrics Google Cloud Carbon Footprint metrics Google Cloud Compute metrics Google Cloud Dataproc metrics Google Cloud...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-gcp
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Google Cloud Platform fields
GCP module
<definitions>
  <definition term="gcp.labels">
    GCP monitoring metrics labels
    type: object
  </definition>
  <definition term="gcp.metrics.*.*.*.*">
    Metrics that returned from Google Cloud API query.
    type: object
  </definition>
</definitions>


## billing

Google Cloud Billing metrics
<definitions>
  <definition term="gcp.billing.cost_type">
    Cost types include regular, tax, adjustment, and rounding_error.
    type: keyword
  </definition>
  <definition term="gcp.billing.invoice_month">
    Billing report month.
    type: keyword
  </definition>
  <definition term="gcp.billing.project_id">
    Project ID of the billing report belongs to.
    type: keyword
  </definition>
  <definition term="gcp.billing.total">
    Total billing amount.
    type: float
  </definition>
  <definition term="gcp.billing.sku_id">
    The ID of the resource used by the service.
    type: keyword
  </definition>
  <definition term="gcp.billing.sku_description">
    A description of the resource type used by the service. For example, a resource type for Cloud Storage is Standard Storage US.
    type: keyword
  </definition>
  <definition term="gcp.billing.service_id">
    The ID of the service that the usage is associated with.
    type: keyword
  </definition>
  <definition term="gcp.billing.service_description">
    The Google Cloud service that reported the Cloud Billing data.
    type: keyword
  </definition>
  <definition term="gcp.billing.tags">
    A collection of key-value pairs that provide additional metadata.
    type: nested
  </definition>
  <definition term="gcp.billing.effective_price">
    The charged price for usage of the Google Cloud SKUs and SKU tiers. Reflects contract pricing if applicable, otherwise, it's the list price.
    type: float
  </definition>
  <definition term="gcp.billing.usage_start_time Elastic Stack: Beta since 9.2">
    The start time of the usage period for this billing record.
    type: date
  </definition>
  <definition term="gcp.billing.usage_end_time Elastic Stack: Beta since 9.2">
    The end time of the usage period for this billing record.
    type: date
  </definition>
  <definition term="gcp.billing.location.region Elastic Stack: Beta since 9.2">
    The geographic region where the resource was used (e.g., us-central1, europe-west1).
    type: keyword
  </definition>
  <definition term="gcp.billing.location.zone Elastic Stack: Beta since 9.2">
    The specific zone within the region (e.g., us-central1-a).
    type: keyword
  </definition>
  <definition term="gcp.billing.location.country Elastic Stack: Beta since 9.2">
    The country code for the resource location (e.g., US, GB).
    type: keyword
  </definition>
  <definition term="gcp.billing.labels Elastic Stack: Beta since 9.2">
    Resource labels as key-value pairs. Labels are user-defined metadata that can be attached to GCP resources.
    type: object
  </definition>
</definitions>


## carbon

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Google Cloud Carbon Footprint metrics
<definitions>
  <definition term="gcp.carbon.project_id">
    Project ID the carbon footprint report belongs to.
    type: keyword
  </definition>
  <definition term="gcp.carbon.project_name">
    Project name the carbon footprint report belongs to.
    type: keyword
  </definition>
  <definition term="gcp.carbon.service_id">
    Service ID for the carbon footprint usage.
    type: keyword
  </definition>
  <definition term="gcp.carbon.service_description">
    Service description for the carbon footprint usage.
    type: keyword
  </definition>
  <definition term="gcp.carbon.region">
    Region for the carbon fooprint usage.
    type: keyword
  </definition>
  <definition term="gcp.carbon.footprint.scope1">
    Scope 1 carbon footprint.
    type: float
  </definition>
  <definition term="gcp.carbon.footprint.scope2.location">
    Scope 2 carbon footprint using location-based methodology.
    type: float
  </definition>
  <definition term="gcp.carbon.footprint.scope2.market">
    Scope 2 carbon footprint using market-based methodology.
    type: float
  </definition>
  <definition term="gcp.carbon.footprint.scope3">
    Scope 3 carbon footprint.
    type: float
  </definition>
  <definition term="gcp.carbon.footprint.offsets">
    Total carbon offsets.
    type: float
  </definition>
</definitions>


## compute

Google Cloud Compute metrics
<definitions>
  <definition term="gcp.compute.firewall.dropped.bytes">
    Incoming bytes dropped by the firewall
    type: long
  </definition>
  <definition term="gcp.compute.firewall.dropped_packets_count.value">
    Incoming packets dropped by the firewall
    type: long
  </definition>
  <definition term="gcp.compute.instance.cpu.reserved_cores.value">
    Number of cores reserved on the host of the instance
    type: double
  </definition>
  <definition term="gcp.compute.instance.cpu.usage_time.sec">
    Usage for all cores in seconds
    type: double
  </definition>
  <definition term="gcp.compute.instance.cpu.usage.pct">
    The fraction of the allocated CPU that is currently in use on the instance
    type: double
  </definition>
  <definition term="gcp.compute.instance.disk.read.bytes">
    Count of bytes read from disk
    type: long
  </definition>
  <definition term="gcp.compute.instance.disk.read_ops_count.value">
    Count of disk read IO operations
    type: long
  </definition>
  <definition term="gcp.compute.instance.disk.write.bytes">
    Count of bytes written to disk
    type: long
  </definition>
  <definition term="gcp.compute.instance.disk.write_ops_count.value">
    Count of disk write IO operations
    type: long
  </definition>
  <definition term="gcp.compute.instance.memory.balloon.ram_size.value">
    The total amount of memory in the VM. This metric is only available for VMs that belong to the e2 family.
    type: long
  </definition>
  <definition term="gcp.compute.instance.memory.balloon.ram_used.value">
    Memory currently used in the VM. This metric is only available for VMs that belong to the e2 family.
    type: long
  </definition>
  <definition term="gcp.compute.instance.memory.balloon.swap_in.bytes">
    The amount of memory read into the guest from its own swap space. This metric is only available for VMs that belong to the e2 family.
    type: long
  </definition>
  <definition term="gcp.compute.instance.memory.balloon.swap_out.bytes">
    The amount of memory written from the guest to its own swap space. This metric is only available for VMs that belong to the e2 family.
    type: long
  </definition>
  <definition term="gcp.compute.instance.network.ingress.bytes">
    Count of bytes received from the network
    type: long
  </definition>
  <definition term="gcp.compute.instance.network.ingress.packets.count">
    Count of packets received from the network
    type: long
  </definition>
  <definition term="gcp.compute.instance.network.egress.bytes">
    Count of bytes sent over the network
    type: long
  </definition>
  <definition term="gcp.compute.instance.network.egress.packets.count">
    Count of packets sent over the network
    type: long
  </definition>
  <definition term="gcp.compute.instance.uptime.sec">
    Number of seconds the VM has been running.
    type: long
  </definition>
  <definition term="gcp.compute.instance.uptime_total.sec">
    Elapsed time since the VM was started, in seconds. Sampled every 60 seconds. After sampling, data is not visible for up to 120 seconds.
    type: long
  </definition>
</definitions>


## dataproc

Google Cloud Dataproc metrics
<definitions>
  <definition term="gcp.dataproc.cluster.hdfs.datanodes.count">
    Indicates the number of HDFS DataNodes that are running inside a cluster.
    type: long
  </definition>
  <definition term="gcp.dataproc.cluster.hdfs.storage_capacity.value">
    Indicates capacity of HDFS system running on cluster in GB.
    type: double
  </definition>
  <definition term="gcp.dataproc.cluster.hdfs.storage_utilization.value">
    The percentage of HDFS storage currently used.
    type: double
  </definition>
  <definition term="gcp.dataproc.cluster.hdfs.unhealthy_blocks.count">
    Indicates the number of unhealthy blocks inside the cluster.
    type: long
  </definition>
  <definition term="gcp.dataproc.cluster.job.failed.count">
    Indicates the number of jobs that have failed on a cluster.
    type: long
  </definition>
  <definition term="gcp.dataproc.cluster.job.running.count">
    Indicates the number of jobs that are running on a cluster.
    type: long
  </definition>
  <definition term="gcp.dataproc.cluster.job.submitted.count">
    Indicates the number of jobs that have been submitted to a cluster.
    type: long
  </definition>
  <definition term="gcp.dataproc.cluster.operation.failed.count">
    Indicates the number of operations that have failed on a cluster.
    type: long
  </definition>
  <definition term="gcp.dataproc.cluster.operation.running.count">
    Indicates the number of operations that are running on a cluster.
    type: long
  </definition>
  <definition term="gcp.dataproc.cluster.operation.submitted.count">
    Indicates the number of operations that have been submitted to a cluster.
    type: long
  </definition>
  <definition term="gcp.dataproc.cluster.yarn.allocated_memory_percentage.value">
    The percentage of YARN memory is allocated.
    type: double
  </definition>
  <definition term="gcp.dataproc.cluster.yarn.apps.count">
    Indicates the number of active YARN applications.
    type: long
  </definition>
  <definition term="gcp.dataproc.cluster.yarn.containers.count">
    Indicates the number of YARN containers.
    type: long
  </definition>
  <definition term="gcp.dataproc.cluster.yarn.memory_size.value">
    Indicates the YARN memory size in GB.
    type: double
  </definition>
  <definition term="gcp.dataproc.cluster.yarn.nodemanagers.count">
    Indicates the number of YARN NodeManagers running inside cluster.
    type: long
  </definition>
  <definition term="gcp.dataproc.cluster.yarn.pending_memory_size.value">
    The current memory request, in GB, that is pending to be fulfilled by the scheduler.
    type: double
  </definition>
  <definition term="gcp.dataproc.cluster.yarn.virtual_cores.count">
    Indicates the number of virtual cores in YARN.
    type: long
  </definition>
  <definition term="gcp.dataproc.cluster.job.completion_time.value">
    The time jobs took to complete from the time the user submits a job to the time Dataproc reports it is completed.
    type: object
  </definition>
  <definition term="gcp.dataproc.cluster.job.duration.value">
    The time jobs have spent in a given state.
    type: object
  </definition>
  <definition term="gcp.dataproc.cluster.operation.completion_time.value">
    The time operations took to complete from the time the user submits a operation to the time Dataproc reports it is completed.
    type: object
  </definition>
  <definition term="gcp.dataproc.cluster.operation.duration.value">
    The time operations have spent in a given state.
    type: object
  </definition>
</definitions>


## firestore

Google Cloud Firestore metrics
<definitions>
  <definition term="gcp.firestore.document.delete.count">
    The number of successful document deletes.
    type: long
  </definition>
  <definition term="gcp.firestore.document.read.count">
    The number of successful document reads from queries or lookups.
    type: long
  </definition>
  <definition term="gcp.firestore.document.write.count">
    The number of successful document writes.
    type: long
  </definition>
</definitions>


## gke

`gke` contains the metrics that we scraped from GCP Stackdriver API containing monitoring metrics for GCP GKE
<definitions>
  <definition term="gcp.gke.container.cpu.core_usage_time.sec">
    Cumulative CPU usage on all cores used by the container in seconds. Sampled every 60 seconds.
    type: double
  </definition>
  <definition term="gcp.gke.container.cpu.limit_cores.value">
    CPU cores limit of the container. Sampled every 60 seconds.
    type: double
  </definition>
  <definition term="gcp.gke.container.cpu.limit_utilization.pct">
    The fraction of the CPU limit that is currently in use on the instance. This value cannot exceed 1 as usage cannot exceed the limit. Sampled every 60 seconds. After sampling, data is not visible for up to 240 seconds.
    type: double
  </definition>
  <definition term="gcp.gke.container.cpu.request_cores.value">
    Number of CPU cores requested by the container. Sampled every 60 seconds. After sampling, data is not visible for up to 120 seconds.
    type: double
  </definition>
  <definition term="gcp.gke.container.cpu.request_utilization.pct">
    The fraction of the requested CPU that is currently in use on the instance. This value can be greater than 1 as usage can exceed the request. Sampled every 60 seconds. After sampling, data is not visible for up to 240 seconds.
    type: double
  </definition>
  <definition term="gcp.gke.container.ephemeral_storage.limit.bytes">
    Local ephemeral storage limit in bytes. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.container.ephemeral_storage.request.bytes">
    Local ephemeral storage request in bytes. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.container.ephemeral_storage.used.bytes">
    Local ephemeral storage usage in bytes. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.container.memory.limit.bytes">
    Memory limit of the container in bytes. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.container.memory.limit_utilization.pct">
    The fraction of the memory limit that is currently in use on the instance. This value cannot exceed 1 as usage cannot exceed the limit. Sampled every 60 seconds. After sampling, data is not visible for up to 120 seconds.
    type: double
  </definition>
  <definition term="gcp.gke.container.memory.page_fault.count">
    Number of page faults, broken down by type, major and minor.
    type: long
  </definition>
  <definition term="gcp.gke.container.memory.request.bytes">
    Memory request of the container in bytes. Sampled every 60 seconds. After sampling, data is not visible for up to 120 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.container.memory.request_utilization.pct">
    The fraction of the requested memory that is currently in use on the instance. This value can be greater than 1 as usage can exceed the request. Sampled every 60 seconds. After sampling, data is not visible for up to 240 seconds.
    type: double
  </definition>
  <definition term="gcp.gke.container.memory.used.bytes">
    Memory usage in bytes. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.container.restart.count">
    Number of times the container has restarted. Sampled every 60 seconds. After sampling, data is not visible for up to 120 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.container.uptime.sec">
    Time in seconds that the container has been running. Sampled every 60 seconds.
    type: double
  </definition>
  <definition term="gcp.gke.node.cpu.allocatable_cores.value">
    Number of allocatable CPU cores on the node. Sampled every 60 seconds.
    type: double
  </definition>
  <definition term="gcp.gke.node.cpu.allocatable_utilization.pct">
    The fraction of the allocatable CPU that is currently in use on the instance. Sampled every 60 seconds. After sampling, data is not visible for up to 240 seconds.
    type: double
  </definition>
  <definition term="gcp.gke.node.cpu.core_usage_time.sec">
    Cumulative CPU usage on all cores used on the node in seconds. Sampled every 60 seconds.
    type: double
  </definition>
  <definition term="gcp.gke.node.cpu.total_cores.value">
    Total number of CPU cores on the node. Sampled every 60 seconds.
    type: double
  </definition>
  <definition term="gcp.gke.node.ephemeral_storage.allocatable.bytes">
    Local ephemeral storage bytes allocatable on the node. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.node.ephemeral_storage.inodes_free.value">
    Free number of inodes on local ephemeral storage. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.node.ephemeral_storage.inodes_total.value">
    Total number of inodes on local ephemeral storage. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.node.ephemeral_storage.total.bytes">
    Total ephemeral storage bytes on the node. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.node.ephemeral_storage.used.bytes">
    Local ephemeral storage bytes used by the node. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.node.memory.allocatable.bytes">
    Cumulative memory bytes used by the node. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.node.memory.allocatable_utilization.pct">
    The fraction of the allocatable memory that is currently in use on the instance. This value cannot exceed 1 as usage cannot exceed allocatable memory bytes. Sampled every 60 seconds. After sampling, data is not visible for up to 120 seconds.
    type: double
  </definition>
  <definition term="gcp.gke.node.memory.total.bytes">
    Number of bytes of memory allocatable on the node. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.node.memory.used.bytes">
    Cumulative memory bytes used by the node. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.node.network.received_bytes.count">
    Cumulative number of bytes received by the node over the network. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.node.network.sent_bytes.count">
    Cumulative number of bytes transmitted by the node over the network. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.node.pid_limit.value">
    The max PID of OS on the node. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.node.pid_used.value">
    The number of running process in the OS on the node. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.node_daemon.cpu.core_usage_time.sec">
    Cumulative CPU usage on all cores used by the node level system daemon in seconds. Sampled every 60 seconds.
    type: double
  </definition>
  <definition term="gcp.gke.node_daemon.memory.used.bytes">
    Memory usage by the system daemon in bytes. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.pod.network.received.bytes">
    Cumulative number of bytes received by the pod over the network. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.pod.network.sent.bytes">
    Cumulative number of bytes transmitted by the pod over the network. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.pod.volume.total.bytes">
    Total number of disk bytes available to the pod. Sampled every 60 seconds. After sampling, data is not visible for up to 120 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.pod.volume.used.bytes">
    Number of disk bytes used by the pod. Sampled every 60 seconds.
    type: long
  </definition>
  <definition term="gcp.gke.pod.volume.utilization.pct">
    The fraction of the volume that is currently being used by the instance. This value cannot be greater than 1 as usage cannot exceed the total available volume space. Sampled every 60 seconds. After sampling, data is not visible for up to 120 seconds.
    type: double
  </definition>
</definitions>


## loadbalancing

Google Cloud Load Balancing metrics
<definitions>
  <definition term="gcp.loadbalancing.https.backend_request.bytes">
    The number of bytes sent as requests from HTTP/S load balancer to backends.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.https.backend_request.count">
    The number of requests served by backends of HTTP/S load balancer.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.https.backend_response.bytes">
    The number of bytes sent as responses from backends (or cache) to external HTTP(S) load balancer.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.https.request.bytes">
    The number of bytes sent as requests from clients to HTTP/S load balancer.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.https.request.count">
    The number of requests served by HTTP/S load balancer.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.https.response.bytes">
    The number of bytes sent as responses from HTTP/S load balancer to clients.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.l3.external.egress.bytes">
    The number of bytes sent from external TCP/UDP network load balancer backend to client of the flow. For TCP flows it's counting bytes on application stream only.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.l3.external.egress_packets.count">
    The number of packets sent from external TCP/UDP network load balancer backend to client of the flow.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.l3.external.ingress.bytes">
    The number of bytes sent from client to external TCP/UDP network load balancer backend. For TCP flows it's counting bytes on application stream only.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.l3.external.ingress_packets.count">
    The number of packets sent from client to external TCP/UDP network load balancer backend.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.l3.internal.egress.bytes">
    The number of bytes sent from ILB backend to client (for TCP flows it's counting bytes on application stream only).
    type: long
  </definition>
  <definition term="gcp.loadbalancing.l3.internal.egress_packets.count">
    The number of packets sent from ILB backend to client of the flow.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.l3.internal.ingress.bytes">
    The number of bytes sent from client to ILB backend (for TCP flows it's counting bytes on application stream only).
    type: long
  </definition>
  <definition term="gcp.loadbalancing.l3.internal.ingress_packets.count">
    The number of packets sent from client to ILB backend.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.tcp_ssl_proxy.closed_connections.value">
    Number of connections that were terminated over TCP/SSL proxy.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.tcp_ssl_proxy.egress.bytes">
    Number of bytes sent from VM to client using proxy.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.tcp_ssl_proxy.ingress.bytes">
    Number of bytes sent from client to VM using proxy.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.tcp_ssl_proxy.new_connections.value">
    Number of connections that were created over TCP/SSL proxy.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.tcp_ssl_proxy.open_connections.value">
    Current number of outstanding connections through the TCP/SSL proxy.
    type: long
  </definition>
  <definition term="gcp.loadbalancing.https.backend_latencies.value">
    A distribution of the latency calculated from when the request was sent by the proxy to the backend until the proxy received from the backend the last byte of response.
    type: object
  </definition>
  <definition term="gcp.loadbalancing.https.external.regional.backend_latencies.value">
    A distribution of the latency calculated from when the request was sent by the proxy to the backend until the proxy received from the backend the last byte of response.
    type: object
  </definition>
  <definition term="gcp.loadbalancing.https.external.regional.total_latencies.value">
    A distribution of the latency calculated from when the request was received by the proxy until the proxy got ACK from client on last response byte.
    type: object
  </definition>
  <definition term="gcp.loadbalancing.https.frontend_tcp_rtt.value">
    A distribution of the RTT measured for each connection between client and proxy.
    type: object
  </definition>
  <definition term="gcp.loadbalancing.https.internal.backend_latencies.value">
    A distribution of the latency calculated from when the request was sent by the internal HTTP/S load balancer proxy to the backend until the proxy received from the backend the last byte of response.
    type: object
  </definition>
  <definition term="gcp.loadbalancing.https.internal.total_latencies.value">
    A distribution of the latency calculated from when the request was received by the internal HTTP/S load balancer proxy until the proxy got ACK from client on last response byte.
    type: object
  </definition>
  <definition term="gcp.loadbalancing.https.total_latencies.value">
    A distribution of the latency calculated from when the request was received by the external HTTP/S load balancer proxy until the proxy got ACK from client on last response byte.
    type: object
  </definition>
  <definition term="gcp.loadbalancing.l3.external.rtt_latencies.value">
    A distribution of the round trip time latency, measured over TCP connections for the external network load balancer.
    type: object
  </definition>
  <definition term="gcp.loadbalancing.l3.internal.rtt_latencies.value">
    A distribution of RTT measured over TCP connections for internal TCP/UDP load balancer flows.
    type: object
  </definition>
  <definition term="gcp.loadbalancing.tcp_ssl_proxy.frontend_tcp_rtt.value">
    A distribution of the smoothed RTT (in ms) measured by the proxy's TCP stack, each minute application layer bytes pass from proxy to client.
    type: object
  </definition>
</definitions>


## pubsub

Google Cloud PubSub metrics
<definitions>
  <definition term="gcp.pubsub.snapshot.backlog.bytes">
    Total byte size of the messages retained in a snapshot.
    type: long
  </definition>
  <definition term="gcp.pubsub.snapshot.backlog_bytes_by_region.bytes">
    Total byte size of the messages retained in a snapshot, broken down by Cloud region.
    type: long
  </definition>
  <definition term="gcp.pubsub.snapshot.config_updates.count">
    Cumulative count of configuration changes, grouped by operation type and result.
    type: long
  </definition>
  <definition term="gcp.pubsub.snapshot.num_messages.value">
    Number of messages retained in a snapshot.
    type: long
  </definition>
  <definition term="gcp.pubsub.snapshot.num_messages_by_region.value">
    Number of messages retained in a snapshot, broken down by Cloud region.
    type: long
  </definition>
  <definition term="gcp.pubsub.snapshot.oldest_message_age.sec">
    Age (in seconds) of the oldest message retained in a snapshot.
    type: long
  </definition>
  <definition term="gcp.pubsub.snapshot.oldest_message_age_by_region.sec">
    Age (in seconds) of the oldest message retained in a snapshot, broken down by Cloud region.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.ack_message.count">
    Cumulative count of messages acknowledged by Acknowledge requests, grouped by delivery type.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.backlog.bytes">
    Total byte size of the unacknowledged messages (a.k.a. backlog messages) in a subscription.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.byte_cost.bytes">
    Cumulative cost of operations, measured in bytes. This is used to measure quota utilization.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.config_updates.count">
    Cumulative count of configuration changes for each subscription, grouped by operation type and result.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.dead_letter_message.count">
    Cumulative count of messages published to dead letter topic, grouped by result.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.mod_ack_deadline_message.count">
    Cumulative count of messages whose deadline was updated by ModifyAckDeadline requests, grouped by delivery type.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.mod_ack_deadline_message_operation.count">
    Cumulative count of ModifyAckDeadline message operations, grouped by result.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.mod_ack_deadline_request.count">
    Cumulative count of ModifyAckDeadline requests, grouped by result.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.num_outstanding_messages.value">
    Number of messages delivered to a subscription's push endpoint, but not yet acknowledged.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.num_undelivered_messages.value">
    Number of unacknowledged messages (a.k.a. backlog messages) in a subscription.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.oldest_retained_acked_message_age.sec">
    Age (in seconds) of the oldest acknowledged message retained in a subscription.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.oldest_retained_acked_message_age_by_region.value">
    Age (in seconds) of the oldest acknowledged message retained in a subscription, broken down by Cloud region.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.oldest_unacked_message_age.sec">
    Age (in seconds) of the oldest unacknowledged message (a.k.a. backlog message) in a subscription.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.oldest_unacked_message_age_by_region.value">
    Age (in seconds) of the oldest unacknowledged message in a subscription, broken down by Cloud region.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.pull_ack_message_operation.count">
    Cumulative count of acknowledge message operations, grouped by result. For a definition of message operations, see Cloud Pub/Sub metric subscription/mod_ack_deadline_message_operation_count.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.pull_ack_request.count">
    Cumulative count of acknowledge requests, grouped by result.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.pull_message_operation.count">
    Cumulative count of pull message operations, grouped by result. For a definition of message operations, see Cloud Pub/Sub metric subscription/mod_ack_deadline_message_operation_count.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.pull_request.count">
    Cumulative count of pull requests, grouped by result.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.push_request.count">
    Cumulative count of push attempts, grouped by result. Unlike pulls, the push server implementation does not batch user messages. So each request only contains one user message. The push server retries on errors, so a given user message can appear multiple times.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.retained_acked.bytes">
    Total byte size of the acknowledged messages retained in a subscription.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.retained_acked_bytes_by_region.bytes">
    Total byte size of the acknowledged messages retained in a subscription, broken down by Cloud region.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.seek_request.count">
    Cumulative count of seek attempts, grouped by result.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.sent_message.count">
    Cumulative count of messages sent by Cloud Pub/Sub to subscriber clients, grouped by delivery type.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.streaming_pull_ack_message_operation.count">
    Cumulative count of StreamingPull acknowledge message operations, grouped by result. For a definition of message operations, see Cloud Pub/Sub metric subscription/mod_ack_deadline_message_operation_count.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.streaming_pull_ack_request.count">
    Cumulative count of streaming pull requests with non-empty acknowledge ids, grouped by result.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.streaming_pull_message_operation.count">
    Cumulative count of streaming pull message operations, grouped by result. For a definition of message operations, see Cloud Pub/Sub metric <code>subscription/mod_ack_deadline_message_operation_count
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.streaming_pull_mod_ack_deadline_message_operation.count">
    Cumulative count of StreamingPull ModifyAckDeadline operations, grouped by result.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.streaming_pull_mod_ack_deadline_request.count">
    Cumulative count of streaming pull requests with non-empty ModifyAckDeadline fields, grouped by result.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.streaming_pull_response.count">
    Cumulative count of streaming pull responses, grouped by result.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.unacked_bytes_by_region.bytes">
    Total byte size of the unacknowledged messages in a subscription, broken down by Cloud region.
    type: long
  </definition>
  <definition term="gcp.pubsub.topic.byte_cost.bytes">
    Cost of operations, measured in bytes. This is used to measure utilization for quotas.
    type: long
  </definition>
  <definition term="gcp.pubsub.topic.config_updates.count">
    Cumulative count of configuration changes, grouped by operation type and result.
    type: long
  </definition>
  <definition term="gcp.pubsub.topic.message_sizes.bytes">
    Distribution of publish message sizes (in bytes)
    type: object
  </definition>
  <definition term="gcp.pubsub.topic.oldest_retained_acked_message_age_by_region.value">
    Age (in seconds) of the oldest acknowledged message retained in a topic, broken down by Cloud region.
    type: long
  </definition>
  <definition term="gcp.pubsub.topic.oldest_unacked_message_age_by_region.value">
    Age (in seconds) of the oldest unacknowledged message in a topic, broken down by Cloud region.
    type: long
  </definition>
  <definition term="gcp.pubsub.topic.retained_acked_bytes_by_region.bytes">
    Total byte size of the acknowledged messages retained in a topic, broken down by Cloud region.
    type: long
  </definition>
  <definition term="gcp.pubsub.topic.send_message_operation.count">
    Cumulative count of publish message operations, grouped by result. For a definition of message operations, see Cloud Pub/Sub metric subscription/mod_ack_deadline_message_operation_count.
    type: long
  </definition>
  <definition term="gcp.pubsub.topic.send_request.count">
    Cumulative count of publish requests, grouped by result.
    type: long
  </definition>
  <definition term="gcp.pubsub.topic.streaming_pull_response.count">
    Cumulative count of streaming pull responses, grouped by result.
    type: long
  </definition>
  <definition term="gcp.pubsub.topic.unacked_bytes_by_region.bytes">
    Total byte size of the unacknowledged messages in a topic, broken down by Cloud region.
    type: long
  </definition>
  <definition term="gcp.pubsub.subscription.ack_latencies.value">
    Distribution of ack latencies in milliseconds. The ack latency is the time between when Cloud Pub/Sub sends a message to a subscriber client and when Cloud Pub/Sub receives an Acknowledge request for that message.
    type: object
  </definition>
  <definition term="gcp.pubsub.subscription.push_request_latencies.value">
    Distribution of push request latencies (in microseconds), grouped by result.
    type: object
  </definition>
</definitions>


## storage

Google Cloud Storage metrics
<definitions>
  <definition term="gcp.storage.api.request.count">
    Delta count of API calls, grouped by the API method name and response code.
    type: long
  </definition>
  <definition term="gcp.storage.authz.acl_based_object_access.count">
    Delta count of requests that result in an object being granted access solely due to object ACLs.
    type: long
  </definition>
  <definition term="gcp.storage.authz.acl_operations.count">
    Usage of ACL operations broken down by type.
    type: long
  </definition>
  <definition term="gcp.storage.authz.object_specific_acl_mutation.count">
    Delta count of changes made to object specific ACLs.
    type: long
  </definition>
  <definition term="gcp.storage.network.received.bytes">
    Delta count of bytes received over the network, grouped by the API method name and response code.
    type: long
  </definition>
  <definition term="gcp.storage.network.sent.bytes">
    Delta count of bytes sent over the network, grouped by the API method name and response code.
    type: long
  </definition>
  <definition term="gcp.storage.storage.object.count">
    Total number of objects per bucket, grouped by storage class. This value is measured once per day, and the value is repeated at each sampling interval throughout the day.
    type: long
  </definition>
  <definition term="gcp.storage.storage.total_byte_seconds.bytes">
    Delta count of bytes received over the network, grouped by the API method name and response code.
    type: long
  </definition>
  <definition term="gcp.storage.storage.total.bytes">
    Total size of all objects in the bucket, grouped by storage class. This value is measured once per day, and the value is repeated at each sampling interval throughout the day.
    type: long
  </definition>
</definitions>


## vertexai_logs

<applies-to>
  - Elastic Stack: Beta since 9.2
</applies-to>

Google Cloud Vertex AI Prompt Response Logs metrics
<definitions>
  <definition term="gcp.vertexai_logs.endpoint">
    The Vertex AI API endpoint URL used for the request.
    type: keyword
  </definition>
  <definition term="gcp.vertexai_logs.deployed_model_id">
    The ID of the deployed model that processed the request.
    type: keyword
  </definition>
  <definition term="gcp.vertexai_logs.logging_time">
    Timestamp when the AI interaction was logged.
    type: date
  </definition>
  <definition term="gcp.vertexai_logs.request_id">
    Unique identifier for the AI request.
    type: double
  </definition>
  <definition term="gcp.vertexai_logs.request_payload">
    Array of request payload strings containing user prompts and inputs.
    type: text
  </definition>
</definitions>

Field is not indexed.
<definitions>
  <definition term="gcp.vertexai_logs.response_payload">
    Array of response payload strings containing AI model outputs.
    type: text
  </definition>
</definitions>

Field is not indexed.
<definitions>
  <definition term="gcp.vertexai_logs.model">
    Name of the AI model used (e.g., gemini-2.5-pro).
    type: keyword
  </definition>
  <definition term="gcp.vertexai_logs.model_version">
    Version of the AI model used.
    type: keyword
  </definition>
  <definition term="gcp.vertexai_logs.api_method">
    The API method called (e.g., generateContent, predict).
    type: keyword
  </definition>
  <definition term="gcp.vertexai_logs.full_request">
    Complete request object containing all request details in JSON format.
    type: object
  </definition>
  <definition term="gcp.vertexai_logs.full_response">
    Complete response object containing all response details in JSON format.
    type: object
  </definition>
  <definition term="gcp.vertexai_logs.metadata">
    Additional metadata associated with the AI interaction in JSON format.
    type: object
  </definition>
</definitions>