﻿---
title: Etcd fields
description: etcd Module etcd contains statistics that were read from Etcd Contains etcd leader statistics. Contains follower statistics. latency to each peer in the...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-etcd
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Etcd fields
etcd Module

## etcd

`etcd` contains statistics that were read from Etcd
<definitions>
  <definition term="etcd.api_version">
    Etcd API version for metrics retrieval
    type: keyword
  </definition>
</definitions>


## leader

Contains etcd leader statistics.

## follower

Contains follower statistics.
<definitions>
  <definition term="etcd.leader.follower.id">
    ID of follower
    type: keyword
  </definition>
</definitions>


## latency

latency to each peer in the cluster
<definitions>
  <definition term="etcd.leader.follower.latency.ms">
    type: scaled_float
  </definition>
  <definition term="etcd.leader.follower.success_operations">
    successful Raft RPC requests
    type: integer
  </definition>
  <definition term="etcd.leader.follower.failed_operations">
    failed Raft RPC requests
    type: integer
  </definition>
  <definition term="etcd.leader.follower.leader">
    ID of actual leader
    type: keyword
  </definition>
</definitions>


## server

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Server metrics from the Etcd V3 /metrics endpoint
<definitions>
  <definition term="etcd.server.has_leader">
    Whether a leader exists in the cluster
    type: byte
  </definition>
  <definition term="etcd.server.leader_changes.count">
    Number of leader changes seen at the cluster
    type: long
  </definition>
  <definition term="etcd.server.proposals_committed.count">
    Number of consensus proposals commited
    type: long
  </definition>
  <definition term="etcd.server.proposals_pending.count">
    Number of consensus proposals pending
    type: long
  </definition>
  <definition term="etcd.server.proposals_failed.count">
    Number of consensus proposals failed
    type: long
  </definition>
  <definition term="etcd.server.grpc_started.count">
    Number of sent gRPC requests
    type: long
  </definition>
  <definition term="etcd.server.grpc_handled.count">
    Number of received gRPC requests
    type: long
  </definition>
</definitions>


## disk

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Disk metrics from the Etcd V3 /metrics endpoint
<definitions>
  <definition term="etcd.disk.mvcc_db_total_size.bytes">
    Size of stored data at MVCC
    type: long
    format: bytes
  </definition>
  <definition term="etcd.disk.wal_fsync_duration.ns.bucket.*">
    Latency for writing ahead logs to disk
    type: object
  </definition>
  <definition term="etcd.disk.wal_fsync_duration.ns.count">
    Write ahead logs count
    type: long
  </definition>
  <definition term="etcd.disk.wal_fsync_duration.ns.sum">
    Write ahead logs latency sum
    type: long
  </definition>
  <definition term="etcd.disk.backend_commit_duration.ns.bucket.*">
    Latency for writing backend changes to disk
    type: object
  </definition>
  <definition term="etcd.disk.backend_commit_duration.ns.count">
    Backend commits count
    type: long
  </definition>
  <definition term="etcd.disk.backend_commit_duration.ns.sum">
    Backend commits latency sum
    type: long
  </definition>
</definitions>


## memory

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Memory metrics from the Etcd V3 /metrics endpoint
<definitions>
  <definition term="etcd.memory.go_memstats_alloc.bytes">
    Memory allocated bytes as of MemStats Go
    type: long
    format: bytes
  </definition>
</definitions>


## network

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Network metrics from the Etcd V3 /metrics endpoint
<definitions>
  <definition term="etcd.network.client_grpc_sent.bytes">
    gRPC sent bytes total
    type: long
    format: bytes
  </definition>
  <definition term="etcd.network.client_grpc_received.bytes">
    gRPC received bytes total
    type: long
    format: bytes
  </definition>
</definitions>


## self

Contains etcd self statistics.
<definitions>
  <definition term="etcd.self.id">
    the unique identifier for the member
    type: keyword
  </definition>
  <definition term="etcd.self.leaderinfo.leader">
    id of the current leader member
    type: keyword
  </definition>
  <definition term="etcd.self.leaderinfo.starttime">
    the time when this node was started
    type: keyword
  </definition>
  <definition term="etcd.self.leaderinfo.uptime">
    amount of time the leader has been leader
    type: keyword
  </definition>
  <definition term="etcd.self.name">
    this member's name
    type: keyword
  </definition>
  <definition term="etcd.self.recv.appendrequest.count">
    number of append requests this node has processed
    type: integer
  </definition>
  <definition term="etcd.self.recv.bandwidthrate">
    number of bytes per second this node is receiving (follower only)
    type: scaled_float
  </definition>
  <definition term="etcd.self.recv.pkgrate">
    number of requests per second this node is receiving (follower only)
    type: scaled_float
  </definition>
  <definition term="etcd.self.send.appendrequest.count">
    number of requests that this node has sent
    type: integer
  </definition>
  <definition term="etcd.self.send.bandwidthrate">
    number of bytes per second this node is sending (leader only). This value is undefined on single member clusters.
    type: scaled_float
  </definition>
  <definition term="etcd.self.send.pkgrate">
    number of requests per second this node is sending (leader only). This value is undefined on single member clusters.
    type: scaled_float
  </definition>
  <definition term="etcd.self.starttime">
    the time when this node was started
    type: keyword
  </definition>
  <definition term="etcd.self.state">
    either leader or follower
    type: keyword
  </definition>
</definitions>


## store

The store statistics include information about the operations that this node has handled.
<definitions>
  <definition term="etcd.store.gets.success">
    type: integer
  </definition>
  <definition term="etcd.store.gets.fail">
    type: integer
  </definition>
  <definition term="etcd.store.sets.success">
    type: integer
  </definition>
  <definition term="etcd.store.sets.fail">
    type: integer
  </definition>
  <definition term="etcd.store.delete.success">
    type: integer
  </definition>
  <definition term="etcd.store.delete.fail">
    type: integer
  </definition>
  <definition term="etcd.store.update.success">
    type: integer
  </definition>
  <definition term="etcd.store.update.fail">
    type: integer
  </definition>
  <definition term="etcd.store.create.success">
    type: integer
  </definition>
  <definition term="etcd.store.create.fail">
    type: integer
  </definition>
  <definition term="etcd.store.compareandswap.success">
    type: integer
  </definition>
  <definition term="etcd.store.compareandswap.fail">
    type: integer
  </definition>
  <definition term="etcd.store.compareanddelete.success">
    type: integer
  </definition>
  <definition term="etcd.store.compareanddelete.fail">
    type: integer
  </definition>
  <definition term="etcd.store.expire.count">
    type: integer
  </definition>
  <definition term="etcd.store.watchers">
    type: integer
  </definition>
</definitions>