﻿---
title: Elasticsearch fields
description: Elasticsearch module Cross-cluster replication stats Cluster stats Nodes statistics. Indices statistics. Shard statistics. Enrich stats index index index...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-elasticsearch
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Elasticsearch fields
Elasticsearch module
<definitions>
  <definition term="cluster_settings.cluster.metadata.display_name">
    type: keyword
  </definition>
  <definition term="index_recovery.shards.start_time_in_millis">
    type: alias
    alias to: elasticsearch.index.recovery.start_time.ms
  </definition>
  <definition term="index_recovery.shards.stop_time_in_millis">
    type: alias
    alias to: elasticsearch.index.recovery.stop_time.ms
  </definition>
  <definition term="index_recovery.shards.total_time_in_millis">
    type: alias
    alias to: elasticsearch.index.recovery.total_time.ms
  </definition>
  <definition term="stack_stats.apm.found">
    type: alias
    alias to: elasticsearch.cluster.stats.stack.apm.found
  </definition>
  <definition term="stack_stats.xpack.ccr.enabled">
    type: alias
    alias to: elasticsearch.cluster.stats.stack.xpack.ccr.enabled
  </definition>
  <definition term="stack_stats.xpack.ccr.available">
    type: alias
    alias to: elasticsearch.cluster.stats.stack.xpack.ccr.available
  </definition>
  <definition term="license.status">
    type: alias
    alias to: elasticsearch.cluster.stats.license.status
  </definition>
  <definition term="license.type">
    type: alias
    alias to: elasticsearch.cluster.stats.license.type
  </definition>
  <definition term="shard.primary">
    type: alias
    alias to: elasticsearch.shard.primary
  </definition>
  <definition term="shard.state">
    type: alias
    alias to: elasticsearch.shard.state
  </definition>
  <definition term="shard.index">
    type: alias
    alias to: elasticsearch.index.name
  </definition>
  <definition term="shard.node">
    type: alias
    alias to: elasticsearch.node.id
  </definition>
  <definition term="shard.shard">
    type: alias
    alias to: elasticsearch.shard.number
  </definition>
  <definition term="cluster_stats.indices.count">
    type: alias
    alias to: elasticsearch.cluster.stats.indices.total
  </definition>
  <definition term="cluster_stats.indices.shards.total">
    type: alias
    alias to: elasticsearch.cluster.stats.indices.shards.count
  </definition>
  <definition term="cluster_stats.nodes.count.total">
    type: alias
    alias to: elasticsearch.cluster.stats.nodes.count
  </definition>
  <definition term="cluster_stats.nodes.jvm.max_uptime_in_millis">
    type: alias
    alias to: elasticsearch.cluster.stats.nodes.jvm.max_uptime.ms
  </definition>
  <definition term="cluster_stats.nodes.jvm.mem.heap_used_in_bytes">
    type: alias
    alias to: elasticsearch.cluster.stats.nodes.jvm.memory.heap.used.bytes
  </definition>
  <definition term="cluster_stats.nodes.jvm.mem.heap_max_in_bytes">
    type: alias
    alias to: elasticsearch.cluster.stats.nodes.jvm.memory.heap.max.bytes
  </definition>
  <definition term="cluster_state.nodes_hash">
    type: alias
    alias to: elasticsearch.cluster.stats.state.nodes_hash
  </definition>
  <definition term="cluster_state.version">
    type: alias
    alias to: elasticsearch.cluster.stats.state.version
  </definition>
  <definition term="cluster_state.master_node">
    type: alias
    alias to: elasticsearch.cluster.stats.state.master_node
  </definition>
  <definition term="cluster_state.state_uuid">
    type: alias
    alias to: elasticsearch.cluster.stats.state.state_uuid
  </definition>
  <definition term="cluster_state.status">
    type: alias
    alias to: elasticsearch.cluster.stats.status
  </definition>
  <definition term="timestamp">
    type: alias
    alias to: @timestamp
  </definition>
  <definition term="cluster_uuid">
    type: alias
    alias to: elasticsearch.cluster.id
  </definition>
  <definition term="source_node.uuid">
    type: alias
    alias to: elasticsearch.node.id
  </definition>
  <definition term="source_node.name">
    type: alias
    alias to: elasticsearch.node.name
  </definition>
  <definition term="job_stats.job_id">
    type: alias
    alias to: elasticsearch.ml.job.id
  </definition>
  <definition term="job_stats.forecasts_stats.total">
    type: alias
    alias to: elasticsearch.ml.job.forecasts_stats.total
  </definition>
  <definition term="index_stats.index">
    type: alias
    alias to: elasticsearch.index.name
  </definition>
  <definition term="index_stats.primaries.store.size_in_bytes">
    type: alias
    alias to: elasticsearch.index.primaries.store.size_in_bytes
  </definition>
  <definition term="index_stats.primaries.docs.count">
    type: alias
    alias to: elasticsearch.index.primaries.docs.count
  </definition>
  <definition term="index_stats.primaries.segments.count">
    type: alias
    alias to: elasticsearch.index.primaries.segments.count
  </definition>
  <definition term="index_stats.primaries.refresh.total_time_in_millis">
    type: alias
    alias to: elasticsearch.index.primaries.refresh.total_time_in_millis
  </definition>
  <definition term="index_stats.primaries.merges.total_size_in_bytes">
    type: alias
    alias to: elasticsearch.index.primaries.merges.total_size_in_bytes
  </definition>
  <definition term="index_stats.primaries.indexing.index_total">
    type: alias
    alias to: elasticsearch.index.primaries.indexing.index_total
  </definition>
  <definition term="index_stats.primaries.indexing.index_time_in_millis">
    type: alias
    alias to: elasticsearch.index.primaries.indexing.index_time_in_millis
  </definition>
  <definition term="index_stats.primaries.indexing.throttle_time_in_millis">
    type: alias
    alias to: elasticsearch.index.primaries.indexing.throttle_time_in_millis
  </definition>
  <definition term="index_stats.total.query_cache.memory_size_in_bytes">
    type: alias
    alias to: elasticsearch.index.total.query_cache.memory_size_in_bytes
  </definition>
  <definition term="index_stats.total.fielddata.memory_size_in_bytes">
    type: alias
    alias to: elasticsearch.index.total.fielddata.memory_size_in_bytes
  </definition>
  <definition term="index_stats.total.request_cache.memory_size_in_bytes">
    type: alias
    alias to: elasticsearch.index.total.request_cache.memory_size_in_bytes
  </definition>
  <definition term="index_stats.total.merges.total_size_in_bytes">
    type: alias
    alias to: elasticsearch.index.total.merges.total_size_in_bytes
  </definition>
  <definition term="index_stats.total.refresh.total_time_in_millis">
    type: alias
    alias to: elasticsearch.index.total.refresh.total_time_in_millis
  </definition>
  <definition term="index_stats.total.store.size_in_bytes">
    type: alias
    alias to: elasticsearch.index.total.store.size_in_bytes
  </definition>
  <definition term="index_stats.total.indexing.index_total">
    type: alias
    alias to: elasticsearch.index.total.indexing.index_total
  </definition>
  <definition term="index_stats.total.indexing.index_time_in_millis">
    type: alias
    alias to: elasticsearch.index.total.indexing.index_time_in_millis
  </definition>
  <definition term="index_stats.total.indexing.throttle_time_in_millis">
    type: alias
    alias to: elasticsearch.index.total.indexing.throttle_time_in_millis
  </definition>
  <definition term="index_stats.total.search.query_total">
    type: alias
    alias to: elasticsearch.index.total.search.query_total
  </definition>
  <definition term="index_stats.total.search.query_time_in_millis">
    type: alias
    alias to: elasticsearch.index.total.search.query_time_in_millis
  </definition>
  <definition term="index_stats.total.segments.terms_memory_in_bytes">
    type: alias
    alias to: elasticsearch.index.total.segments.terms_memory_in_bytes
  </definition>
  <definition term="index_stats.total.segments.points_memory_in_bytes">
    type: alias
    alias to: elasticsearch.index.total.segments.points_memory_in_bytes
  </definition>
  <definition term="index_stats.total.segments.count">
    type: alias
    alias to: elasticsearch.index.total.segments.count
  </definition>
  <definition term="index_stats.total.segments.doc_values_memory_in_bytes">
    type: alias
    alias to: elasticsearch.index.total.segments.doc_values_memory_in_bytes
  </definition>
  <definition term="index_stats.total.segments.norms_memory_in_bytes">
    type: alias
    alias to: elasticsearch.index.total.segments.norms_memory_in_bytes
  </definition>
  <definition term="index_stats.total.segments.stored_fields_memory_in_bytes">
    type: alias
    alias to: elasticsearch.index.total.segments.stored_fields_memory_in_bytes
  </definition>
  <definition term="index_stats.total.segments.fixed_bit_set_memory_in_bytes">
    type: alias
    alias to: elasticsearch.index.total.segments.fixed_bit_set_memory_in_bytes
  </definition>
  <definition term="index_stats.total.segments.term_vectors_memory_in_bytes">
    type: alias
    alias to: elasticsearch.index.total.segments.term_vectors_memory_in_bytes
  </definition>
  <definition term="index_stats.total.segments.version_map_memory_in_bytes">
    type: alias
    alias to: elasticsearch.index.total.segments.version_map_memory_in_bytes
  </definition>
  <definition term="index_stats.total.segments.index_writer_memory_in_bytes">
    type: alias
    alias to: elasticsearch.index.total.segments.index_writer_memory_in_bytes
  </definition>
  <definition term="index_stats.total.segments.memory_in_bytes">
    type: alias
    alias to: elasticsearch.index.total.segments.memory_in_bytes
  </definition>
  <definition term="ccr_auto_follow_stats.number_of_failed_follow_indices">
    type: alias
    alias to: elasticsearch.ccr.auto_follow.failed.follow_indices.count
  </definition>
  <definition term="ccr_auto_follow_stats.number_of_failed_remote_cluster_state_requests">
    type: alias
    alias to: elasticsearch.ccr.auto_follow.failed.remote_cluster_state_requests.count
  </definition>
  <definition term="ccr_auto_follow_stats.number_of_successful_follow_indices">
    type: alias
    alias to: elasticsearch.ccr.auto_follow.success.follow_indices.count
  </definition>
  <definition term="ccr_auto_follow_stats.follower.failed_read_requests">
    type: alias
    alias to: elasticsearch.ccr.requests.failed.read.count
  </definition>
  <definition term="ccr_stats.shard_id">
    type: alias
    alias to: elasticsearch.ccr.follower.shard.number
  </definition>
  <definition term="ccr_stats.remote_cluster">
    type: alias
    alias to: elasticsearch.ccr.remote_cluster
  </definition>
  <definition term="ccr_stats.leader_index">
    type: alias
    alias to: elasticsearch.ccr.leader.index
  </definition>
  <definition term="ccr_stats.follower_index">
    type: alias
    alias to: elasticsearch.ccr.follower.index
  </definition>
  <definition term="ccr_stats.leader_global_checkpoint">
    type: alias
    alias to: elasticsearch.ccr.leader.global_checkpoint
  </definition>
  <definition term="ccr_stats.leader_max_seq_no">
    type: alias
    alias to: elasticsearch.ccr.leader.max_seq_no
  </definition>
  <definition term="ccr_stats.follower_global_checkpoint">
    type: alias
    alias to: elasticsearch.ccr.follower.global_checkpoint
  </definition>
  <definition term="ccr_stats.follower_max_seq_no">
    type: alias
    alias to: elasticsearch.ccr.follower.max_seq_no
  </definition>
  <definition term="ccr_stats.last_requested_seq_no">
    type: alias
    alias to: elasticsearch.ccr.last_requested_seq_no
  </definition>
  <definition term="ccr_stats.outstanding_read_requests">
    type: alias
    alias to: elasticsearch.ccr.requests.outstanding.read.count
  </definition>
  <definition term="ccr_stats.outstanding_write_requests">
    type: alias
    alias to: elasticsearch.ccr.requests.outstanding.write.count
  </definition>
  <definition term="ccr_stats.write_buffer_operation_count">
    type: alias
    alias to: elasticsearch.ccr.write_buffer.operation.count
  </definition>
  <definition term="ccr_stats.write_buffer_size_in_bytes">
    type: alias
    alias to: elasticsearch.ccr.write_buffer.size.bytes
  </definition>
  <definition term="ccr_stats.follower_mapping_version">
    type: alias
    alias to: elasticsearch.ccr.follower.mapping_version
  </definition>
  <definition term="ccr_stats.follower_settings_version">
    type: alias
    alias to: elasticsearch.ccr.follower.settings_version
  </definition>
  <definition term="ccr_stats.follower_aliases_version">
    type: alias
    alias to: elasticsearch.ccr.follower.aliases_version
  </definition>
  <definition term="ccr_stats.total_read_time_millis">
    type: alias
    alias to: elasticsearch.ccr.total_time.read.ms
  </definition>
  <definition term="ccr_stats.total_read_remote_exec_time_millis">
    type: alias
    alias to: elasticsearch.ccr.total_time.read.remote_exec.ms
  </definition>
  <definition term="ccr_stats.successful_read_requests">
    type: alias
    alias to: elasticsearch.ccr.requests.successful.read.count
  </definition>
  <definition term="ccr_stats.failed_read_requests">
    type: alias
    alias to: elasticsearch.ccr.requests.failed.read.count
  </definition>
  <definition term="ccr_stats.operations_read">
    type: alias
    alias to: elasticsearch.ccr.follower.operations.read.count
  </definition>
  <definition term="ccr_stats.operations_written">
    type: alias
    alias to: elasticsearch.ccr.follower.operations_written
  </definition>
  <definition term="ccr_stats.bytes_read">
    type: alias
    alias to: elasticsearch.ccr.bytes_read
  </definition>
  <definition term="ccr_stats.total_write_time_millis">
    type: alias
    alias to: elasticsearch.ccr.total_time.write.ms
  </definition>
  <definition term="ccr_stats.successful_write_requests">
    type: alias
    alias to: elasticsearch.ccr.requests.successful.write.count
  </definition>
  <definition term="ccr_stats.failed_write_requests">
    type: alias
    alias to: elasticsearch.ccr.requests.failed.write.count
  </definition>
  <definition term="node_stats.fs.total.available_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.fs.summary.available.bytes
  </definition>
  <definition term="node_stats.fs.total.total_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.fs.summary.total.bytes
  </definition>
  <definition term="node_stats.fs.summary.available.bytes">
    type: alias
    alias to: elasticsearch.node.stats.fs.summary.available.bytes
  </definition>
  <definition term="node_stats.fs.summary.total.bytes">
    type: alias
    alias to: elasticsearch.node.stats.fs.summary.total.bytes
  </definition>
  <definition term="node_stats.fs.io_stats.total.operations">
    type: alias
    alias to: elasticsearch.node.stats.fs.io_stats.total.operations.count
  </definition>
  <definition term="node_stats.fs.io_stats.total.read_operations">
    type: alias
    alias to: elasticsearch.node.stats.fs.io_stats.total.read.operations.count
  </definition>
  <definition term="node_stats.fs.io_stats.total.write_operations">
    type: alias
    alias to: elasticsearch.node.stats.fs.io_stats.total.write.operations.count
  </definition>
  <definition term="node_stats.indices.store.size_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.indices.store.size.bytes
  </definition>
  <definition term="node_stats.indices.store.size.bytes">
    type: alias
    alias to: elasticsearch.node.stats.indices.store.size.bytes
  </definition>
  <definition term="node_stats.indices.docs.count">
    type: alias
    alias to: elasticsearch.node.stats.indices.docs.count
  </definition>
  <definition term="node_stats.indices.indexing.index_time_in_millis">
    type: alias
    alias to: elasticsearch.node.stats.indices.indexing.index_time.ms
  </definition>
  <definition term="node_stats.indices.indexing.index_total">
    type: alias
    alias to: elasticsearch.node.stats.indices.indexing.index_total.count
  </definition>
  <definition term="node_stats.indices.indexing.throttle_time_in_millis">
    type: alias
    alias to: elasticsearch.node.stats.indices.indexing.throttle_time.ms
  </definition>
  <definition term="node_stats.indices.fielddata.memory_size_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.indices.fielddata.memory.bytes
  </definition>
  <definition term="node_stats.indices.query_cache.memory_size_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.indices.query_cache.memory.bytes
  </definition>
  <definition term="node_stats.indices.request_cache.memory_size_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.indices.request_cache.memory.bytes
  </definition>
  <definition term="node_stats.indices.search.query_time_in_millis">
    type: alias
    alias to: elasticsearch.node.stats.indices.search.query_time.ms
  </definition>
  <definition term="node_stats.indices.search.query_total">
    type: alias
    alias to: elasticsearch.node.stats.indices.search.query_total.count
  </definition>
  <definition term="node_stats.indices.segments.count">
    type: alias
    alias to: elasticsearch.node.stats.indices.segments.count
  </definition>
  <definition term="node_stats.indices.segments.doc_values_memory_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.indices.segments.doc_values.memory.bytes
  </definition>
  <definition term="node_stats.indices.segments.fixed_bit_set_memory_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.indices.segments.fixed_bit_set.memory.bytes
  </definition>
  <definition term="node_stats.indices.segments.index_writer_memory_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.indices.segments.index_writer.memory.bytes
  </definition>
  <definition term="node_stats.indices.segments.memory_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.indices.segments.memory.bytes
  </definition>
  <definition term="node_stats.indices.segments.norms_memory_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.indices.segments.norms.memory.bytes
  </definition>
  <definition term="node_stats.indices.segments.points_memory_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.indices.segments.points.memory.bytes
  </definition>
  <definition term="node_stats.indices.segments.stored_fields_memory_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.indices.segments.stored_fields.memory.bytes
  </definition>
  <definition term="node_stats.indices.segments.term_vectors_memory_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.indices.segments.term_vectors.memory.bytes
  </definition>
  <definition term="node_stats.indices.segments.terms_memory_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.indices.segments.terms.memory.bytes
  </definition>
  <definition term="node_stats.indices.segments.version_map_memory_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.indices.segments.version_map.memory.bytes
  </definition>
  <definition term="node_stats.jvm.gc.collectors.old.collection_count">
    type: alias
    alias to: elasticsearch.node.stats.jvm.gc.collectors.old.collection.count
  </definition>
  <definition term="node_stats.jvm.gc.collectors.old.collection_time_in_millis">
    type: alias
    alias to: elasticsearch.node.stats.jvm.gc.collectors.old.collection.ms
  </definition>
  <definition term="node_stats.jvm.gc.collectors.young.collection_count">
    type: alias
    alias to: elasticsearch.node.stats.jvm.gc.collectors.young.collection.count
  </definition>
  <definition term="node_stats.jvm.gc.collectors.young.collection_time_in_millis">
    type: alias
    alias to: elasticsearch.node.stats.jvm.gc.collectors.young.collection.ms
  </definition>
  <definition term="node_stats.jvm.mem.heap_max_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.jvm.mem.heap.max.bytes
  </definition>
  <definition term="node_stats.jvm.mem.heap_used_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.jvm.mem.heap.used.bytes
  </definition>
  <definition term="node_stats.jvm.mem.heap_used_percent">
    type: alias
    alias to: elasticsearch.node.stats.jvm.mem.heap.used.pct
  </definition>
  <definition term="node_stats.node_id">
    type: alias
    alias to: elasticsearch.node.id
  </definition>
  <definition term="node_stats.os.cpu.load_average.1m">
    type: alias
    alias to: elasticsearch.node.stats.os.cpu.load_avg.1m
  </definition>
  <definition term="node_stats.os.cgroup.cpuacct.usage_nanos">
    type: alias
    alias to: elasticsearch.node.stats.os.cgroup.cpuacct.usage.ns
  </definition>
  <definition term="node_stats.os.cgroup.cpu.cfs_quota_micros">
    type: alias
    alias to: elasticsearch.node.stats.os.cgroup.cpu.cfs.quota.us
  </definition>
  <definition term="node_stats.os.cgroup.cpu.stat.number_of_elapsed_periods">
    type: alias
    alias to: elasticsearch.node.stats.os.cgroup.cpu.stat.elapsed_periods.count
  </definition>
  <definition term="node_stats.os.cgroup.cpu.stat.number_of_times_throttled">
    type: alias
    alias to: elasticsearch.node.stats.os.cgroup.cpu.stat.times_throttled.count
  </definition>
  <definition term="node_stats.os.cgroup.cpu.stat.time_throttled_nanos">
    type: alias
    alias to: elasticsearch.node.stats.os.cgroup.cpu.stat.time_throttled.ns
  </definition>
  <definition term="node_stats.os.cgroup.memory.control_group">
    type: alias
    alias to: elasticsearch.node.stats.os.cgroup.memory.control_group
  </definition>
  <definition term="node_stats.os.cgroup.memory.limit_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.os.cgroup.memory.limit.bytes
  </definition>
  <definition term="node_stats.os.cgroup.memory.usage_in_bytes">
    type: alias
    alias to: elasticsearch.node.stats.os.cgroup.memory.usage.bytes
  </definition>
  <definition term="node_stats.process.cpu.percent">
    type: alias
    alias to: elasticsearch.node.stats.process.cpu.pct
  </definition>
  <definition term="node_stats.thread_pool.bulk.queue">
    type: alias
    alias to: elasticsearch.node.stats.thread_pool.bulk.queue.count
  </definition>
  <definition term="node_stats.thread_pool.bulk.rejected">
    type: alias
    alias to: elasticsearch.node.stats.thread_pool.bulk.rejected.count
  </definition>
  <definition term="node_stats.thread_pool.get.queue">
    type: alias
    alias to: elasticsearch.node.stats.thread_pool.get.queue.count
  </definition>
  <definition term="node_stats.thread_pool.get.rejected">
    type: alias
    alias to: elasticsearch.node.stats.thread_pool.get.rejected.count
  </definition>
  <definition term="node_stats.thread_pool.index.queue">
    type: alias
    alias to: elasticsearch.node.stats.thread_pool.index.queue.count
  </definition>
  <definition term="node_stats.thread_pool.index.rejected">
    type: alias
    alias to: elasticsearch.node.stats.thread_pool.index.rejected.count
  </definition>
  <definition term="node_stats.thread_pool.search.queue">
    type: alias
    alias to: elasticsearch.node.stats.thread_pool.search.queue.count
  </definition>
  <definition term="node_stats.thread_pool.search.rejected">
    type: alias
    alias to: elasticsearch.node.stats.thread_pool.search.rejected.count
  </definition>
  <definition term="node_stats.thread_pool.write.queue">
    type: alias
    alias to: elasticsearch.node.stats.thread_pool.write.queue.count
  </definition>
  <definition term="node_stats.thread_pool.write.rejected">
    type: alias
    alias to: elasticsearch.node.stats.thread_pool.write.rejected.count
  </definition>
  <definition term="indices_stats._all.primaries.indexing.index_total">
    type: alias
    alias to: elasticsearch.index.summary.primaries.indexing.index.count
  </definition>
  <definition term="indices_stats._all.primaries.indexing.index_time_in_millis">
    type: alias
    alias to: elasticsearch.index.summary.primaries.indexing.index.time.ms
  </definition>
  <definition term="indices_stats._all.total.search.query_total">
    type: alias
    alias to: elasticsearch.index.summary.total.search.query.count
  </definition>
  <definition term="indices_stats._all.total.search.query_time_in_millis">
    type: alias
    alias to: elasticsearch.index.summary.total.search.query.time.ms
  </definition>
  <definition term="indices_stats._all.total.indexing.index_total">
    type: alias
    alias to: elasticsearch.index.summary.total.indexing.index.count
  </definition>
  <definition term="elasticsearch.cluster.name">
    Elasticsearch cluster name.
    type: keyword
  </definition>
  <definition term="elasticsearch.cluster.id">
    Elasticsearch cluster id.
    type: keyword
  </definition>
  <definition term="elasticsearch.cluster.state.id">
    Elasticsearch state id.
    type: keyword
  </definition>
  <definition term="elasticsearch.node.id">
    Node ID
    type: keyword
  </definition>
  <definition term="elasticsearch.node.name">
    Node name.
    type: keyword
  </definition>
  <definition term="elasticsearch.node.roles">
    Node roles.
    type: keyword
  </definition>
  <definition term="elasticsearch.node.master">
    Is the node the master node?
    type: boolean
  </definition>
  <definition term="elasticsearch.node.mlockall">
    Is mlockall enabled on the node?
    type: boolean
  </definition>
</definitions>


## ccr

Cross-cluster replication stats
<definitions>
  <definition term="elasticsearch.ccr.remote_cluster">
    type: keyword
  </definition>
  <definition term="elasticsearch.ccr.bytes_read">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.last_requested_seq_no">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.shard_id">
    type: integer
  </definition>
  <definition term="elasticsearch.ccr.total_time.read.ms">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.total_time.read.remote_exec.ms">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.total_time.write.ms">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.read_exceptions">
    type: nested
  </definition>
  <definition term="elasticsearch.ccr.requests.successful.read.count">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.requests.successful.write.count">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.requests.failed.read.count">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.requests.failed.write.count">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.requests.outstanding.read.count">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.requests.outstanding.write.count">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.write_buffer.size.bytes">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.write_buffer.operation.count">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.auto_follow.failed.follow_indices.count">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.auto_follow.failed.remote_cluster_state_requests.count">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.auto_follow.success.follow_indices.count">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.leader.index">
    Name of leader index
    type: keyword
  </definition>
  <definition term="elasticsearch.ccr.leader.max_seq_no">
    Maximum sequence number of operation on the leader shard
    type: long
  </definition>
  <definition term="elasticsearch.ccr.leader.global_checkpoint">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.follower.index">
    Name of follower index
    type: keyword
  </definition>
  <definition term="elasticsearch.ccr.follower.shard.number">
    Number of the shard within the index
    type: long
  </definition>
  <definition term="elasticsearch.ccr.follower.operations_written">
    Number of operations indexed (replicated) into the follower shard from the leader shard
    type: long
  </definition>
  <definition term="elasticsearch.ccr.follower.time_since_last_read.ms">
    Time, in ms, since the follower last fetched from the leader
    type: long
  </definition>
  <definition term="elasticsearch.ccr.follower.global_checkpoint">
    Global checkpoint value on follower shard
    type: long
  </definition>
  <definition term="elasticsearch.ccr.follower.max_seq_no">
    Maximum sequence number of operation on the follower shard
    type: long
  </definition>
  <definition term="elasticsearch.ccr.follower.mapping_version">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.follower.settings_version">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.follower.aliases_version">
    type: long
  </definition>
  <definition term="elasticsearch.ccr.follower.operations.read.count">
    type: long
  </definition>
</definitions>


## cluster.stats

Cluster stats
<definitions>
  <definition term="elasticsearch.cluster.stats.version">
    type: keyword
  </definition>
  <definition term="elasticsearch.cluster.stats.state.nodes_hash">
    type: keyword
  </definition>
  <definition term="elasticsearch.cluster.stats.state.master_node">
    type: keyword
  </definition>
  <definition term="elasticsearch.cluster.stats.state.version">
    type: keyword
  </definition>
  <definition term="elasticsearch.cluster.stats.state.state_uuid">
    type: keyword
  </definition>
  <definition term="elasticsearch.cluster.stats.state.nodes">
    type: flattened
  </definition>
  <definition term="elasticsearch.cluster.stats.status">
    Cluster status (green, yellow, red).
    type: keyword
  </definition>
</definitions>


## nodes

Nodes statistics.
<definitions>
  <definition term="elasticsearch.cluster.stats.nodes.fs.total.bytes">
    type: long
  </definition>
  <definition term="elasticsearch.cluster.stats.nodes.fs.available.bytes">
    type: long
  </definition>
  <definition term="elasticsearch.cluster.stats.nodes.count">
    Total number of nodes in cluster.
    type: long
  </definition>
  <definition term="elasticsearch.cluster.stats.nodes.master">
    Number of master-eligible nodes in cluster.
    type: long
  </definition>
  <definition term="elasticsearch.cluster.stats.nodes.data">
    Number of data nodes in cluster.
    type: long
  </definition>
  <definition term="elasticsearch.cluster.stats.nodes.jvm.max_uptime.ms">
    type: long
  </definition>
  <definition term="elasticsearch.cluster.stats.nodes.jvm.memory.heap.max.bytes">
    type: long
  </definition>
  <definition term="elasticsearch.cluster.stats.nodes.jvm.memory.heap.used.bytes">
    type: long
  </definition>
</definitions>


## indices

Indices statistics.
<definitions>
  <definition term="elasticsearch.cluster.stats.indices.store.size.bytes">
    type: long
  </definition>
  <definition term="elasticsearch.cluster.stats.indices.store.total_data_set_size.bytes">
    type: long
  </definition>
  <definition term="elasticsearch.cluster.stats.indices.total">
    Total number of indices in cluster.
    type: long
  </definition>
</definitions>


## shards

Shard statistics.
<definitions>
  <definition term="elasticsearch.cluster.stats.indices.shards.docs.total">
    type: long
  </definition>
  <definition term="elasticsearch.cluster.stats.indices.shards.count">
    Total number of shards in cluster.
    type: long
  </definition>
  <definition term="elasticsearch.cluster.stats.indices.shards.primaries">
    Total number of primary shards in cluster.
    type: long
  </definition>
  <definition term="elasticsearch.cluster.stats.indices.fielddata.memory.bytes">
    Memory used for fielddata.
    type: long
  </definition>
  <definition term="elasticsearch.cluster.stats.license.expiry_date_in_millis">
    type: long
  </definition>
  <definition term="elasticsearch.cluster.stats.license.status">
    type: keyword
  </definition>
  <definition term="elasticsearch.cluster.stats.license.type">
    type: keyword
  </definition>
  <definition term="elasticsearch.cluster.stats.stack.apm.found">
    type: boolean
  </definition>
  <definition term="elasticsearch.cluster.stats.stack.xpack.ccr.available">
    type: boolean
  </definition>
  <definition term="elasticsearch.cluster.stats.stack.xpack.ccr.enabled">
    type: boolean
  </definition>
</definitions>


## enrich

Enrich stats
<definitions>
  <definition term="elasticsearch.enrich.executing_policy.name">
    type: keyword
  </definition>
  <definition term="elasticsearch.enrich.executing_policy.task.id">
    type: long
  </definition>
  <definition term="elasticsearch.enrich.executing_policy.task.task">
    type: keyword
  </definition>
  <definition term="elasticsearch.enrich.executing_policy.task.action">
    type: keyword
  </definition>
  <definition term="elasticsearch.enrich.executing_policy.task.cancellable">
    type: boolean
  </definition>
  <definition term="elasticsearch.enrich.executing_policy.task.parent_task_id">
    type: keyword
  </definition>
  <definition term="elasticsearch.enrich.executing_policy.task.time.start.ms">
    type: long
  </definition>
  <definition term="elasticsearch.enrich.executing_policy.task.time.running.nano">
    type: long
  </definition>
  <definition term="elasticsearch.enrich.queue.size">
    Number of search requests in the queue.
    type: long
  </definition>
  <definition term="elasticsearch.enrich.executed_searches.total">
    Number of search requests that enrich processors have executed since node startup.
    type: long
  </definition>
  <definition term="elasticsearch.enrich.remote_requests.current">
    Current number of outstanding remote requests.
    type: long
  </definition>
  <definition term="elasticsearch.enrich.remote_requests.total">
    Number of outstanding remote requests executed since node startup.
    type: long
  </definition>
</definitions>


## index

index
<definitions>
  <definition term="elasticsearch.index.hidden">
    type: boolean
  </definition>
  <definition term="elasticsearch.index.shards.total">
    type: long
  </definition>
  <definition term="elasticsearch.index.shards.primaries">
    type: long
  </definition>
  <definition term="elasticsearch.index.uuid">
    type: keyword
  </definition>
  <definition term="elasticsearch.index.status">
    type: keyword
  </definition>
  <definition term="elasticsearch.index.tier_preference">
    type: keyword
  </definition>
  <definition term="elasticsearch.index.creation_date">
    type: date
  </definition>
  <definition term="elasticsearch.index.version">
    type: keyword
  </definition>
  <definition term="elasticsearch.index.name">
    Index name.
    type: keyword
  </definition>
  <definition term="elasticsearch.index.primaries.search.query_total">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.search.query_time_in_millis">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.request_cache.memory_size_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.request_cache.evictions">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.request_cache.hit_count">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.request_cache.miss_count">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.query_cache.memory_size_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.query_cache.hit_count">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.query_cache.miss_count">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.store.size_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.store.total_data_set_size_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.docs.count">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.docs.deleted">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.segments.count">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.segments.memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.segments.terms_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.segments.stored_fields_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.segments.term_vectors_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.segments.norms_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.segments.points_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.segments.doc_values_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.segments.index_writer_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.segments.version_map_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.segments.fixed_bit_set_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.refresh.total_time_in_millis">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.refresh.external_total_time_in_millis">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.merges.total_size_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.indexing.index_total">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.indexing.index_time_in_millis">
    type: long
  </definition>
  <definition term="elasticsearch.index.primaries.indexing.throttle_time_in_millis">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.docs.count">
    Total number of documents in the index.
    type: long
  </definition>
  <definition term="elasticsearch.index.total.docs.deleted">
    Total number of deleted documents in the index.
    type: long
  </definition>
  <definition term="elasticsearch.index.total.store.size_in_bytes">
    Total size of the index in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.index.total.store.total_data_set_size_in_bytes">
    Total size of the index in bytes including backing data for partially mounted indices.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.index.total.query_cache.memory_size_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.query_cache.evictions">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.query_cache.hit_count">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.query_cache.miss_count">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.fielddata.memory_size_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.fielddata.evictions">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.request_cache.memory_size_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.request_cache.evictions">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.request_cache.hit_count">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.request_cache.miss_count">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.merges.total_size_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.refresh.total_time_in_millis">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.refresh.external_total_time_in_millis">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.segments.memory_in_bytes">
    Total number of memory used by the segments in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.index.total.segments.terms_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.segments.points_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.segments.count">
    Total number of index segments.
    type: long
  </definition>
  <definition term="elasticsearch.index.total.segments.doc_values_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.segments.norms_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.segments.stored_fields_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.segments.fixed_bit_set_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.segments.term_vectors_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.segments.version_map_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.segments.index_writer_memory_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.search.query_total">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.search.query_time_in_millis">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.indexing.index_total">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.indexing.index_time_in_millis">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.indexing.throttle_time_in_millis">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.bulk.total_size_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.bulk.avg_size_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.bulk.avg_time_in_millis">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.bulk.total_operations">
    type: long
  </definition>
  <definition term="elasticsearch.index.total.bulk.total_time_in_millis">
    type: long
  </definition>
</definitions>


## index.recovery

index
<definitions>
  <definition term="elasticsearch.index.recovery.index.files.percent">
    type: keyword
  </definition>
  <definition term="elasticsearch.index.recovery.index.files.recovered">
    type: long
  </definition>
  <definition term="elasticsearch.index.recovery.index.files.reused">
    type: long
  </definition>
  <definition term="elasticsearch.index.recovery.index.files.total">
    type: long
  </definition>
  <definition term="elasticsearch.index.recovery.index.size.recovered_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.recovery.index.size.reused_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.recovery.index.size.total_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.recovery.name">
    type: keyword
  </definition>
  <definition term="elasticsearch.index.recovery.total_time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.index.recovery.stop_time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.index.recovery.start_time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.index.recovery.id">
    Shard recovery id.
    type: long
  </definition>
  <definition term="elasticsearch.index.recovery.type">
    Shard recovery type.
    type: keyword
  </definition>
  <definition term="elasticsearch.index.recovery.primary">
    True if primary shard.
    type: boolean
  </definition>
  <definition term="elasticsearch.index.recovery.stage">
    Recovery stage.
    type: keyword
  </definition>
  <definition term="elasticsearch.index.recovery.translog.percent">
    type: keyword
  </definition>
  <definition term="elasticsearch.index.recovery.translog.total">
    type: long
  </definition>
  <definition term="elasticsearch.index.recovery.translog.total_on_start">
    type: long
  </definition>
  <definition term="elasticsearch.index.recovery.target.transport_address">
    type: keyword
  </definition>
  <definition term="elasticsearch.index.recovery.target.id">
    Target node id.
    type: keyword
  </definition>
  <definition term="elasticsearch.index.recovery.target.host">
    Target node host address (could be IP address or hostname).
    type: keyword
  </definition>
  <definition term="elasticsearch.index.recovery.target.name">
    Target node name.
    type: keyword
  </definition>
  <definition term="elasticsearch.index.recovery.source.transport_address">
    type: keyword
  </definition>
  <definition term="elasticsearch.index.recovery.source.id">
    Source node id.
    type: keyword
  </definition>
  <definition term="elasticsearch.index.recovery.source.host">
    Source node host address (could be IP address or hostname).
    type: keyword
  </definition>
  <definition term="elasticsearch.index.recovery.source.name">
    Source node name.
    type: keyword
  </definition>
  <definition term="elasticsearch.index.recovery.verify_index.check_index_time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.index.recovery.verify_index.total_time.ms">
    type: long
  </definition>
</definitions>


## index.summary

index
<definitions>
  <definition term="elasticsearch.index.summary.primaries.docs.count">
    Total number of documents in the index.
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.primaries.docs.deleted">
    Total number of deleted documents in the index.
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.primaries.store.size.bytes">
    Total size of the index in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.index.summary.primaries.store.total_data_set_size.bytes">
    Total size of the index in bytes including backing data for partially mounted indices.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.index.summary.primaries.segments.count">
    Total number of index segments.
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.primaries.segments.memory.bytes">
    Total number of memory used by the segments in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.index.summary.primaries.indexing.index.count">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.primaries.indexing.index.time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.primaries.search.query.count">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.primaries.search.query.time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.primaries.bulk.operations.count">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.primaries.bulk.size.bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.primaries.bulk.time.count.ms">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.primaries.bulk.time.avg.ms">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.primaries.bulk.time.avg.bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.total.docs.count">
    Total number of documents in the index.
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.total.docs.deleted">
    Total number of deleted documents in the index.
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.total.store.size.bytes">
    Total size of the index in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.index.summary.total.store.total_data_set_size.bytes">
    Total size of the index in bytes including backing data for partially mounted indices.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.index.summary.total.segments.count">
    Total number of index segments.
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.total.segments.memory.bytes">
    Total number of memory used by the segments in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.index.summary.total.indexing.index.count">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.total.indexing.is_throttled">
    type: boolean
  </definition>
  <definition term="elasticsearch.index.summary.total.indexing.throttle_time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.total.indexing.index.time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.total.search.query.count">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.total.search.query.time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.total.bulk.operations.count">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.total.bulk.size.bytes">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.total.bulk.time.avg.ms">
    type: long
  </definition>
  <definition term="elasticsearch.index.summary.total.bulk.time.avg.bytes">
    type: long
  </definition>
</definitions>


## ingest_pipeline

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Runtime metrics on ingest pipeline execution
<definitions>
  <definition term="elasticsearch.ingest_pipeline.name">
    Name / id of the ingest pipeline
    type: wildcard
  </definition>
</definitions>


## total

Metrics on the total ingest pipeline execution, including all processors.
<definitions>
  <definition term="elasticsearch.ingest_pipeline.total.count">
    Number of documents processed by this pipeline
    type: long
  </definition>
  <definition term="elasticsearch.ingest_pipeline.total.failed">
    Number of documented failed to process by this pipeline
    type: long
  </definition>
  <definition term="elasticsearch.ingest_pipeline.total.time.total.ms">
    Total time spent processing documents through this pipeline, inclusive of other pipelines called
    type: long
  </definition>
  <definition term="elasticsearch.ingest_pipeline.total.time.self.ms">
    Time spent processing documents through this pipeline, exclusive of other pipelines called
    type: long
  </definition>
  <definition term="elasticsearch.ingest_pipeline.processor.type">
    The type of ingest processor
    type: keyword
  </definition>
  <definition term="elasticsearch.ingest_pipeline.processor.type_tag">
    The type and the tag for this processor in the format "<type>:<tag>"
    type: keyword
  </definition>
  <definition term="elasticsearch.ingest_pipeline.processor.order_index">
    The order this processor appears in the pipeline definition
    type: long
  </definition>
  <definition term="elasticsearch.ingest_pipeline.processor.count">
    Number of documents processed by this processor
    type: long
  </definition>
  <definition term="elasticsearch.ingest_pipeline.processor.failed">
    Number of documented failed to process by this processor
    type: long
  </definition>
  <definition term="elasticsearch.ingest_pipeline.processor.time.total.ms">
    Total time spent processing documents through this processor
    type: long
  </definition>
</definitions>


## ml.job

ml
<definitions>
  <definition term="elasticsearch.ml.job.id">
    Unique ml job id.
    type: keyword
  </definition>
  <definition term="elasticsearch.ml.job.state">
    Job state.
    type: keyword
  </definition>
  <definition term="elasticsearch.ml.job.forecasts_stats.total">
    type: long
  </definition>
  <definition term="elasticsearch.ml.job.model_size.memory_status">
    type: keyword
  </definition>
  <definition term="elasticsearch.ml.job.data_counts.invalid_date_count">
    type: long
  </definition>
  <definition term="elasticsearch.ml.job.data_counts.processed_record_count">
    Processed data events.
    type: long
  </definition>
  <definition term="elasticsearch.ml.job.data.invalid_date.count">
    The number of records with either a missing date field or a date that could not be parsed.
    type: long
  </definition>
</definitions>


## node

node
<definitions>
  <definition term="elasticsearch.node.version">
    Node version.
    type: keyword
  </definition>
</definitions>


## jvm

JVM Info.
<definitions>
  <definition term="elasticsearch.node.jvm.version">
    JVM version.
    type: keyword
  </definition>
  <definition term="elasticsearch.node.jvm.memory.heap.init.bytes">
    Heap init used by the JVM in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.jvm.memory.heap.max.bytes">
    Heap max used by the JVM in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.jvm.memory.nonheap.init.bytes">
    Non-Heap init used by the JVM in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.jvm.memory.nonheap.max.bytes">
    Non-Heap max used by the JVM in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.process.mlockall">
    If process locked in memory.
    type: boolean
  </definition>
</definitions>


## node.stats

Statistics about each node in a Elasticsearch cluster
<definitions>
  <definition term="elasticsearch.node.stats.ingest.total.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.ingest.total.time_in_millis">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.ingest.total.current">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.ingest.total.failed">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.bulk.avg_time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.bulk.total_time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.bulk.total_size.bytes">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.bulk.avg_size.bytes">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.bulk.operations.total.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.docs.count">
    Total number of existing documents.
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.docs.deleted">
    Total number of deleted documents.
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.segments.count">
    Total number of segments.
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.segments.memory.bytes">
    Total size of segments in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indices.store.size.bytes">
    Total size of all shards assigned to this node in bytes.
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.store.total_data_set_size.bytes">
    Total size of shards in bytes assigned to this node including backing data for partially mounted indices.
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.fielddata.evictions.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.fielddata.memory.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indices.flush.total_time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.flush.total.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.get.time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.get.total.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.indexing.index_time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.indexing.index_total.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.indexing.throttle_time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.merges.total_time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.merges.total.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.query_cache.memory.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indices.refresh.total_time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.refresh.total.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.request_cache.memory.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indices.search.query_time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.search.query_total.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.search.fetch_time.ms">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.search.fetch_total.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.shard_stats.total_count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.segments.doc_values.memory.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indices.segments.fixed_bit_set.memory.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indices.segments.index_writer.memory.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indices.segments.norms.memory.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indices.segments.points.memory.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indices.segments.stored_fields.memory.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indices.segments.term_vectors.memory.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indices.segments.terms.memory.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indices.segments.version_map.memory.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indices.translog.size.bytes">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indices.translog.operations.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.jvm.mem.heap.max.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.jvm.mem.heap.used.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.jvm.mem.heap.used.pct">
    type: double
    format: percent
  </definition>
  <definition term="elasticsearch.node.stats.jvm.threads.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.jvm.mem.pools.old.max.bytes">
    Max bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.jvm.mem.pools.old.peak.bytes">
    Peak bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.jvm.mem.pools.old.peak_max.bytes">
    Peak max bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.jvm.mem.pools.old.used.bytes">
    Used bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.jvm.mem.pools.young.max.bytes">
    Max bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.jvm.mem.pools.young.peak.bytes">
    Peak bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.jvm.mem.pools.young.peak_max.bytes">
    Peak max bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.jvm.mem.pools.young.used.bytes">
    Used bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.jvm.mem.pools.survivor.max.bytes">
    Max bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.jvm.mem.pools.survivor.peak.bytes">
    Peak bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.jvm.mem.pools.survivor.peak_max.bytes">
    Peak max bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.jvm.mem.pools.survivor.used.bytes">
    Used bytes.
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.jvm.gc.collectors.old.collection.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.jvm.gc.collectors.old.collection.ms">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.jvm.gc.collectors.young.collection.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.jvm.gc.collectors.young.collection.ms">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.fs.total.total_in_bytes">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.fs.total.available_in_bytes">
    type: long
  </definition>
</definitions>


## summary

File system summary
<definitions>
  <definition term="elasticsearch.node.stats.fs.summary.total.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.fs.summary.free.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.fs.summary.available.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.fs.io_stats.total.operations.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.fs.io_stats.total.read.operations.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.fs.io_stats.total.write.operations.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.os.cpu.load_avg.1m">
    type: half_float
  </definition>
  <definition term="elasticsearch.node.stats.os.cgroup.cpuacct.usage.ns">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.os.cgroup.cpu.cfs.quota.us">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.os.cgroup.cpu.stat.elapsed_periods.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.os.cgroup.cpu.stat.times_throttled.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.os.cgroup.cpu.stat.time_throttled.ns">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.os.cgroup.memory.control_group">
    type: keyword
  </definition>
  <definition term="elasticsearch.node.stats.os.cgroup.memory.limit.bytes">
    type: keyword
  </definition>
  <definition term="elasticsearch.node.stats.os.cgroup.memory.usage.bytes">
    type: keyword
  </definition>
  <definition term="elasticsearch.node.stats.process.cpu.pct">
    type: double
    format: percent
  </definition>
  <definition term="elasticsearch.node.stats.process.mem.total_virtual.bytes">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.process.open_file_descriptors">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.transport.rx.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.transport.rx.size.bytes">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.transport.tx.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.transport.tx.size.bytes">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.bulk.active.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.bulk.queue.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.bulk.rejected.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.esql_worker.active.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.esql_worker.queue.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.esql_worker.rejected.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.force_merge.active.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.force_merge.queue.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.force_merge.rejected.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.flush.active.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.flush.queue.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.flush.rejected.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.get.active.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.get.queue.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.get.rejected.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.index.active.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.index.queue.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.index.rejected.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.search.active.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.search.queue.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.search.rejected.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.search_worker.active.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.search_worker.queue.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.search_worker.rejected.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.snapshot.active.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.snapshot.queue.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.snapshot.rejected.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.system_read.active.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.system_read.queue.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.system_read.rejected.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.system_write.active.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.system_write.queue.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.system_write.rejected.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.write.active.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.write.queue.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.thread_pool.write.rejected.count">
    type: long
  </definition>
  <definition term="elasticsearch.node.stats.indexing_pressure.memory.current.combined_coordinating_and_primary.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indexing_pressure.memory.total.primary.rejections">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indexing_pressure.memory.total.primary.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indexing_pressure.memory.total.coordinating.rejections">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indexing_pressure.memory.total.coordinating.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indexing_pressure.memory.total.replica.rejections">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indexing_pressure.memory.total.replica.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indexing_pressure.memory.total.combined_coordinating_and_primary.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indexing_pressure.memory.current.coordinating.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indexing_pressure.memory.current.primary.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indexing_pressure.memory.current.replica.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indexing_pressure.memory.current.all.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indexing_pressure.memory.total.all.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="elasticsearch.node.stats.indexing_pressure.memory.limit_in_bytes">
    type: long
    format: bytes
  </definition>
</definitions>


## cluster.pending_task

`cluster.pending_task` contains a pending task description.
<definitions>
  <definition term="elasticsearch.cluster.pending_task.insert_order">
    Insert order
    type: long
  </definition>
  <definition term="elasticsearch.cluster.pending_task.priority">
    Priority
    type: long
  </definition>
  <definition term="elasticsearch.cluster.pending_task.source">
    Source. For example: put-mapping
    type: keyword
  </definition>
  <definition term="elasticsearch.cluster.pending_task.time_in_queue.ms">
    Time in queue
    type: long
  </definition>
</definitions>


## shard

shard fields
<definitions>
  <definition term="elasticsearch.shard.primary">
    True if this is the primary shard.
    type: boolean
  </definition>
  <definition term="elasticsearch.shard.number">
    The number of this shard.
    type: long
  </definition>
  <definition term="elasticsearch.shard.state">
    The state of this shard.
    type: keyword
  </definition>
  <definition term="elasticsearch.shard.relocating_node.name">
    The node the shard was relocated from.
    type: keyword
  </definition>
  <definition term="elasticsearch.shard.relocating_node.id">
    The node the shard was relocated from. It has the exact same value than relocating_node.name for compatibility purposes.
    type: keyword
  </definition>
  <definition term="elasticsearch.shard.source_node.name">
    type: keyword
  </definition>
  <definition term="elasticsearch.shard.source_node.uuid">
    type: keyword
  </definition>
</definitions>