﻿---
title: Docker fields
description: Docker stats collected from Docker. Information and statistics about docker's running containers. Docker container metrics. Container size metrics. Runtime...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-docker
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Docker fields
Docker stats collected from Docker.

## docker

Information and statistics about docker's running containers.

## container

Docker container metrics.
<definitions>
  <definition term="docker.container.command">
    Command that was executed in the Docker container.
    type: keyword
  </definition>
  <definition term="docker.container.created">
    Date when the container was created.
    type: date
  </definition>
  <definition term="docker.container.status">
    Container status.
    type: keyword
  </definition>
  <definition term="docker.container.ip_addresses">
    Container IP addresses.
    type: ip
  </definition>
</definitions>


## size

Container size metrics.
<definitions>
  <definition term="docker.container.size.root_fs">
    Total size of all the files in the container.
    type: long
  </definition>
  <definition term="docker.container.size.rw">
    Size of the files that have been created or changed since creation.
    type: long
  </definition>
  <definition term="docker.container.tags">
    Image tags.
    type: keyword
  </definition>
</definitions>


## cpu

Runtime CPU metrics.
<definitions>
  <definition term="docker.cpu.kernel.pct">
    Percentage of time in kernel space, expressed as a value between 0 and 1.
    type: scaled_float
    format: percent
  </definition>
  <definition term="docker.cpu.kernel.norm.pct">
    Percentage of time in kernel space normalized by the number of CPU cores, expressed as a value between 0 and 1.
    type: scaled_float
    format: percent
  </definition>
  <definition term="docker.cpu.kernel.ticks">
    CPU ticks in kernel space.
    type: long
  </definition>
  <definition term="docker.cpu.system.pct">
    Percentage of total CPU time in the system, expressed as a value between 0 and 1.
    type: scaled_float
    format: percent
  </definition>
  <definition term="docker.cpu.system.norm.pct">
    Percentage of total CPU time in the system normalized by the number of CPU cores, expressed as a value between 0 and 1.
    type: scaled_float
    format: percent
  </definition>
  <definition term="docker.cpu.system.ticks">
    CPU system ticks.
    type: long
  </definition>
  <definition term="docker.cpu.user.pct">
    Percentage of time in user space, expressed as a value between 0 and 1.
    type: scaled_float
    format: percent
  </definition>
  <definition term="docker.cpu.user.norm.pct">
    Percentage of time in user space normalized by the number of CPU cores, expressed as a value between 0 and 1.
    type: scaled_float
    format: percent
  </definition>
  <definition term="docker.cpu.user.ticks">
    CPU ticks in user space.
    type: long
  </definition>
  <definition term="docker.cpu.total.pct">
    Total CPU usage.
    type: scaled_float
    format: percent
  </definition>
  <definition term="docker.cpu.total.norm.pct">
    Total CPU usage normalized by the number of CPU cores.
    type: scaled_float
    format: percent
  </definition>
  <definition term="docker.cpu.core.*.pct">
    Percentage of CPU time in this core, expressed as a value between 0 and 1.
    type: object
    format: percent
  </definition>
  <definition term="docker.cpu.core.*.norm.pct">
    Percentage of CPU time in this core normalized by the number of CPU cores, expressed as a value between 0 and 1.
    type: object
    format: percent
  </definition>
  <definition term="docker.cpu.core.*.ticks">
    Number of CPU ticks in this core.
    type: object
  </definition>
</definitions>


## diskio

Disk I/O metrics.

## read

Accumulated reads during the life of the container
<definitions>
  <definition term="docker.diskio.read.ops">
    Number of reads during the life of the container
    type: long
  </definition>
  <definition term="docker.diskio.read.bytes">
    Bytes read during the life of the container
    type: long
    format: bytes
  </definition>
  <definition term="docker.diskio.read.rate">
    Number of current reads per second
    type: long
  </definition>
  <definition term="docker.diskio.read.service_time">
    Total time to service IO requests, in nanoseconds
    type: long
  </definition>
  <definition term="docker.diskio.read.wait_time">
    Total time requests spent waiting in queues for service, in nanoseconds
    type: long
  </definition>
  <definition term="docker.diskio.read.queued">
    Total number of queued requests
    type: long
  </definition>
</definitions>


## write

Accumulated writes during the life of the container
<definitions>
  <definition term="docker.diskio.write.ops">
    Number of writes during the life of the container
    type: long
  </definition>
  <definition term="docker.diskio.write.bytes">
    Bytes written during the life of the container
    type: long
    format: bytes
  </definition>
  <definition term="docker.diskio.write.rate">
    Number of current writes per second
    type: long
  </definition>
  <definition term="docker.diskio.write.service_time">
    Total time to service IO requests, in nanoseconds
    type: long
  </definition>
  <definition term="docker.diskio.write.wait_time">
    Total time requests spent waiting in queues for service, in nanoseconds
    type: long
  </definition>
  <definition term="docker.diskio.write.queued">
    Total number of queued requests
    type: long
  </definition>
</definitions>


## summary

Accumulated reads and writes during the life of the container
<definitions>
  <definition term="docker.diskio.summary.ops">
    Number of I/O operations during the life of the container
    type: long
  </definition>
  <definition term="docker.diskio.summary.bytes">
    Bytes read and written during the life of the container
    type: long
    format: bytes
  </definition>
  <definition term="docker.diskio.summary.rate">
    Number of current operations per second
    type: long
  </definition>
  <definition term="docker.diskio.summary.service_time">
    Total time to service IO requests, in nanoseconds
    type: long
  </definition>
  <definition term="docker.diskio.summary.wait_time">
    Total time requests spent waiting in queues for service, in nanoseconds
    type: long
  </definition>
  <definition term="docker.diskio.summary.queued">
    Total number of queued requests
    type: long
  </definition>
</definitions>


## event

Docker event
<definitions>
  <definition term="docker.event.status">
    Event status
    type: keyword
  </definition>
  <definition term="docker.event.id">
    Event id when available
    type: keyword
  </definition>
  <definition term="docker.event.from">
    Event source
    type: keyword
  </definition>
  <definition term="docker.event.type">
    The type of object emitting the event
    type: keyword
  </definition>
  <definition term="docker.event.action">
    The type of event
    type: keyword
  </definition>
</definitions>


## actor

Actor
<definitions>
  <definition term="docker.event.actor.id">
    The ID of the object emitting the event
    type: keyword
  </definition>
  <definition term="docker.event.actor.attributes">
    Various key/value attributes of the object, depending on its type
    type: object
  </definition>
</definitions>


## healthcheck

Docker healthcheck metrics.
Healthcheck data will only be available from docker containers where the docker `HEALTHCHECK` instruction has been used to build the docker image.
<definitions>
  <definition term="docker.healthcheck.failingstreak">
    concurent failed check
    type: integer
  </definition>
  <definition term="docker.healthcheck.status">
    Healthcheck status code
    type: keyword
  </definition>
</definitions>


## event

event fields.
<definitions>
  <definition term="docker.healthcheck.event.end_date">
    Healthcheck end date
    type: date
  </definition>
  <definition term="docker.healthcheck.event.start_date">
    Healthcheck start date
    type: date
  </definition>
  <definition term="docker.healthcheck.event.output">
    Healthcheck output
    type: keyword
  </definition>
  <definition term="docker.healthcheck.event.exit_code">
    Healthcheck status code
    type: integer
  </definition>
</definitions>


## image

Docker image metrics.

## id

The image layers identifier.
<definitions>
  <definition term="docker.image.id.current">
    Unique image identifier given upon its creation.
    type: keyword
  </definition>
  <definition term="docker.image.id.parent">
    Identifier of the image, if it exists, from which the current image directly descends.
    type: keyword
  </definition>
  <definition term="docker.image.created">
    Date and time when the image was created.
    type: date
  </definition>
</definitions>


## size

Image size layers.
<definitions>
  <definition term="docker.image.size.virtual">
    Size of the image.
    type: long
  </definition>
  <definition term="docker.image.size.regular">
    Total size of the all cached images associated to the current image.
    type: long
  </definition>
  <definition term="docker.image.labels">
    Image labels.
    type: object
  </definition>
  <definition term="docker.image.tags">
    Image tags.
    type: keyword
  </definition>
</definitions>


## info

Info metrics based on [https://docs.docker.com/engine/reference/api/docker_remote_api_v1.24/#/display-system-wide-information](https://docs.docker.com/engine/reference/api/docker_remote_api_v1.24/#/display-system-wide-information).

## containers

Overall container stats.
<definitions>
  <definition term="docker.info.containers.paused">
    Total number of paused containers.
    type: long
  </definition>
  <definition term="docker.info.containers.running">
    Total number of running containers.
    type: long
  </definition>
  <definition term="docker.info.containers.stopped">
    Total number of stopped containers.
    type: long
  </definition>
  <definition term="docker.info.containers.total">
    Total number of existing containers.
    type: long
  </definition>
  <definition term="docker.info.id">
    Unique Docker host identifier.
    type: keyword
  </definition>
  <definition term="docker.info.images">
    Total number of existing images.
    type: long
  </definition>
</definitions>


## memory

Memory metrics.
<definitions>
  <definition term="docker.memory.stats.*">
    Raw memory stats from the cgroups memory.stat interface
    type: object
  </definition>
</definitions>


## commit

Committed bytes on Windows
<definitions>
  <definition term="docker.memory.commit.total">
    Total bytes
    type: long
    format: bytes
  </definition>
  <definition term="docker.memory.commit.peak">
    Peak committed bytes on Windows
    type: long
    format: bytes
  </definition>
  <definition term="docker.memory.private_working_set.total">
    private working sets on Windows
    type: long
    format: bytes
  </definition>
  <definition term="docker.memory.fail.count">
    Fail counter.
    type: scaled_float
  </definition>
  <definition term="docker.memory.limit">
    Memory limit.
    type: long
    format: bytes
  </definition>
</definitions>


## rss

RSS memory stats.
<definitions>
  <definition term="docker.memory.rss.total">
    Total memory resident set size.
    type: long
    format: bytes
  </definition>
  <definition term="docker.memory.rss.pct">
    Memory resident set size percentage, expressed as a value between 0 and 1.
    type: scaled_float
    format: percent
  </definition>
</definitions>


## usage

Usage memory stats.
<definitions>
  <definition term="docker.memory.usage.max">
    Max memory usage.
    type: long
    format: bytes
  </definition>
  <definition term="docker.memory.usage.pct">
    Memory usage percentage, expressed as a value between 0 and 1.
    type: scaled_float
    format: percent
  </definition>
  <definition term="docker.memory.usage.total">
    Total memory usage.
    type: long
    format: bytes
  </definition>
</definitions>


## network

Network metrics.
<definitions>
  <definition term="docker.network.interface">
    Network interface name.
    type: keyword
  </definition>
</definitions>


## in

Incoming network stats per second.
<definitions>
  <definition term="docker.network.in.bytes">
    Incoming bytes per seconds.
    type: long
    format: bytes
  </definition>
  <definition term="docker.network.in.dropped">
    Dropped incoming packets per second.
    type: scaled_float
  </definition>
  <definition term="docker.network.in.errors">
    Errors on incoming packets per second.
    type: long
  </definition>
  <definition term="docker.network.in.packets">
    Incoming packets per second.
    type: long
  </definition>
</definitions>


## out

Outgoing network stats per second.
<definitions>
  <definition term="docker.network.out.bytes">
    Outgoing bytes per second.
    type: long
    format: bytes
  </definition>
  <definition term="docker.network.out.dropped">
    Dropped outgoing packets per second.
    type: scaled_float
  </definition>
  <definition term="docker.network.out.errors">
    Errors on outgoing packets per second.
    type: long
  </definition>
  <definition term="docker.network.out.packets">
    Outgoing packets per second.
    type: long
  </definition>
</definitions>


## inbound

Incoming network stats since the container started.
<definitions>
  <definition term="docker.network.inbound.bytes">
    Total number of incoming bytes.
    type: long
    format: bytes
  </definition>
  <definition term="docker.network.inbound.dropped">
    Total number of dropped incoming packets.
    type: long
  </definition>
  <definition term="docker.network.inbound.errors">
    Total errors on incoming packets.
    type: long
  </definition>
  <definition term="docker.network.inbound.packets">
    Total number of incoming packets.
    type: long
  </definition>
</definitions>


## outbound

Outgoing network stats since the container started.
<definitions>
  <definition term="docker.network.outbound.bytes">
    Total number of outgoing bytes.
    type: long
    format: bytes
  </definition>
  <definition term="docker.network.outbound.dropped">
    Total number of dropped outgoing packets.
    type: long
  </definition>
  <definition term="docker.network.outbound.errors">
    Total errors on outgoing packets.
    type: long
  </definition>
  <definition term="docker.network.outbound.packets">
    Total number of outgoing packets.
    type: long
  </definition>
</definitions>


## network_summary

<applies-to>
  - Elastic Stack: Beta
</applies-to>

network_summary
<definitions>
  <definition term="docker.network_summary.ip.*">
    IP counters
    type: object
  </definition>
  <definition term="docker.network_summary.tcp.*">
    TCP counters
    type: object
  </definition>
  <definition term="docker.network_summary.udp.*">
    UDP counters
    type: object
  </definition>
  <definition term="docker.network_summary.udp_lite.*">
    UDP Lite counters
    type: object
  </definition>
  <definition term="docker.network_summary.icmp.*">
    ICMP counters
    type: object
  </definition>
  <definition term="docker.network_summary.namespace.pid">
    The root PID of the container, corresponding to /proc/[pid]/net
    type: long
  </definition>
  <definition term="docker.network_summary.namespace.id">
    The ID of the network namespace used by the container, corresponding to /proc/[pid]/ns/net
    type: long
  </definition>
</definitions>