﻿---
title: Couchbase fields
description: Metrics collected from Couchbase servers. couchbase contains the metrics that were scraped from Couchbase. Couchbase bucket metrics. Couchbase cluster...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-couchbase
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Couchbase fields
Metrics collected from Couchbase servers.

## couchbase

`couchbase` contains the metrics that were scraped from Couchbase.

## bucket

Couchbase bucket metrics.
<definitions>
  <definition term="couchbase.bucket.name">
    Name of the bucket.
    type: keyword
  </definition>
  <definition term="couchbase.bucket.type">
    Type of the bucket.
    type: keyword
  </definition>
  <definition term="couchbase.bucket.data.used.bytes">
    Size of user data within buckets of the specified state that are resident in RAM.
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.bucket.disk.fetches">
    Number of disk fetches.
    type: double
  </definition>
  <definition term="couchbase.bucket.disk.used.bytes">
    Amount of disk used (bytes).
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.bucket.memory.used.bytes">
    Amount of memory used by the bucket (bytes).
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.bucket.quota.ram.bytes">
    Amount of RAM used by the bucket (bytes).
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.bucket.quota.use.pct">
    Percentage of RAM used (for active objects) against the configured bucket size (%).
    type: scaled_float
    format: percent
  </definition>
  <definition term="couchbase.bucket.ops_per_sec">
    Number of operations per second.
    type: double
  </definition>
  <definition term="couchbase.bucket.item_count">
    Number of items associated with the bucket.
    type: long
  </definition>
</definitions>


## cluster

Couchbase cluster metrics.
<definitions>
  <definition term="couchbase.cluster.hdd.free.bytes">
    Free hard drive space in the cluster (bytes).
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.cluster.hdd.quota.total.bytes">
    Hard drive quota total for the cluster (bytes).
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.cluster.hdd.total.bytes">
    Total hard drive space available to the cluster (bytes).
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.cluster.hdd.used.value.bytes">
    Hard drive space used by the cluster (bytes).
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.cluster.hdd.used.by_data.bytes">
    Hard drive space used by the data in the cluster (bytes).
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.cluster.max_bucket_count">
    Max bucket count setting.
    type: long
  </definition>
  <definition term="couchbase.cluster.quota.index_memory.mb">
    Memory quota setting for the Index service (Mbyte).
    type: double
  </definition>
  <definition term="couchbase.cluster.quota.memory.mb">
    Memory quota setting for the cluster (Mbyte).
    type: double
  </definition>
  <definition term="couchbase.cluster.ram.quota.total.value.bytes">
    RAM quota total for the cluster (bytes).
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.cluster.ram.quota.total.per_node.bytes">
    RAM quota used by the current node in the cluster (bytes).
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.cluster.ram.quota.used.value.bytes">
    RAM quota used by the cluster (bytes).
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.cluster.ram.quota.used.per_node.bytes">
    Ram quota used by the current node in the cluster (bytes)
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.cluster.ram.total.bytes">
    Total RAM available to cluster (bytes).
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.cluster.ram.used.value.bytes">
    RAM used by the cluster (bytes).
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.cluster.ram.used.by_data.bytes">
    RAM used by the data in the cluster (bytes).
    type: long
    format: bytes
  </definition>
</definitions>


## node

Couchbase node metrics.
<definitions>
  <definition term="couchbase.node.cmd_get">
    Number of get commands
    type: double
  </definition>
  <definition term="couchbase.node.couch.docs.disk_size.bytes">
    Amount of disk space used by Couch docs (bytes).
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.node.couch.docs.data_size.bytes">
    Data size of Couch docs associated with a node (bytes).
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.node.couch.spatial.data_size.bytes">
    Size of object data for spatial views (bytes).
    type: long
  </definition>
  <definition term="couchbase.node.couch.spatial.disk_size.bytes">
    Amount of disk space used by spatial views (bytes).
    type: long
  </definition>
  <definition term="couchbase.node.couch.views.disk_size.bytes">
    Amount of disk space used by Couch views (bytes).
    type: long
  </definition>
  <definition term="couchbase.node.couch.views.data_size.bytes">
    Size of object data for Couch views (bytes).
    type: long
  </definition>
  <definition term="couchbase.node.cpu_utilization_rate.pct">
    The CPU utilization rate (%).
    type: scaled_float
  </definition>
  <definition term="couchbase.node.current_items.value">
    Number of current items.
    type: long
  </definition>
  <definition term="couchbase.node.current_items.total">
    Total number of items associated with the node.
    type: long
  </definition>
  <definition term="couchbase.node.ep_bg_fetched">
    Number of disk fetches performed since the server was started.
    type: long
  </definition>
  <definition term="couchbase.node.get_hits">
    Number of get hits.
    type: double
  </definition>
  <definition term="couchbase.node.hostname">
    The hostname of the node.
    type: keyword
  </definition>
  <definition term="couchbase.node.mcd_memory.allocated.bytes">
    Amount of memcached memory allocated (bytes).
    type: long
    format: bytes
  </definition>
  <definition term="couchbase.node.mcd_memory.reserved.bytes">
    Amount of memcached memory reserved (bytes).
    type: long
  </definition>
  <definition term="couchbase.node.memory.free.bytes">
    Amount of memory free for the node (bytes).
    type: long
  </definition>
  <definition term="couchbase.node.memory.total.bytes">
    Total memory available to the node (bytes).
    type: long
  </definition>
  <definition term="couchbase.node.memory.used.bytes">
    Memory used by the node (bytes).
    type: long
  </definition>
  <definition term="couchbase.node.ops">
    Number of operations performed on Couchbase.
    type: double
  </definition>
  <definition term="couchbase.node.swap.total.bytes">
    Total swap size allocated (bytes).
    type: long
  </definition>
  <definition term="couchbase.node.swap.used.bytes">
    Amount of swap space used (bytes).
    type: long
  </definition>
  <definition term="couchbase.node.uptime.sec">
    Time during which the node was in operation (sec).
    type: long
  </definition>
  <definition term="couchbase.node.vb_replica_curr_items">
    Number of items/documents that are replicas.
    type: long
  </definition>
</definitions>