﻿---
title: Containerd fields
description: Containerd stats collected from containerd Information and statistics about containerd's running containers. Block I/O metrics. Accumulated reads during...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-containerd
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Containerd fields
Containerd stats collected from containerd

## containerd

Information and statistics about containerd's running containers.
<definitions>
  <definition term="containerd.namespace">
    Containerd namespace
    type: keyword
  </definition>
</definitions>


## blkio

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Block I/O metrics.
<definitions>
  <definition term="containerd.blkio.device">
    Name of block device
    type: keyword
  </definition>
</definitions>


## read

Accumulated reads during the life of the container
<definitions>
  <definition term="containerd.blkio.read.ops">
    Number of reads during the life of the container
    type: long
  </definition>
  <definition term="containerd.blkio.read.bytes">
    Bytes read during the life of the container
    type: long
    format: bytes
  </definition>
</definitions>


## write

Accumulated writes during the life of the container
<definitions>
  <definition term="containerd.blkio.write.ops">
    Number of writes during the life of the container
    type: long
  </definition>
  <definition term="containerd.blkio.write.bytes">
    Bytes written during the life of the container
    type: long
    format: bytes
  </definition>
</definitions>


## summary

Accumulated reads and writes during the life of the container
<definitions>
  <definition term="containerd.blkio.summary.ops">
    Number of I/O operations during the life of the container
    type: long
  </definition>
  <definition term="containerd.blkio.summary.bytes">
    Bytes read and written during the life of the container
    type: long
    format: bytes
  </definition>
</definitions>


## cpu

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Containerd Runtime CPU metrics.
<definitions>
  <definition term="containerd.cpu.system.total">
    Total user and system CPU time spent in seconds.
    type: double
  </definition>
  <definition term="containerd.cpu.usage.kernel.ns">
    CPU Kernel usage nanoseconds
    type: double
  </definition>
  <definition term="containerd.cpu.usage.user.ns">
    CPU User usage nanoseconds
    type: double
  </definition>
  <definition term="containerd.cpu.usage.total.ns">
    CPU total usage nanoseconds
    type: double
  </definition>
  <definition term="containerd.cpu.usage.total.pct">
    Percentage of total CPU time normalized by the number of CPU cores, expressed as a value between 0 and 1.
    type: scaled_float
    format: percent
  </definition>
  <definition term="containerd.cpu.usage.kernel.pct">
    Percentage of time in kernel space normalized by the number of CPU cores, expressed as a value between 0 and 1.
    type: scaled_float
    format: percent
  </definition>
  <definition term="containerd.cpu.usage.user.pct">
    Percentage of time in user space normalized by the number of CPU cores, expressed as a value between 0 and 1.
    type: scaled_float
    format: percent
  </definition>
  <definition term="containerd.cpu.usage.cpu.*.ns">
    CPU usage nanoseconds in this cpu.
    type: object
  </definition>
</definitions>


## memory

<applies-to>
  - Elastic Stack: Beta
</applies-to>

memory
<definitions>
  <definition term="containerd.memory.workingset.pct">
    Memory working set percentage.
    type: scaled_float
    format: percent
  </definition>
  <definition term="containerd.memory.rss">
    Total memory resident set size.
    type: long
    format: bytes
  </definition>
  <definition term="containerd.memory.activeFiles">
    Total active file bytes.
    type: long
    format: bytes
  </definition>
  <definition term="containerd.memory.cache">
    Total cache bytes.
    type: long
    format: bytes
  </definition>
  <definition term="containerd.memory.inactiveFiles">
    Total inactive file bytes.
    type: long
    format: bytes
  </definition>
</definitions>


## usage

Usage memory stats.
<definitions>
  <definition term="containerd.memory.usage.max">
    Max memory usage.
    type: long
    format: bytes
  </definition>
  <definition term="containerd.memory.usage.pct">
    Total allocated memory percentage.
    type: scaled_float
    format: percent
  </definition>
  <definition term="containerd.memory.usage.total">
    Total memory usage.
    type: long
    format: bytes
  </definition>
  <definition term="containerd.memory.usage.fail.count">
    Fail counter.
    type: scaled_float
  </definition>
  <definition term="containerd.memory.usage.limit">
    Memory usage limit.
    type: long
    format: bytes
  </definition>
</definitions>


## kernel

Kernel memory stats.
<definitions>
  <definition term="containerd.memory.kernel.max">
    Kernel max memory usage.
    type: long
    format: bytes
  </definition>
  <definition term="containerd.memory.kernel.total">
    Kernel total memory usage.
    type: long
    format: bytes
  </definition>
  <definition term="containerd.memory.kernel.fail.count">
    Kernel fail counter.
    type: scaled_float
  </definition>
  <definition term="containerd.memory.kernel.limit">
    Kernel memory limit.
    type: long
    format: bytes
  </definition>
</definitions>


## swap

Swap memory stats.
<definitions>
  <definition term="containerd.memory.swap.max">
    Swap max memory usage.
    type: long
    format: bytes
  </definition>
  <definition term="containerd.memory.swap.total">
    Swap total memory usage.
    type: long
    format: bytes
  </definition>
  <definition term="containerd.memory.swap.fail.count">
    Swap fail counter.
    type: scaled_float
  </definition>
  <definition term="containerd.memory.swap.limit">
    Swap memory limit.
    type: long
    format: bytes
  </definition>
</definitions>