﻿---
title: Consul fields
description: Consul module Agent Metricset fetches metrics information from a Consul instance running as Agent Runtime related metrics Garbage collector metrics Time...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-consul
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Consul fields
Consul module

## agent

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Agent Metricset fetches metrics information from a Consul instance running as Agent
<definitions>
  <definition term="consul.agent.autopilot.healthy">
    Overall health of the local server cluster
    type: boolean
  </definition>
</definitions>


## runtime

Runtime related metrics
<definitions>
  <definition term="consul.agent.runtime.sys.bytes">
    Number of bytes of memory obtained from the OS.
    type: long
  </definition>
  <definition term="consul.agent.runtime.malloc_count">
    Heap objects allocated
    type: long
  </definition>
  <definition term="consul.agent.runtime.heap_objects">
    Objects allocated on the heap and is a general memory pressure indicator. This may burst from time to time but should return to a steady state value.
    type: long
  </definition>
  <definition term="consul.agent.runtime.goroutines">
    Running goroutines and is a general load pressure indicator. This may burst from time to time but should return to a steady state value.
    type: long
  </definition>
  <definition term="consul.agent.runtime.alloc.bytes">
    Bytes allocated by the Consul process.
    type: long
  </definition>
</definitions>


## garbage_collector

Garbage collector metrics
<definitions>
  <definition term="consul.agent.runtime.garbage_collector.runs">
    Garbage collector total executions
    type: long
  </definition>
</definitions>


## pause

Time that the garbage collector has paused the app
<definitions>
  <definition term="consul.agent.runtime.garbage_collector.pause.current.ns">
    Garbage collector pause time in nanoseconds
    type: long
  </definition>
  <definition term="consul.agent.runtime.garbage_collector.pause.total.ns">
    Nanoseconds consumed by stop-the-world garbage collection pauses since Consul started.
    type: long
  </definition>
</definitions>