﻿---
title: Common fields
description: Contains common fields available in all event types. 
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-common
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Common fields
Contains common fields available in all event types.
<definitions>
  <definition term="metricset.module">
    The name of the module that generated the event.
    type: alias
    alias to: event.module
  </definition>
  <definition term="metricset.name">
    The name of the metricset that generated the event.
  </definition>
  <definition term="metricset.period">
    Current data collection period for this event in milliseconds.
    type: integer
  </definition>
  <definition term="service.hostname">
    Host name of the machine where the service is running.
  </definition>
  <definition term="type">
    The document type. Always set to "doc".
    example: metricsets
    required: True
  </definition>
  <definition term="systemd.fragment_path">
    the location of the systemd unit path
    type: keyword
  </definition>
  <definition term="systemd.unit">
    the unit name of the systemd service
    type: keyword
  </definition>
</definitions>