﻿---
title: Cloudfoundry fields
description: Cloud Foundry module The application the metric is associated with. container contains container metrics from Cloud Foundry. counter contains counter...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-cloudfoundry
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Cloudfoundry fields
Cloud Foundry module

## cloudfoundry

<definitions>
  <definition term="cloudfoundry.type">
    The type of event from Cloud Foundry. Possible values include 'container', 'counter' and 'value'.
    type: keyword
  </definition>
</definitions>


## app

The application the metric is associated with.
<definitions>
  <definition term="cloudfoundry.app.id">
    The ID of the application.
    type: keyword
  </definition>
</definitions>


## container

<applies-to>
  - Elastic Stack: Beta
</applies-to>

`container` contains container metrics from Cloud Foundry.
<definitions>
  <definition term="cloudfoundry.container.instance_index">
    Index of the instance the metric belongs to.
    type: long
  </definition>
  <definition term="cloudfoundry.container.cpu.pct">
    CPU usage percentage.
    type: scaled_float
  </definition>
  <definition term="cloudfoundry.container.memory.bytes">
    Bytes of used memory.
    type: long
  </definition>
  <definition term="cloudfoundry.container.memory.quota.bytes">
    Bytes of available memory.
    type: long
  </definition>
  <definition term="cloudfoundry.container.disk.bytes">
    Bytes of used storage.
    type: long
  </definition>
  <definition term="cloudfoundry.container.disk.quota.bytes">
    Bytes of available storage.
    type: long
  </definition>
</definitions>


## counter

<applies-to>
  - Elastic Stack: Beta
</applies-to>

`counter` contains counter metrics from Cloud Foundry.
<definitions>
  <definition term="cloudfoundry.counter.name">
    The name of the counter.
    type: keyword
  </definition>
  <definition term="cloudfoundry.counter.delta">
    The difference between the last time the counter event occurred.
    type: long
  </definition>
  <definition term="cloudfoundry.counter.total">
    The total value for the counter.
    type: long
  </definition>
</definitions>


## value

<applies-to>
  - Elastic Stack: Beta
</applies-to>

`value` contains counter metrics from Cloud Foundry.
<definitions>
  <definition term="cloudfoundry.value.name">
    The name of the value.
    type: keyword
  </definition>
  <definition term="cloudfoundry.value.unit">
    The unit of the value.
    type: keyword
  </definition>
  <definition term="cloudfoundry.value.value">
    The value of the value.
    type: float
  </definition>
</definitions>