﻿---
title: Ceph fields
description: Ceph module ceph contains the metrics that were scraped from CEPH. cluster_disk cluster_health cluster_status see: cluster_disk see: cluster_health OSD...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-ceph
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Ceph fields
Ceph module

## ceph

`ceph` contains the metrics that were scraped from CEPH.

## cluster_disk

cluster_disk
<definitions>
  <definition term="ceph.cluster_disk.available.bytes">
    Available bytes of the cluster
    type: long
    format: bytes
  </definition>
  <definition term="ceph.cluster_disk.total.bytes">
    Total bytes of the cluster
    type: long
    format: bytes
  </definition>
  <definition term="ceph.cluster_disk.used.bytes">
    Used bytes of the cluster
    type: long
    format: bytes
  </definition>
</definitions>


## cluster_health

cluster_health
<definitions>
  <definition term="ceph.cluster_health.overall_status">
    Overall status of the cluster
    type: keyword
  </definition>
  <definition term="ceph.cluster_health.timechecks.epoch">
    Map version
    type: long
  </definition>
  <definition term="ceph.cluster_health.timechecks.round.value">
    timecheck round
    type: long
  </definition>
  <definition term="ceph.cluster_health.timechecks.round.status">
    Status of the round
    type: keyword
  </definition>
</definitions>


## cluster_status

cluster_status
<definitions>
  <definition term="ceph.cluster_status.version">
    Ceph Status version
    type: long
  </definition>
  <definition term="ceph.cluster_status.traffic.read_bytes">
    Cluster read throughput per second
    type: long
    format: bytes
  </definition>
  <definition term="ceph.cluster_status.traffic.write_bytes">
    Cluster write throughput per second
    type: long
    format: bytes
  </definition>
  <definition term="ceph.cluster_status.traffic.read_op_per_sec">
    Cluster read iops per second
    type: long
  </definition>
  <definition term="ceph.cluster_status.traffic.write_op_per_sec">
    Cluster write iops per second
    type: long
  </definition>
  <definition term="ceph.cluster_status.misplace.total">
    Cluster misplace pg number
    type: long
  </definition>
  <definition term="ceph.cluster_status.misplace.objects">
    Cluster misplace objects number
    type: long
  </definition>
  <definition term="ceph.cluster_status.misplace.ratio">
    Cluster misplace ratio
    type: scaled_float
    format: percent
  </definition>
  <definition term="ceph.cluster_status.degraded.total">
    Cluster degraded pg number
    type: long
  </definition>
  <definition term="ceph.cluster_status.degraded.objects">
    Cluster degraded objects number
    type: long
  </definition>
  <definition term="ceph.cluster_status.degraded.ratio">
    Cluster degraded ratio
    type: scaled_float
    format: percent
  </definition>
  <definition term="ceph.cluster_status.pg.data_bytes">
    Cluster pg data bytes
    type: long
    format: bytes
  </definition>
  <definition term="ceph.cluster_status.pg.avail_bytes">
    Cluster available bytes
    type: long
    format: bytes
  </definition>
  <definition term="ceph.cluster_status.pg.total_bytes">
    Cluster total bytes
    type: long
    format: bytes
  </definition>
  <definition term="ceph.cluster_status.pg.used_bytes">
    Cluster used bytes
    type: long
    format: bytes
  </definition>
  <definition term="ceph.cluster_status.pg_state.state_name">
    Pg state description
    type: long
  </definition>
  <definition term="ceph.cluster_status.pg_state.count">
    Shows how many pgs are in state of pg_state.state_name
    type: long
  </definition>
  <definition term="ceph.cluster_status.pg_state.version">
    Cluster status version
    type: long
  </definition>
  <definition term="ceph.cluster_status.osd.full">
    Is osd full
    type: boolean
  </definition>
  <definition term="ceph.cluster_status.osd.nearfull">
    Is osd near full
    type: boolean
  </definition>
  <definition term="ceph.cluster_status.osd.num_osds">
    Shows how many osds in the cluster
    type: long
  </definition>
  <definition term="ceph.cluster_status.osd.num_up_osds">
    Shows how many osds are on the state of UP
    type: long
  </definition>
  <definition term="ceph.cluster_status.osd.num_in_osds">
    Shows how many osds are on the state of IN
    type: long
  </definition>
  <definition term="ceph.cluster_status.osd.num_remapped_pgs">
    Shows how many osds are on the state of REMAPPED
    type: long
  </definition>
  <definition term="ceph.cluster_status.osd.epoch">
    epoch number
    type: long
  </definition>
</definitions>


## mgr_cluster_disk

<applies-to>
  - Elastic Stack: Beta
</applies-to>

see: cluster_disk

## mgr_cluster_health

<applies-to>
  - Elastic Stack: Beta
</applies-to>

see: cluster_health

## mgr_osd_perf

<applies-to>
  - Elastic Stack: Beta
</applies-to>

OSD performance metrics of Ceph cluster
<definitions>
  <definition term="ceph.mgr_osd_perf.id">
    OSD ID
    type: long
  </definition>
  <definition term="ceph.mgr_osd_perf.stats.commit_latency_ms">
    Commit latency in ms
    type: long
  </definition>
  <definition term="ceph.mgr_osd_perf.stats.apply_latency_ms">
    Apply latency in ms
    type: long
  </definition>
  <definition term="ceph.mgr_osd_perf.stats.commit_latency_ns">
    Commit latency in ns
    type: long
  </definition>
  <definition term="ceph.mgr_osd_perf.stats.apply_latency_ns">
    Apply latency in ns
    type: long
  </definition>
</definitions>


## mgr_osd_pool_stats

<applies-to>
  - Elastic Stack: Beta
</applies-to>

OSD pool stats of Ceph cluster
<definitions>
  <definition term="ceph.mgr_osd_pool_stats.pool_name">
    Pool name
    type: keyword
  </definition>
  <definition term="ceph.mgr_osd_pool_stats.pool_id">
    Pool ID
    type: long
  </definition>
  <definition term="ceph.mgr_osd_pool_stats.client_io_rate">
    Client I/O rates
    type: object
  </definition>
</definitions>


## mgr_osd_tree

<applies-to>
  - Elastic Stack: Beta
</applies-to>

see: osd_tree

## mgr_pool_disk

<applies-to>
  - Elastic Stack: Beta
</applies-to>

see: pool_disk

## monitor_health

monitor_health stats data
<definitions>
  <definition term="ceph.monitor_health.available.pct">
    Available percent of the MON
    type: long
  </definition>
  <definition term="ceph.monitor_health.health">
    Health of the MON
    type: keyword
  </definition>
  <definition term="ceph.monitor_health.available.kb">
    Available KB of the MON
    type: long
  </definition>
  <definition term="ceph.monitor_health.total.kb">
    Total KB of the MON
    type: long
  </definition>
  <definition term="ceph.monitor_health.used.kb">
    Used KB of the MON
    type: long
  </definition>
  <definition term="ceph.monitor_health.last_updated">
    Time when was updated
    type: date
  </definition>
  <definition term="ceph.monitor_health.name">
    Name of the MON
    type: keyword
  </definition>
  <definition term="ceph.monitor_health.store_stats.log.bytes">
    Log bytes of MON
    type: long
    format: bytes
  </definition>
  <definition term="ceph.monitor_health.store_stats.misc.bytes">
    Misc bytes of MON
    type: long
    format: bytes
  </definition>
  <definition term="ceph.monitor_health.store_stats.sst.bytes">
    SST bytes of MON
    type: long
    format: bytes
  </definition>
  <definition term="ceph.monitor_health.store_stats.total.bytes">
    Total bytes of MON
    type: long
    format: bytes
  </definition>
  <definition term="ceph.monitor_health.store_stats.last_updated">
    Last updated
    type: long
  </definition>
</definitions>


## osd_df

ceph osd disk usage information
<definitions>
  <definition term="ceph.osd_df.id">
    osd node id
    type: long
  </definition>
  <definition term="ceph.osd_df.name">
    osd node name
    type: keyword
  </definition>
  <definition term="ceph.osd_df.device_class">
    osd node type, illegal type include hdd, ssd etc.
    type: keyword
  </definition>
  <definition term="ceph.osd_df.total.byte">
    osd disk total volume
    type: long
    format: bytes
  </definition>
  <definition term="ceph.osd_df.used.byte">
    osd disk usage volume
    type: long
    format: bytes
  </definition>
  <definition term="ceph.osd_df.available.bytes">
    osd disk available volume
    type: long
    format: bytes
  </definition>
  <definition term="ceph.osd_df.pg_num">
    shows how many pg located on this osd
    type: long
  </definition>
  <definition term="ceph.osd_df.used.pct">
    osd disk usage percentage
    type: scaled_float
    format: percent
  </definition>
</definitions>


## osd_tree

ceph osd tree info
<definitions>
  <definition term="ceph.osd_tree.id">
    osd or bucket node id
    type: long
  </definition>
  <definition term="ceph.osd_tree.name">
    osd or bucket node name
    type: keyword
  </definition>
  <definition term="ceph.osd_tree.type">
    osd or bucket node type, illegal type include osd, host, root etc.
    type: keyword
  </definition>
  <definition term="ceph.osd_tree.type_id">
    osd or bucket node typeID
    type: long
  </definition>
  <definition term="ceph.osd_tree.children">
    bucket children list, separated by comma.
    type: keyword
  </definition>
  <definition term="ceph.osd_tree.crush_weight">
    osd node crush weight
    type: float
  </definition>
  <definition term="ceph.osd_tree.depth">
    node depth
    type: long
  </definition>
  <definition term="ceph.osd_tree.exists">
    is node still exist or not(1-yes, 0-no)
    type: boolean
  </definition>
  <definition term="ceph.osd_tree.primary_affinity">
    the weight of reading data from primary osd
    type: float
  </definition>
  <definition term="ceph.osd_tree.reweight">
    the reweight of osd
    type: long
  </definition>
  <definition term="ceph.osd_tree.status">
    status of osd, it should be up or down
    type: keyword
  </definition>
  <definition term="ceph.osd_tree.device_class">
    the device class of osd, like hdd, ssd etc.
    type: keyword
  </definition>
  <definition term="ceph.osd_tree.father">
    the parent node of this osd or bucket node
    type: keyword
  </definition>
</definitions>


## pool_disk

pool_disk
<definitions>
  <definition term="ceph.pool_disk.id">
    Id of the pool
    type: long
  </definition>
  <definition term="ceph.pool_disk.name">
    Name of the pool
    type: keyword
  </definition>
  <definition term="ceph.pool_disk.stats.available.bytes">
    Available bytes of the pool
    type: long
    format: bytes
  </definition>
  <definition term="ceph.pool_disk.stats.objects">
    Number of objects of the pool
    type: long
  </definition>
  <definition term="ceph.pool_disk.stats.used.bytes">
    Used bytes of the pool
    type: long
    format: bytes
  </definition>
  <definition term="ceph.pool_disk.stats.used.kb">
    Used kb of the pool
    type: long
  </definition>
</definitions>