﻿---
title: Azure fields
description: azure module The resource specified application insights application state billing and usage details monitor 
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-azure
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Azure fields
azure module
<definitions>
  <definition term="azure.timegrain">
    The Azure metric timegrain
    type: keyword
  </definition>
</definitions>


## resource

The resource specified
<definitions>
  <definition term="azure.resource.type">
    The type of the resource
    type: keyword
  </definition>
  <definition term="azure.resource.name">
    The name of the resource
    type: keyword
  </definition>
  <definition term="azure.resource.group">
    The resource group
    type: keyword
  </definition>
  <definition term="azure.resource.tags.*">
    Azure resource tags.
    type: object
  </definition>
  <definition term="azure.namespace">
    The namespace selected
    type: keyword
  </definition>
  <definition term="azure.subscription_id">
    The subscription ID
    type: keyword
  </definition>
  <definition term="azure.subscription_name">
    The subscription name
    type: keyword
  </definition>
  <definition term="azure.application_id">
    The application ID
    type: keyword
  </definition>
  <definition term="azure.dimensions.*">
    Azure metric dimensions.
    type: object
  </definition>
  <definition term="azure.metrics.*.*">
    Metrics returned.
    type: object
  </definition>
</definitions>


## app_insights

<applies-to>
  - Elastic Stack: Beta
</applies-to>

application insights
<definitions>
  <definition term="azure.app_insights.start_date">
    The start date
    type: date
  </definition>
  <definition term="azure.app_insights.end_date">
    The end date
    type: date
  </definition>
  <definition term="azure.app_insights.metrics.*.*">
    The metrics
    type: object
  </definition>
</definitions>


## app_state

<applies-to>
  - Elastic Stack: Beta
</applies-to>

application state
<definitions>
  <definition term="azure.app_state.start_date">
    The start date
    type: date
  </definition>
  <definition term="azure.app_state.end_date">
    The end date
    type: date
  </definition>
  <definition term="azure.app_state.requests_count.sum">
    Request count
    type: float
  </definition>
  <definition term="azure.app_state.requests_failed.sum">
    Request failed count
    type: float
  </definition>
  <definition term="azure.app_state.users_count.unique">
    User count
    type: float
  </definition>
  <definition term="azure.app_state.sessions_count.unique">
    Session count
    type: float
  </definition>
  <definition term="azure.app_state.users_authenticated.unique">
    Authenticated users count
    type: float
  </definition>
  <definition term="azure.app_state.browser_timings_network_duration.avg">
    Browser timings network duration
    type: float
  </definition>
  <definition term="azure.app_state.browser_timings_send_duration.avg">
    Browser timings send duration
    type: float
  </definition>
  <definition term="azure.app_state.browser_timings_receive_uration.avg">
    Browser timings receive duration
    type: float
  </definition>
  <definition term="azure.app_state.browser_timings_processing_duration.avg">
    Browser timings processing duration
    type: float
  </definition>
  <definition term="azure.app_state.browser_timings_total_duration.avg">
    Browser timings total duration
    type: float
  </definition>
  <definition term="azure.app_state.exceptions_count.sum">
    Exception count
    type: float
  </definition>
  <definition term="azure.app_state.exceptions_browser.sum">
    Exception count at browser level
    type: float
  </definition>
  <definition term="azure.app_state.exceptions_server.sum">
    Exception count at server level
    type: float
  </definition>
  <definition term="azure.app_state.performance_counters_memory_available_bytes.avg">
    Performance counters memory available bytes
    type: float
  </definition>
  <definition term="azure.app_state.performance_counters_process_private_bytes.avg">
    Performance counters process private bytes
    type: float
  </definition>
  <definition term="azure.app_state.performance_counters_process_cpu_percentage_total.avg">
    Performance counters process cpu percentage total
    type: float
  </definition>
  <definition term="azure.app_state.performance_counters_process_cpu_percentage.avg">
    Performance counters process cpu percentage
    type: float
  </definition>
  <definition term="azure.app_state.performance_counters_processiobytes_per_second.avg">
    Performance counters process IO bytes per second
    type: float
  </definition>
</definitions>


## billing

<applies-to>
  - Elastic Stack: Beta
</applies-to>

billing and usage details
<definitions>
  <definition term="azure.billing.currency">
    Billing Currency.
    type: keyword
  </definition>
  <definition term="azure.billing.pretax_cost">
    The amount of cost before tax.
    type: float
  </definition>
  <definition term="azure.billing.unit_price">
    Unit Price is the price applicable to you. (your EA or other contract price).
    type: float
  </definition>
  <definition term="azure.billing.quantity">
    Measure the quantity purchased or consumed. The amount of the meter used during the billing period.
    type: float
  </definition>
  <definition term="azure.billing.department_name">
    The department name
    type: keyword
  </definition>
  <definition term="azure.billing.product">
    Product name for the consumed service or purchase.
    type: keyword
  </definition>
  <definition term="azure.billing.usage_start">
    The usage start date
    type: date
  </definition>
  <definition term="azure.billing.usage_end">
    The usage end date
    type: date
  </definition>
  <definition term="azure.billing.billing_period_id">
    The billing period id.
    type: keyword
  </definition>
  <definition term="azure.billing.account_name">
    Name of the Billing Account.
    type: keyword
  </definition>
  <definition term="azure.billing.account_id">
    Billing Account identifier.
    type: keyword
  </definition>
  <definition term="azure.billing.actual_cost">
    The actual cost
    type: float
  </definition>
  <definition term="azure.billing.forecast_cost">
    The forecast cost
    type: float
  </definition>
  <definition term="azure.billing.usage_date">
    The usage date
    type: date
  </definition>
  <definition term="azure.compute_vm.*.*">
    compute_vm
    type: object
  </definition>
  <definition term="azure.compute_vm_scaleset.*.*">
    compute_vm_scaleset
    type: object
  </definition>
  <definition term="azure.container_instance.*.*">
    container instance
    type: object
  </definition>
  <definition term="azure.container_registry.*.*">
    container registry
    type: object
  </definition>
  <definition term="azure.container_service.*.*">
    container service
    type: object
  </definition>
  <definition term="azure.database_account.*.*">
    database account
    type: object
  </definition>
</definitions>


## monitor

monitor
<definitions>
  <definition term="azure.storage.*.*">
    storage account
    type: object
  </definition>
  <definition term="azure.storage_account.*.*">
    storage account
    type: object
  </definition>
</definitions>