﻿---
title: AutoOps ES fields
description: AutoOps Elasticsearch module cat shards information from the cluster tasks information from the cluster cluster health metrics cluster_settings default...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-autoops_es
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# AutoOps ES fields
AutoOps Elasticsearch module

## autoops_es


## cat_shards

<applies-to>
  - Elastic Stack: Beta
</applies-to>

cat shards information from the cluster
<definitions>
  <definition term="autoops_es.cat_shards.ip">
    Shard id
    type: keyword
  </definition>
  <definition term="autoops_es.cat_shards.index">
    Shard index
    type: keyword
  </definition>
  <definition term="autoops_es.cat_shards.shard">
    Shard number
    type: keyword
  </definition>
  <definition term="autoops_es.cat_shards.prirep">
    Primary / Replica shard
    type: keyword
  </definition>
  <definition term="autoops_es.cat_shards.state">
    State of the shard
    type: keyword
  </definition>
  <definition term="autoops_es.cat_shards.docs">
    Docs count
    type: long
  </definition>
  <definition term="autoops_es.cat_shards.store">
    Shard size in bytes
    type: long
  </definition>
  <definition term="autoops_es.cat_shards.segments_count">
    Shard segments count
    type: long
  </definition>
  <definition term="autoops_es.cat_shards.search_query_total">
    Shard search count
    type: long
  </definition>
  <definition term="autoops_es.cat_shards.search_query_time">
    Shard search time in millis
    type: long
  </definition>
  <definition term="autoops_es.cat_shards.indexing_index_total">
    Shard indexing total
    type: long
  </definition>
  <definition term="autoops_es.cat_shards.indexing_index_time">
    Shard indexing time
    type: long
  </definition>
  <definition term="autoops_es.cat_shards.indexing_index_failed">
    Shard indexing failed
    type: long
  </definition>
  <definition term="autoops_es.cat_shards.merges_total">
    Shard merges total
    type: long
  </definition>
  <definition term="autoops_es.cat_shards.merges_total_size">
    Shard merges size in bytes
    type: long
  </definition>
  <definition term="autoops_es.cat_shards.merges_total_time">
    Shard merges time in millis
    type: long
  </definition>
</definitions>


## cat_template

<applies-to>
  - Elastic Stack: Beta
</applies-to>

tasks information from the cluster
<definitions>
  <definition term="autoops_es.cat_template.index">
    index name
    type: keyword
  </definition>
  <definition term="autoops_es.cat_template.managed">
    indicate whether this index is ilm managed
    type: boolean
  </definition>
  <definition term="autoops_es.cat_template.policy">
    policy name
    type: keyword
  </definition>
  <definition term="autoops_es.cat_template.lifecycle_date_millis">
    lifecycle date in epoch millis
    type: long
  </definition>
  <definition term="autoops_es.cat_template.lifecycle_date">
    lifecycle date
    type: date
  </definition>
  <definition term="autoops_es.cat_template.phase">
    phase stage
    type: keyword
  </definition>
  <definition term="autoops_es.cat_template.phase_time_millis">
    phase time in millis
    type: long
  </definition>
  <definition term="autoops_es.cat_template.phase_time">
    phase time
    type: date
  </definition>
  <definition term="autoops_es.cat_template.action">
    action name
    type: keyword
  </definition>
</definitions>


## cluster_health

<applies-to>
  - Elastic Stack: Beta
</applies-to>

cluster health metrics
<definitions>
  <definition term="autoops_es.cluster_health.cluster_name">
    The cluster name
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_health.status">
    The cluster status
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_health.timed_out">
    Whether the call for status was timed out
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_health.number_of_nodes">
    Number of nodes on cluster
    type: long
  </definition>
  <definition term="autoops_es.cluster_health.number_of_data_nodes">
    The number of data nodes
    type: long
  </definition>
  <definition term="autoops_es.cluster_health.active_primary_shards">
    The number of active primary shards
    type: long
  </definition>
  <definition term="autoops_es.cluster_health.active_shards">
    The number of active shards
    type: long
  </definition>
  <definition term="autoops_es.cluster_health.relocating_shards">
    The number of relocating shards
    type: long
  </definition>
  <definition term="autoops_es.cluster_health.initializing_shards">
    The number of initializing shards
    type: long
  </definition>
  <definition term="autoops_es.cluster_health.unassigned_shards">
    The number of unassigned shards
    type: long
  </definition>
  <definition term="autoops_es.cluster_health.delayed_unassigned_shards">
    The delayed unassigned shards
    type: long
  </definition>
  <definition term="autoops_es.cluster_health.number_of_pending_tasks">
    The number of pending tasks
    type: long
  </definition>
  <definition term="autoops_es.cluster_health.number_of_in_flight_fetch">
    The number of in flight_fetch
    type: long
  </definition>
  <definition term="autoops_es.cluster_health.task_max_waiting_in_queue_millis">
    The task max waiting in queue millis
    type: long
  </definition>
  <definition term="autoops_es.cluster_health.active_shards_percent_as_number">
    The active shards percent as number
    type: long
  </definition>
</definitions>


## cluster_settings

<applies-to>
  - Elastic Stack: Beta
</applies-to>

cluster_settings

## defaults

default settings

## discovery

discovery settings

## zen

zen discovery settings
<definitions>
  <definition term="autoops_es.cluster_settings.defaults.discovery.zen.minimum_master_nodes">
    minimum_master_nodes
    type: keyword
  </definition>
</definitions>


## cluster

cluster settings
<definitions>
  <definition term="autoops_es.cluster_settings.defaults.cluster.max_shards_per_node">
    max_shards_per_node
    type: keyword
  </definition>
</definitions>


## routing

routing settings

## allocation

allocation settings

## disk

disk settings

## watermark

watermark settings
<definitions>
  <definition term="autoops_es.cluster_settings.defaults.cluster.routing.allocation.disk.watermark.low">
    low watermark settings
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.defaults.cluster.routing.allocation.disk.watermark.high">
    high watermark settings
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.defaults.cluster.routing.allocation.disk.watermark.flood_stage">
    flood_stage watermark settings
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.defaults.cluster.routing.allocation.node_concurrent_outgoing_recoveries">
    node_concurrent_outgoing_recoveries
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.defaults.cluster.routing.allocation.cluster_concurrent_rebalance">
    cluster_concurrent_rebalance
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.defaults.cluster.routing.allocation.node_concurrent_recoveries">
    node_concurrent_recoveries
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.defaults.cluster.routing.allocation.total_shards_per_node">
    total_shards_per_node
    type: keyword
  </definition>
</definitions>


## blocks

blocks settings
<definitions>
  <definition term="autoops_es.cluster_settings.defaults.cluster.blocks.read_only">
    read_only settings
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.defaults.cluster.blocks.create_index">
    create_index settings
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.defaults.cluster.blocks.read_only_allow_delete">
    read_only_allow_delete settings
    type: keyword
  </definition>
</definitions>


## bootstrap

bootstrap settings
<definitions>
  <definition term="autoops_es.cluster_settings.defaults.bootstrap.memory_lock">
    memory_lock settings
    type: keyword
  </definition>
</definitions>


## search

search settings
<definitions>
  <definition term="autoops_es.cluster_settings.defaults.search.default_search_timeout">
    default_search_timeout
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.defaults.search.max_buckets">
    max_buckets
    type: keyword
  </definition>
</definitions>


## indices

indices settings

## recovery

recovery settings
<definitions>
  <definition term="autoops_es.cluster_settings.defaults.indices.recovery.max_bytes_per_sec">
    max_bytes_per_sec settings
    type: keyword
  </definition>
</definitions>


## breaker

breaker settings

## request

request breaker settings
<definitions>
  <definition term="autoops_es.cluster_settings.defaults.indices.breaker.request.limit">
    limit settings
    type: keyword
  </definition>
</definitions>


## total

total breaker settings
<definitions>
  <definition term="autoops_es.cluster_settings.defaults.indices.breaker.total.limit">
    limit settings
    type: keyword
  </definition>
</definitions>


## query

query settings

## query_string

query_string settings
<definitions>
  <definition term="autoops_es.cluster_settings.defaults.indices.query.query_string.allowLeadingWildcard">
    allowLeadingWildcard settings
    type: keyword
  </definition>
</definitions>


## action

action settings
<definitions>
  <definition term="autoops_es.cluster_settings.defaults.action.destructive_requires_name">
    destructive_requires_name settings
    type: keyword
  </definition>
</definitions>


## persistent

persistent settings

## discovery

discovery settings

## zen

zen discovery settings
<definitions>
  <definition term="autoops_es.cluster_settings.persistent.discovery.zen.minimum_master_nodes">
    minimum_master_nodes
    type: keyword
  </definition>
</definitions>


## cluster

cluster settings
<definitions>
  <definition term="autoops_es.cluster_settings.persistent.cluster.max_shards_per_node">
    max_shards_per_node
    type: keyword
  </definition>
</definitions>


## routing

routing settings

## allocation

allocation settings

## disk

disk settings

## watermark

watermark settings
<definitions>
  <definition term="autoops_es.cluster_settings.persistent.cluster.routing.allocation.disk.watermark.low">
    low watermark settings
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.persistent.cluster.routing.allocation.disk.watermark.high">
    high watermark settings
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.persistent.cluster.routing.allocation.disk.watermark.flood_stage">
    flood_stage watermark settings
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.persistent.cluster.routing.allocation.node_concurrent_outgoing_recoveries">
    node_concurrent_outgoing_recoveries
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.persistent.cluster.routing.allocation.cluster_concurrent_rebalance">
    cluster_concurrent_rebalance
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.persistent.cluster.routing.allocation.node_concurrent_recoveries">
    node_concurrent_recoveries
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.persistent.cluster.routing.allocation.total_shards_per_node">
    total_shards_per_node
    type: keyword
  </definition>
</definitions>


## blocks

blocks settings
<definitions>
  <definition term="autoops_es.cluster_settings.persistent.cluster.blocks.read_only">
    read_only settings
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.persistent.cluster.blocks.create_index">
    create_index settings
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.persistent.cluster.blocks.read_only_allow_delete">
    read_only_allow_delete settings
    type: keyword
  </definition>
</definitions>


## bootstrap

bootstrap settings
<definitions>
  <definition term="autoops_es.cluster_settings.persistent.bootstrap.memory_lock">
    memory_lock settings
    type: keyword
  </definition>
</definitions>


## search

search settings
<definitions>
  <definition term="autoops_es.cluster_settings.persistent.search.default_search_timeout">
    default_search_timeout
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.persistent.search.max_buckets">
    max_buckets
    type: keyword
  </definition>
</definitions>


## indices

indices settings

## recovery

recovery settings
<definitions>
  <definition term="autoops_es.cluster_settings.persistent.indices.recovery.max_bytes_per_sec">
    max_bytes_per_sec settings
    type: keyword
  </definition>
</definitions>


## breaker

breaker settings

## request

request breaker settings
<definitions>
  <definition term="autoops_es.cluster_settings.persistent.indices.breaker.request.limit">
    limit settings
    type: keyword
  </definition>
</definitions>


## total

total breaker settings
<definitions>
  <definition term="autoops_es.cluster_settings.persistent.indices.breaker.total.limit">
    limit settings
    type: keyword
  </definition>
</definitions>


## query

query settings

## query_string

query_string settings
<definitions>
  <definition term="autoops_es.cluster_settings.persistent.indices.query.query_string.allowLeadingWildcard">
    allowLeadingWildcard settings
    type: keyword
  </definition>
</definitions>


## action

action settings
<definitions>
  <definition term="autoops_es.cluster_settings.persistent.action.destructive_requires_name">
    destructive_requires_name settings
    type: keyword
  </definition>
</definitions>


## transient

transient settings

## discovery

discovery settings

## zen

zen discovery settings
<definitions>
  <definition term="autoops_es.cluster_settings.transient.discovery.zen.minimum_master_nodes">
    minimum_master_nodes
    type: keyword
  </definition>
</definitions>


## cluster

cluster settings
<definitions>
  <definition term="autoops_es.cluster_settings.transient.cluster.max_shards_per_node">
    max_shards_per_node
    type: keyword
  </definition>
</definitions>


## routing

routing settings

## allocation

allocation settings

## disk

disk settings

## watermark

watermark settings
<definitions>
  <definition term="autoops_es.cluster_settings.transient.cluster.routing.allocation.disk.watermark.low">
    low watermark settings
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.transient.cluster.routing.allocation.disk.watermark.high">
    high watermark settings
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.transient.cluster.routing.allocation.disk.watermark.flood_stage">
    flood_stage watermark settings
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.transient.cluster.routing.allocation.node_concurrent_outgoing_recoveries">
    node_concurrent_outgoing_recoveries
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.transient.cluster.routing.allocation.cluster_concurrent_rebalance">
    cluster_concurrent_rebalance
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.transient.cluster.routing.allocation.node_concurrent_recoveries">
    node_concurrent_recoveries
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.transient.cluster.routing.allocation.total_shards_per_node">
    total_shards_per_node
    type: keyword
  </definition>
</definitions>


## blocks

blocks settings
<definitions>
  <definition term="autoops_es.cluster_settings.transient.cluster.blocks.read_only">
    read_only settings
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.transient.cluster.blocks.create_index">
    create_index settings
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.transient.cluster.blocks.read_only_allow_delete">
    read_only_allow_delete settings
    type: keyword
  </definition>
</definitions>


## bootstrap

bootstrap settings
<definitions>
  <definition term="autoops_es.cluster_settings.transient.bootstrap.memory_lock">
    memory_lock settings
    type: keyword
  </definition>
</definitions>


## search

search settings
<definitions>
  <definition term="autoops_es.cluster_settings.transient.search.default_search_timeout">
    default_search_timeout
    type: keyword
  </definition>
  <definition term="autoops_es.cluster_settings.transient.search.max_buckets">
    max_buckets
    type: keyword
  </definition>
</definitions>


## indices

indices settings

## recovery

recovery settings
<definitions>
  <definition term="autoops_es.cluster_settings.transient.indices.recovery.max_bytes_per_sec">
    max_bytes_per_sec settings
    type: keyword
  </definition>
</definitions>


## breaker

breaker settings

## request

request breaker settings
<definitions>
  <definition term="autoops_es.cluster_settings.transient.indices.breaker.request.limit">
    limit settings
    type: keyword
  </definition>
</definitions>


## total

total breaker settings
<definitions>
  <definition term="autoops_es.cluster_settings.transient.indices.breaker.total.limit">
    limit settings
    type: keyword
  </definition>
</definitions>


## query

query settings

## query_string

query_string settings
<definitions>
  <definition term="autoops_es.cluster_settings.transient.indices.query.query_string.allowLeadingWildcard">
    allowLeadingWildcard settings
    type: keyword
  </definition>
</definitions>


## action

action settings
<definitions>
  <definition term="autoops_es.cluster_settings.transient.action.destructive_requires_name">
    destructive_requires_name settings
    type: keyword
  </definition>
</definitions>


## component_template

<applies-to>
  - Elastic Stack: Beta
</applies-to>

component template information from the cluster
<definitions>
  <definition term="autoops_es.component_template.index">
    index name
    type: keyword
  </definition>
  <definition term="autoops_es.component_template.managed">
    indicate whether this index is ilm managed
    type: boolean
  </definition>
  <definition term="autoops_es.component_template.policy">
    policy name
    type: keyword
  </definition>
  <definition term="autoops_es.component_template.lifecycle_date_millis">
    lifecycle date in epoch millis
    type: long
  </definition>
  <definition term="autoops_es.component_template.lifecycle_date">
    lifecycle date
    type: date
  </definition>
  <definition term="autoops_es.component_template.phase">
    phase stage
    type: keyword
  </definition>
  <definition term="autoops_es.component_template.phase_time_millis">
    phase time in millis
    type: long
  </definition>
  <definition term="autoops_es.component_template.phase_time">
    phase time
    type: date
  </definition>
  <definition term="autoops_es.component_template.action">
    action name
    type: keyword
  </definition>
</definitions>


## index_template

<applies-to>
  - Elastic Stack: Beta
</applies-to>

index templates from the cluster
<definitions>
  <definition term="autoops_es.index_template.index">
    index name
    type: keyword
  </definition>
  <definition term="autoops_es.index_template.managed">
    indicate whether this index is ilm managed
    type: boolean
  </definition>
  <definition term="autoops_es.index_template.policy">
    policy name
    type: keyword
  </definition>
  <definition term="autoops_es.index_template.lifecycle_date_millis">
    lifecycle date in epoch millis
    type: long
  </definition>
  <definition term="autoops_es.index_template.lifecycle_date">
    lifecycle date
    type: date
  </definition>
  <definition term="autoops_es.index_template.phase">
    phase stage
    type: keyword
  </definition>
  <definition term="autoops_es.index_template.phase_time_millis">
    phase time in millis
    type: long
  </definition>
  <definition term="autoops_es.index_template.phase_time">
    phase time
    type: date
  </definition>
  <definition term="autoops_es.index_template.action">
    action name
    type: keyword
  </definition>
</definitions>


## node.stats

node_stats

## indices

Node indices stats
<definitions>
  <definition term="autoops_es.node.stats.indices.docs.count">
    Total number of existing documents.
    type: long
  </definition>
  <definition term="autoops_es.node.stats.indices.docs.deleted">
    Total number of deleted documents.
    type: long
  </definition>
  <definition term="autoops_es.node.stats.indices.segments.count">
    Total number of segments.
    type: long
  </definition>
  <definition term="autoops_es.node.stats.indices.segments.memory.bytes">
    Total size of segments in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="autoops_es.node.stats.indices.store.size.bytes">
    Total size of the store in bytes.
    type: long
  </definition>
</definitions>


## jvm.mem.pools

JVM memory pool stats

## old

Old memory pool stats.
<definitions>
  <definition term="autoops_es.node.stats.jvm.mem.pools.old.max.bytes">
    Max bytes.
    type: long
    format: bytes
  </definition>
  <definition term="autoops_es.node.stats.jvm.mem.pools.old.peak.bytes">
    Peak bytes.
    type: long
    format: bytes
  </definition>
  <definition term="autoops_es.node.stats.jvm.mem.pools.old.peak_max.bytes">
    Peak max bytes.
    type: long
    format: bytes
  </definition>
  <definition term="autoops_es.node.stats.jvm.mem.pools.old.used.bytes">
    Used bytes.
    type: long
    format: bytes
  </definition>
</definitions>


## young

Young memory pool stats.
<definitions>
  <definition term="autoops_es.node.stats.jvm.mem.pools.young.max.bytes">
    Max bytes.
    type: long
    format: bytes
  </definition>
  <definition term="autoops_es.node.stats.jvm.mem.pools.young.peak.bytes">
    Peak bytes.
    type: long
    format: bytes
  </definition>
  <definition term="autoops_es.node.stats.jvm.mem.pools.young.peak_max.bytes">
    Peak max bytes.
    type: long
    format: bytes
  </definition>
  <definition term="autoops_es.node.stats.jvm.mem.pools.young.used.bytes">
    Used bytes.
    type: long
    format: bytes
  </definition>
</definitions>


## survivor

Survivor memory pool stats.
<definitions>
  <definition term="autoops_es.node.stats.jvm.mem.pools.survivor.max.bytes">
    Max bytes.
    type: long
    format: bytes
  </definition>
  <definition term="autoops_es.node.stats.jvm.mem.pools.survivor.peak.bytes">
    Peak bytes.
    type: long
    format: bytes
  </definition>
  <definition term="autoops_es.node.stats.jvm.mem.pools.survivor.peak_max.bytes">
    Peak max bytes.
    type: long
    format: bytes
  </definition>
  <definition term="autoops_es.node.stats.jvm.mem.pools.survivor.used.bytes">
    Used bytes.
    type: long
    format: bytes
  </definition>
</definitions>


## jvm.gc.collectors

GC collector stats.

## old.collection

Old collection gc.
<definitions>
  <definition term="autoops_es.node.stats.jvm.gc.collectors.old.collection.count">
    type: long
  </definition>
  <definition term="autoops_es.node.stats.jvm.gc.collectors.old.collection.ms">
    type: long
  </definition>
</definitions>


## young.collection

Young collection gc.
<definitions>
  <definition term="autoops_es.node.stats.jvm.gc.collectors.young.collection.count">
    type: long
  </definition>
  <definition term="autoops_es.node.stats.jvm.gc.collectors.young.collection.ms">
    type: long
  </definition>
</definitions>


## fs.summary

File system summary
<definitions>
  <definition term="autoops_es.node.stats.fs.summary.total.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="autoops_es.node.stats.fs.summary.free.bytes">
    type: long
    format: bytes
  </definition>
  <definition term="autoops_es.node.stats.fs.summary.available.bytes">
    type: long
    format: bytes
  </definition>
</definitions>


## tasks_management

<applies-to>
  - Elastic Stack: Beta
</applies-to>

tasks information from cluster
<definitions>
  <definition term="autoops_es.tasks_management.taskId">
    task full id
    type: keyword
  </definition>
  <definition term="autoops_es.tasks_management.id">
    task internal node id
    type: integer
  </definition>
  <definition term="autoops_es.tasks_management.node">
    node id
    type: keyword
  </definition>
  <definition term="autoops_es.tasks_management.taskType">
    task type
    type: keyword
  </definition>
  <definition term="autoops_es.tasks_management.action">
    task action
    type: keyword
  </definition>
  <definition term="autoops_es.tasks_management.startTimeInMillis">
    task start time in millis
    type: long
  </definition>
  <definition term="autoops_es.tasks_management.runningTimeInNanos">
    task running time in nanos
    type: long
  </definition>
  <definition term="autoops_es.tasks_management.parentTaskId">
    task parent id
    type: keyword
  </definition>
</definitions>