﻿---
title: Apache fields
description: Apache HTTPD server metricsets collected from the Apache web server. apache contains the metrics that were scraped from Apache. status contains the metrics...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-apache
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Apache fields
Apache HTTPD server metricsets collected from the Apache web server.

## apache

`apache` contains the metrics that were scraped from Apache.

## status

`status` contains the metrics that were scraped from the Apache status page.
<definitions>
  <definition term="apache.status.hostname">
    Apache hostname.
    type: keyword
  </definition>
  <definition term="apache.status.total_accesses">
    Total number of access requests.
    type: long
  </definition>
  <definition term="apache.status.total_kbytes">
    Total number of kilobytes served.
    type: long
  </definition>
  <definition term="apache.status.requests_per_sec">
    Requests per second.
    type: scaled_float
  </definition>
  <definition term="apache.status.bytes_per_sec">
    Bytes per second.
    type: scaled_float
  </definition>
  <definition term="apache.status.bytes_per_request">
    Bytes per request.
    type: scaled_float
  </definition>
  <definition term="apache.status.workers.busy">
    Number of busy workers.
    type: long
  </definition>
  <definition term="apache.status.workers.idle">
    Number of idle workers.
    type: long
  </definition>
</definitions>


## uptime

Uptime stats.
<definitions>
  <definition term="apache.status.uptime.server_uptime">
    Server uptime in seconds.
    type: long
  </definition>
  <definition term="apache.status.uptime.uptime">
    Server uptime.
    type: long
  </definition>
</definitions>


## cpu

CPU stats.
<definitions>
  <definition term="apache.status.cpu.load">
    CPU Load.
    type: scaled_float
  </definition>
  <definition term="apache.status.cpu.user">
    CPU user load.
    type: scaled_float
  </definition>
  <definition term="apache.status.cpu.system">
    System cpu.
    type: scaled_float
  </definition>
  <definition term="apache.status.cpu.children_user">
    CPU of children user.
    type: scaled_float
  </definition>
  <definition term="apache.status.cpu.children_system">
    CPU of children system.
    type: scaled_float
  </definition>
</definitions>


## connections

Connection stats.
<definitions>
  <definition term="apache.status.connections.total">
    Total connections.
    type: long
  </definition>
  <definition term="apache.status.connections.async.writing">
    Async connection writing.
    type: long
  </definition>
  <definition term="apache.status.connections.async.keep_alive">
    Async keeped alive connections.
    type: long
  </definition>
  <definition term="apache.status.connections.async.closing">
    Async closed connections.
    type: long
  </definition>
</definitions>


## load

Load averages.
<definitions>
  <definition term="apache.status.load.1">
    Load average for the last minute.
    type: scaled_float
  </definition>
  <definition term="apache.status.load.5">
    Load average for the last 5 minutes.
    type: scaled_float
  </definition>
  <definition term="apache.status.load.15">
    Load average for the last 15 minutes.
    type: scaled_float
  </definition>
</definitions>


## scoreboard

Scoreboard metrics.
<definitions>
  <definition term="apache.status.scoreboard.starting_up">
    Starting up.
    type: long
  </definition>
  <definition term="apache.status.scoreboard.reading_request">
    Reading requests.
    type: long
  </definition>
  <definition term="apache.status.scoreboard.sending_reply">
    Sending Reply.
    type: long
  </definition>
  <definition term="apache.status.scoreboard.keepalive">
    Keep alive.
    type: long
  </definition>
  <definition term="apache.status.scoreboard.dns_lookup">
    Dns Lookups.
    type: long
  </definition>
  <definition term="apache.status.scoreboard.closing_connection">
    Closing connections.
    type: long
  </definition>
  <definition term="apache.status.scoreboard.logging">
    Logging
    type: long
  </definition>
  <definition term="apache.status.scoreboard.gracefully_finishing">
    Gracefully finishing.
    type: long
  </definition>
  <definition term="apache.status.scoreboard.idle_cleanup">
    Idle cleanups.
    type: long
  </definition>
  <definition term="apache.status.scoreboard.open_slot">
    Open slots.
    type: long
  </definition>
  <definition term="apache.status.scoreboard.waiting_for_connection">
    Waiting for connections.
    type: long
  </definition>
  <definition term="apache.status.scoreboard.total">
    Total.
    type: long
  </definition>
</definitions>