﻿---
title: Aerospike fields
description: Aerospike module namespace Client stats. Client delete transactions stats. Client read transactions stats. Client write transactions stats. Disk storage...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-aerospike
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Aerospike fields
Aerospike module

## aerospike


## namespace

namespace

## client

Client stats.

## delete

Client delete transactions stats.
<definitions>
  <definition term="aerospike.namespace.client.delete.error">
    Number of client delete transactions that failed with an error.
    type: long
  </definition>
  <definition term="aerospike.namespace.client.delete.not_found">
    Number of client delete transactions that resulted in a not found.
    type: long
  </definition>
  <definition term="aerospike.namespace.client.delete.success">
    Number of successful client delete transactions.
    type: long
  </definition>
  <definition term="aerospike.namespace.client.delete.timeout">
    Number of client delete transactions that timed out.
    type: long
  </definition>
</definitions>


## read

Client read transactions stats.
<definitions>
  <definition term="aerospike.namespace.client.read.error">
    Number of client read transaction errors.
    type: long
  </definition>
  <definition term="aerospike.namespace.client.read.not_found">
    Number of client read transaction that resulted in not found.
    type: long
  </definition>
  <definition term="aerospike.namespace.client.read.success">
    Number of successful client read transactions.
    type: long
  </definition>
  <definition term="aerospike.namespace.client.read.timeout">
    Number of client read transaction that timed out.
    type: long
  </definition>
</definitions>


## write

Client write transactions stats.
<definitions>
  <definition term="aerospike.namespace.client.write.error">
    Number of client write transactions that failed with an error.
    type: long
  </definition>
  <definition term="aerospike.namespace.client.write.success">
    Number of successful client write transactions.
    type: long
  </definition>
  <definition term="aerospike.namespace.client.write.timeout">
    Number of client write transactions that timed out.
    type: long
  </definition>
</definitions>


## device

Disk storage stats
<definitions>
  <definition term="aerospike.namespace.device.available.pct">
    Measures the minimum contiguous disk space across all disks in a namespace.
    type: scaled_float
    format: percent
  </definition>
  <definition term="aerospike.namespace.device.free.pct">
    Percentage of disk capacity free for this namespace.
    type: scaled_float
    format: percent
  </definition>
  <definition term="aerospike.namespace.device.total.bytes">
    Total bytes of disk space allocated to this namespace on this node.
    type: long
    format: bytes
  </definition>
  <definition term="aerospike.namespace.device.used.bytes">
    Total bytes of disk space used by this namespace on this node.
    type: long
    format: bytes
  </definition>
  <definition term="aerospike.namespace.hwm_breached">
    If true, Aerospike has breached 'high-water-[diskmemory]-pct' for this namespace.
    type: boolean
  </definition>
</definitions>


## memory

Memory storage stats.
<definitions>
  <definition term="aerospike.namespace.memory.free.pct">
    Percentage of memory capacity free for this namespace on this node.
    type: scaled_float
    format: percent
  </definition>
  <definition term="aerospike.namespace.memory.used.data.bytes">
    Amount of memory occupied by data for this namespace on this node.
    type: long
    format: bytes
  </definition>
  <definition term="aerospike.namespace.memory.used.index.bytes">
    Amount of memory occupied by the index for this namespace on this node.
    type: long
    format: bytes
  </definition>
  <definition term="aerospike.namespace.memory.used.sindex.bytes">
    Amount of memory occupied by secondary indexes for this namespace on this node.
    type: long
    format: bytes
  </definition>
  <definition term="aerospike.namespace.memory.used.total.bytes">
    Total bytes of memory used by this namespace on this node.
    type: long
    format: bytes
  </definition>
  <definition term="aerospike.namespace.name">
    Namespace name
    type: keyword
  </definition>
  <definition term="aerospike.namespace.node.host">
    Node host
    type: keyword
  </definition>
  <definition term="aerospike.namespace.node.name">
    Node name
    type: keyword
  </definition>
</definitions>


## objects

Records stats.
<definitions>
  <definition term="aerospike.namespace.objects.master">
    Number of records on this node which are active masters.
    type: long
  </definition>
  <definition term="aerospike.namespace.objects.total">
    Number of records in this namespace for this node.
    type: long
  </definition>
  <definition term="aerospike.namespace.stop_writes">
    If true this namespace is currently not allowing writes.
    type: boolean
  </definition>
</definitions>