﻿---
title: ActiveMQ fields
description: activemq module Broker metrics from org.apache.activemq:brokerName=*,type=Broker Queue metrics from org.apache.activemq:brokerName=,destinationName=,destinationType=Queue,type=Broker...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-activemq
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# ActiveMQ fields
activemq module

## activemq


## broker

Broker metrics from org.apache.activemq:brokerName=*,type=Broker
<definitions>
  <definition term="activemq.broker.mbean">
    Mbean that this event is related to
    type: keyword
  </definition>
  <definition term="activemq.broker.name">
    Broker name
    type: keyword
  </definition>
  <definition term="activemq.broker.memory.broker.pct">
    The percentage of the memory limit used.
    type: scaled_float
    format: percent
  </definition>
  <definition term="activemq.broker.memory.store.pct">
    Percent of store limit used.
    type: scaled_float
    format: percent
  </definition>
  <definition term="activemq.broker.memory.temp.pct">
    The percentage of the temp usage limit used.
    type: scaled_float
    format: percent
  </definition>
  <definition term="activemq.broker.connections.count">
    Total number of connections.
    type: long
  </definition>
  <definition term="activemq.broker.consumers.count">
    Number of message consumers.
    type: long
  </definition>
  <definition term="activemq.broker.messages.dequeue.count">
    Number of messages that have been acknowledged on the broker.
    type: long
  </definition>
  <definition term="activemq.broker.messages.enqueue.count">
    Number of messages that have been sent to the destination.
    type: long
  </definition>
  <definition term="activemq.broker.messages.count">
    Number of unacknowledged messages on the broker.
    type: long
  </definition>
  <definition term="activemq.broker.producers.count">
    Number of message producers active on destinations on the broker.
    type: long
  </definition>
</definitions>


## queue

Queue metrics from org.apache.activemq:brokerName=*,destinationName=*,destinationType=Queue,type=Broker
<definitions>
  <definition term="activemq.queue.mbean">
    Mbean that this event is related to
    type: keyword
  </definition>
  <definition term="activemq.queue.name">
    Queue name
    type: keyword
  </definition>
  <definition term="activemq.queue.size">
    Queue size
    type: long
  </definition>
  <definition term="activemq.queue.messages.enqueue.time.avg">
    Average time a message was held on this destination.
    type: double
  </definition>
  <definition term="activemq.queue.messages.size.avg">
    Average message size on this destination.
    type: long
  </definition>
  <definition term="activemq.queue.consumers.count">
    Number of consumers subscribed to this destination.
    type: long
  </definition>
  <definition term="activemq.queue.messages.dequeue.count">
    Number of messages that has been acknowledged (and removed) from the destination.
    type: long
  </definition>
  <definition term="activemq.queue.messages.dispatch.count">
    Number of messages that has been delivered to consumers, including those not acknowledged.
    type: long
  </definition>
  <definition term="activemq.queue.messages.enqueue.count">
    Number of messages that have been sent to the destination.
    type: long
  </definition>
  <definition term="activemq.queue.messages.expired.count">
    Number of messages that have been expired.
    type: long
  </definition>
  <definition term="activemq.queue.messages.inflight.count">
    Number of messages that have been dispatched to, but not acknowledged by, consumers.
    type: long
  </definition>
  <definition term="activemq.queue.messages.enqueue.time.max">
    The longest time a message was held on this destination.
    type: long
  </definition>
  <definition term="activemq.queue.memory.broker.pct">
    Percent of memory limit used.
    type: scaled_float
    format: percent
  </definition>
  <definition term="activemq.queue.messages.enqueue.time.min">
    The shortest time a message was held on this destination.
    type: long
  </definition>
  <definition term="activemq.queue.producers.count">
    Number of producers attached to this destination.
    type: long
  </definition>
</definitions>


## topic

Topic metrics from org.apache.activemq:brokerName=*,destinationName=*,destinationType=Topic,type=Broker
<definitions>
  <definition term="activemq.topic.mbean">
    Mbean that this event is related to
    type: keyword
  </definition>
  <definition term="activemq.topic.name">
    Topic name
    type: keyword
  </definition>
  <definition term="activemq.topic.messages.enqueue.time.avg">
    Average time a message was held on this destination.
    type: double
  </definition>
  <definition term="activemq.topic.messages.size.avg">
    Average message size on this destination.
    type: long
  </definition>
  <definition term="activemq.topic.consumers.count">
    Number of consumers subscribed to this destination.
    type: long
  </definition>
  <definition term="activemq.topic.messages.dequeue.count">
    Number of messages that has been acknowledged (and removed) from the destination.
    type: long
  </definition>
  <definition term="activemq.topic.messages.dispatch.count">
    Number of messages that has been delivered to consumers, including those not acknowledged.
    type: long
  </definition>
  <definition term="activemq.topic.messages.enqueue.count">
    Number of messages that have been sent to the destination.
    type: long
  </definition>
  <definition term="activemq.topic.messages.expired.count">
    Number of messages that have been expired.
    type: long
  </definition>
  <definition term="activemq.topic.messages.inflight.count">
    Number of messages that have been dispatched to, but not acknowledged by, consumers.
    type: long
  </definition>
  <definition term="activemq.topic.messages.enqueue.time.max">
    The longest time a message was held on this destination.
    type: long
  </definition>
  <definition term="activemq.topic.memory.broker.pct">
    Percent of memory limit used.
    type: scaled_float
    format: percent
  </definition>
  <definition term="activemq.topic.messages.enqueue.time.min">
    The shortest time a message was held on this destination.
    type: long
  </definition>
  <definition term="activemq.topic.producers.count">
    Number of producers attached to this destination.
    type: long
  </definition>
</definitions>