﻿---
title: Error event structure
description: Metricbeat sends an error event when the service is not reachable. The error event has the same structure as the base event, but also has an error field...
url: https://www.elastic.co/docs/reference/beats/metricbeat/error-event-structure
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Error event structure
Metricbeat sends an error event when the service is not reachable. The error event has the same structure as the [base event](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-event-structure), but also has an error field that contains an error string. This makes it possible to check for errors across all metric events.
The following example shows an error event sent when the Apache server is not reachable:
```json
{
  "@timestamp": "2016-03-18T12:18:57.124Z",
  "apache-status": {},
  "beat": {
    "hostname": "host.example.com",
    "name": "host.example.com"
  },
  "error": {
    "message": "Get http://127.0.0.1/server-status?auto: dial tcp 127.0.0.1:80: getsockopt: connection refused",
  },
  "metricset": {
    "module": "apache",
    "name": "status",
    "rtt": 1082
  },
  .
  .
  .

  "type": "metricsets"
```