﻿---
title: Configure Metricbeat
description: To configure Metricbeat, edit the configuration file. The default configuration file is called  metricbeat.yml. The location of the file varies by platform...
url: https://www.elastic.co/docs/reference/beats/metricbeat/configuring-howto-metricbeat
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Configure Metricbeat
<tip>
  To get started quickly, read [Quick start: installation and configuration](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-installation-configuration).
</tip>

To configure Metricbeat, edit the configuration file. The default configuration file is called  `metricbeat.yml`. The location of the file varies by platform. To locate the file, see [Directory layout](https://www.elastic.co/docs/reference/beats/metricbeat/directory-layout).
There’s also a full example configuration file called `metricbeat.reference.yml` that shows all non-deprecated options.
<tip>
  See the [Config File Format](https://www.elastic.co/docs/reference/beats/libbeat/config-file-format) for more about the structure of the config file.
</tip>

The following topics describe how to configure Metricbeat:
- [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat)
- [General settings](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-general-options)
- [Project paths](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-path)
- [Config file loading](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-configuration-reloading)
- [Output](https://www.elastic.co/docs/reference/beats/metricbeat/configuring-output)
- [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl)
- [Index lifecycle management (ILM)](https://www.elastic.co/docs/reference/beats/metricbeat/ilm)
- [Elasticsearch index template](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-template)
- [Kibana endpoint](https://www.elastic.co/docs/reference/beats/metricbeat/setup-kibana-endpoint)
- [Kibana dashboards](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-dashboards)
- [Processors](https://www.elastic.co/docs/reference/beats/metricbeat/filtering-enhancing-data)
- [*Autodiscover*](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-autodiscover)
- [Internal queue](https://www.elastic.co/docs/reference/beats/metricbeat/configuring-internal-queue)
- [Logging](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-logging)
- [HTTP endpoint](https://www.elastic.co/docs/reference/beats/metricbeat/http-endpoint)
- [*Regular expression support*](https://www.elastic.co/docs/reference/beats/metricbeat/regexp-support)
- [Instrumentation](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-instrumentation)
- [Feature flags](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-feature-flags)
- [*metricbeat.reference.yml*](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-reference-yml)