﻿---
title: Add tags
description: The add_tags processor adds tags to a list of tags. If the target field already exists, the tags are appended to the existing list of tags. For example,...
url: https://www.elastic.co/docs/reference/beats/metricbeat/add-tags
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Add tags
The `add_tags` processor adds tags to a list of tags. If the target field already exists, the tags are appended to the existing list of tags.
<definitions>
  <definition term="tags">
    List of tags to add.
  </definition>
  <definition term="target">
    (Optional) Field the tags will be added to. Defaults to `tags`. Setting tags in `@metadata` is not supported.
  </definition>
</definitions>

For example, this configuration:
```yaml
processors:
  - add_tags:
      tags: [web, production]
      target: "environment"
```

Adds the environment field to every event:
```json
{
  "environment": ["web", "production"]
}
```