﻿---
title: Elastic Logging Plugin usage examples
description: The following examples show common configurations for the Elastic Logging Plugin. Docker run command: Daemon configuration: Docker run command: Daemon...
url: https://www.elastic.co/docs/reference/beats/loggingplugin/log-driver-usage-examples
products:
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Elastic Logging Plugin usage examples
The following examples show common configurations for the Elastic Logging Plugin.

## Send Docker logs to Elasticsearch

**Docker run command:**
```sh
docker run --log-driver=elastic/elastic-logging-plugin:9.3.0 \
           --log-opt hosts="myhost:9200" \
           --log-opt user="myusername" \
           --log-opt password="mypassword" \
           -it debian:jessie /bin/bash
```

**Daemon configuration:**
```json
{
  "log-driver" : "elastic/elastic-logging-plugin:9.3.0",
  "log-opts" : {
    "hosts" : "myhost:9200",
    "user" : "myusername",
    "password" : "mypassword",
  }
}
```


## Send Docker logs to Elastic Cloud Hosted

**Docker run command:**
```sh
docker run --log-driver=elastic/elastic-logging-plugin:9.3.0 \
           --log-opt cloud_id="MyElasticStack:daMbY2VudHJhbDekZ2NwLmN4b3VkLmVzLmliJDVkYmQwtGJiYjs0NTRiN4Q5ODJmNGUwm1IxZmFkNjM5JDFiNjdkMDE4MTgxMTQzNTM5ZGFiYWJjZmY0OWIyYWE5" \
           --log-opt cloud_auth="myusername:mypassword" \
           -it debian:jessie /bin/bash
```

**Daemon configuration:**
```json
{
  "log-driver" : "elastic/elastic-logging-plugin:9.3.0",
  "log-opts" : {
    "cloud_id" : "MyElasticStack:daMbY2VudHJhbDekZ2NwLmN4b3VkLmVzLmliJDVkYmQwtGJiYjs0NTRiN4Q5ODJmNGUwm1IxZmFkNjM5JDFiNjdkMDE4MTgxMTQzNTM5ZGFiYWJjZmY0OWIyYWE5",
    "cloud_auth" : "myusername:mypassword",
    "output.elasticsearch.index" : "elastic-log-driver-%{+yyyy.MM.dd}"
  }
}
```


## Specify a custom index and template

**Docker run command:**
```sh
docker run --log-driver=elastic/elastic-logging-plugin:9.3.0 \
           --log-opt hosts="myhost:9200" \
           --log-opt user="myusername" \
           --log-opt password="mypassword" \
           --log-opt index="eld-%{[agent.version]}-%{+yyyy.MM.dd}" \
           -it debian:jessie /bin/bash
```

**Daemon configuration:**
```json
{
  "log-driver" : "elastic/elastic-logging-plugin:9.3.0",
  "log-opts" : {
    "hosts" : "myhost:9200",
    "user" : "myusername",
    "index" : "eld-%{[agent.version]}-%{+yyyy.MM.dd}",
    "password" : "mypassword",
  }
}
```