﻿---
title: Elastic Logging Plugin configuration options
description: Use the following options to configure the Elastic Logging Plugin for Docker. You can pass these options with the --log-opt flag when you start a container,...
url: https://www.elastic.co/docs/reference/beats/loggingplugin/log-driver-configuration
products:
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Elastic Logging Plugin configuration options
Use the following options to configure the Elastic Logging Plugin for Docker. You can pass these options with the `--log-opt` flag when you start a container, or you can set them in the `daemon.json` file for all containers.
- [Elastic Cloud options](#cloud-options)
- [Elasticsearch output options](#es-output-options)


## Usage examples

To set configuration options when you start a container:
```sh
docker run --log-driver=elastic/elastic-logging-plugin:9.3.0 \
           --log-opt hosts="https://myhost:9200" \
           --log-opt user="myusername" \
           --log-opt password="mypassword" \
           -it debian:jessie /bin/bash
```

To set configuration options for all containers in the `daemon.json` file:
```json
{
  "log-driver" : "elastic/elastic-logging-plugin:9.3.0",
  "log-opts" : {
    "hosts" : "https://myhost:9200",
    "user" : "myusername",
    "password" : "mypassword"
  }
}
```

For more examples, see [Usage examples](https://www.elastic.co/docs/reference/beats/loggingplugin/log-driver-usage-examples).

## Elastic Cloud options


| Option       | Description                                                                                                                                    |
|--------------|------------------------------------------------------------------------------------------------------------------------------------------------|
| `cloud_id`   | The Cloud ID found in the Elastic Cloud web console. This ID isused to resolve the Elastic Stack URLs when connecting to Elastic Cloud Hosted. |
| `cloud_auth` | The username and password combination for connecting to Elastic Cloud Hosted. Theformat is `"username:password"`.                              |


## Elasticsearch output options


| Option         | Default            | Description                                                                                                                                                                                                                                                                                                                                                                                                               |
|----------------|--------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `hosts`        | `"localhost:9200"` | The list of Elasticsearch nodes to connect to. Specify each node as a `URL` or`IP:PORT`. For example: `http://192.0.2.0`, `https://myhost:9230` or`192.0.2.0:9300`. If no port is specified, the default is `9200`.                                                                                                                                                                                                       |
| `user`         |                    | The basic authentication username for connecting to Elasticsearch.                                                                                                                                                                                                                                                                                                                                                        |
| `password`     |                    | The basic authentication password for connecting to Elasticsearch.                                                                                                                                                                                                                                                                                                                                                        |
| `index`        |                    | A [format string](/docs/reference/beats/libbeat/config-file-format-type#_format_string_sprintf)value that specifies the index to write events to when you’re using dailyindices. For example: `"dockerlogs-%{+yyyy.MM.dd}"`.                                                                                                                                                                                              |
| **Advanced:**  |                    |                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `name`         | `testbeat`         | A custom value that will be inserted into the document as `agent.name`.If not set, it will be the hostname of Docker host.                                                                                                                                                                                                                                                                                                |
| `backoff_init` | `1s`               | The number of seconds to wait before trying to reconnect to Elasticsearch aftera network error. After waiting `backoff.init` seconds, the Elastic Logging Plugintries to reconnect. If the attempt fails, the backoff timer is increasedexponentially up to `backoff.max`. After a successful connection, the backofftimer is reset.                                                                                      |
| `backoff_max`  | `60s`              | The maximum number of seconds to wait before attempting to connect toElasticsearch after a network error.                                                                                                                                                                                                                                                                                                                 |
| `api_key`      |                    | Instead of using usernames and passwords,you can use API keys to secure communication with Elasticsearch.                                                                                                                                                                                                                                                                                                                 |
| `pipeline`     |                    | A format string value that specifies the Elasticsearch ingest pipeline to write events to.                                                                                                                                                                                                                                                                                                                                |
| `timeout`      | `90`               | The http request timeout in seconds for the Elasticsearch request.                                                                                                                                                                                                                                                                                                                                                        |
| `proxy_url`    |                    | The URL of the proxy to use when connecting to the Elasticsearch servers. Thevalue may be either a complete URL or a `host[:port]`, in which case the `http`scheme is assumed. If a value is not specified through the configuration filethen proxy environment variables are used. See the[Go documentation](https://golang.org/pkg/net/http/#ProxyFromEnvironment)for more information about the environment variables. |


## Configuring the local log

This plugin fully supports `docker logs`, and it maintains a local copy of logs that can be read without a connection to Elasticsearch. The plugin mounts the `/var/lib/docker` directory on the host to write logs to `/var/log/containers` on the host. If you want to change the log location on the host, you must change the mount inside the plugin:
1. Disable the plugin:
   ```sh
   docker plugin disable elastic/elastic-logging-plugin:9.3.0
   ```
2. Set the bindmount directory:
   ```sh
   docker plugin set elastic/elastic-logging-plugin:9.3.0 LOG_DIR.source=NEW_LOG_LOCATION
   ```
3. Enable the plugin:
   ```sh
   docker plugin enable elastic/elastic-logging-plugin:9.3.0
   ```

The local log also supports the `max-file`, `max-size` and `compress` options that are [a part of the Docker default file logger](https://docs.docker.com/config/containers/logging/json-file/#options). For example:
```sh
docker run --log-driver=elastic/elastic-logging-plugin:9.3.0 \
           --log-opt hosts="myhost:9200" \
           --log-opt user="myusername" \
           --log-opt password="mypassword" \
           --log-opt max-file=10 \
           --log-opt max-size=5M \
           --log-opt compress=true \
           -it debian:jessie /bin/bash
```

In situations where logs can’t be easily managed, for example, you can also configure the plugin to remove log files when a container is stopped. This will prevent you from reading logs on a stopped container, but it will rotate logs without user intervention. To enable removal of logs for stopped containers, you must change the `DESTROY_LOGS_ON_STOP` environment variable:
1. Disable the plugin:
   ```sh
   docker plugin disable elastic/elastic-logging-plugin:9.3.0
   ```
2. Enable log removal:
   ```sh
   docker plugin set elastic/elastic-logging-plugin:9.3.0 DESTROY_LOGS_ON_STOP=true
   ```
3. Enable the plugin:
   ```sh
   docker plugin enable elastic/elastic-logging-plugin:9.3.0
   ```