﻿---
title: Upgrade
description: This section gives general recommendations for upgrading Beats shippers: Upgrade between minor versions, Upgrade from 8.x to 9.x, Troubleshoot Beats upgrade...
url: https://www.elastic.co/docs/reference/beats/libbeat/upgrading
products:
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Upgrade
This section gives general recommendations for upgrading Beats shippers:
- [Upgrade between minor versions](#upgrade-minor-versions)
- [Upgrade from 8.x to 9.x](#upgrade-8-to-9)
- [Troubleshoot Beats upgrade issues](#troubleshooting-upgrade)


## Upgrade between minor versions

As a general rule, you can upgrade between minor versions (for example, 9.x to 9.y, where x < y) by simply installing the new release and restarting the Beat process. Beats typically maintain backwards compatibility for configuration settings and exported fields. Please review the review the [release notes](https://www.elastic.co/docs/release-notes) for potential exceptions.
Upgrading between non-consecutive major versions (e.g. 7.x to 9.x) is not supported.

## Upgrade from 8.x to 9.x

Before upgrading your Beats, review the [release notes](https://www.elastic.co/docs/release-notes) and be aware of any documented breaking changes.
If you’re upgrading other products in the stack, also read the Elastic Stack [upgrade steps](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster).
We recommend that you fully upgrade Elasticsearch and Kibana to version 9.0 before upgrading Beats. The Beats version must be lower than or equal to the Elasticsearch version. Beats cannot send data to older versions of Elasticsearch.
If you use the Uptime app in Kibana, make sure you add `heartbeat-9*` and `synthetics-*` to **Uptime indices** on the [Settings page](https://www.elastic.co/docs/solutions/observability/uptime/configure-settings). The first index is used by newer versions of a Beat, while the latter is used by Fleet.
<important>
  Please read through all upgrade steps before proceeding. These steps are required before running the software for the first time.
</important>


### Upgrade Beats binaries to 9.0

Before upgrading:
1. Stop the existing Beats process by using the appropriate command for your system.
2. Back up the `data` and `config` directories by copying them to another location.
   <tip>
   The location of these directories depends on the installation method. To see the current paths, start the Beat from a terminal, and the `data` and `config` paths are printed at startup.
   </tip>

To upgrade using a Debian or RPM package:
- Use `rpm` or `dpkg` to install the new package. All files are installed in the appropriate location for the operating system and Beats config files are not overwritten.

To upgrade using a zip or compressed tarball:
1. Extract the zip or tarball to a *new* directory. This is critical if you are not using external `config` and `data` directories.
2. Set the following options in the Beats configuration file:
   - Set `path.config` to point to your external `config` directory. If you are not using an external `config` directory, copy your old configuration over to the new installation.
- Set `path.data` to point to your external data directory. If you are not using an external `data` directory, copy your old data directory over to the new installation.
- Set `path.logs` to point to the location where you want to store your logs. If you do not specify this setting, logs are stored in the directory you extracted the archive to.

Complete the upgrade tasks described in the following sections **before** restarting the Beats process.

### Load 9.0 dashboards

We recommend that you load the 9.x Kibana dashboards after upgrading Kibana and Beats. That way, you can take advantage of improvements added in 9.0. To load the dashboards, run:
<tab-set>
  <tab-item title="DEB">
    ```sh
    beatname setup --dashboards
    ```
  </tab-item>

  <tab-item title="RPM">
    ```sh
    beatname setup --dashboards
    ```
  </tab-item>

  <tab-item title="MacOS">
    ```sh
    ./beatname setup --dashboards
    ```
  </tab-item>

  <tab-item title="Linux">
    ```sh
    ./beatname setup --dashboards
    ```
  </tab-item>

  <tab-item title="Docker">
    ```sh
    docker run --rm --net="host" docker.elastic.co/beats/beatname:9.0.0 setup --dashboards
    ```
  </tab-item>

  <tab-item title="Windows">
    Open a PowerShell prompt as an Administrator (right-click the PowerShell icon and select **Run As Administrator**).From the PowerShell prompt, change to the directory where you installed a Beat, and run:
    ```sh
    PS > .\beatname.exe setup --dashboards
    ```
  </tab-item>
</tab-set>


### Migrate custom dashboards and visualizations

All Elastic Beats send events with ECS-compliant field names. If you have any custom Kibana dashboards or visualizations that use old fields, adjust them now to use ECS field names.
To learn more about ECS, refer to the [ECS overview](https://www.elastic.co/docs/reference/ecs).

### Start your upgraded Beats

After you’ve completed the migration, start the upgraded Beat. Use the command that works with your system.
Check the console and logs for errors.
In Kibana, go to **Discover** and verify that events are streaming into Elasticsearch.

## Troubleshoot Beats upgrade issues

This section describes common problems you might encounter when upgrading to Beats 9.x.

### Beats is unable to send update or deletion requests to a data stream

Data streams are designed for use cases where existing data is rarely, if ever, updated. You cannot send update or deletion requests for existing documents directly to a data stream.
If needed, you can update or delete documents by submitting requests directly to the document’s backing index. To learn how, refer to the docs about [using a data stream](https://www.elastic.co/docs/manage-data/data-store/data-streams/use-data-stream).

### Timestamp field is missing

Beats requires a timestamp field to send data to data streams. If the timestamp field added by Beats is inadvertently removed by a processor, Beats will be unable to index the event. To fix the problem, modify your processor configuration to avoid removing the timestamp field.