﻿---
title: Community Beats
description: This page lists some of the Beats developed by the open source community. Have a question about developing a community Beat? You can post questions and...
url: https://www.elastic.co/docs/reference/beats/libbeat/community-beats
products:
  - Beats
applies_to:
  - Elastic Stack: Removed in 8.0, Deprecated from 7.16 to 8.0
---

# Community Beats
<admonition title="Admonition">
  **Custom Beat generator code no longer available in 8.0 and later**The custom Beat generator was a helper tool that allowed developers to bootstrap their custom Beats. This tool was deprecated in 7.16 and is no longer available starting in 8.0.Developers can continue to create custom Beats to address specific and targeted use cases. If you need to create a Beat from scratch, you can use the custom Beat generator tool available in version 7.16 or 7.17 to generate the custom Beat, then upgrade its various components to the 8.x release.
</admonition>

This page lists some of the Beats developed by the open source community.
Have a question about developing a community Beat? You can post questions and discuss issues in the [Beats discussion forum](https://discuss.elastic.co/tags/c/elastic-stack/beats/28/beats-development).
Have you created a Beat that’s not listed? Add the name and description of your Beat to the source document for [Community Beats](https://github.com/elastic/beats/blob/main/libbeat/docs/communitybeats.asciidoc) and [open a pull request](https://help.github.com/articles/using-pull-requests) in the [Beats GitHub repository](https://github.com/elastic/beats) to get your change merged. When you’re ready, go ahead and [announce](https://discuss.elastic.co/c/announcements) your new Beat in the Elastic discussion forum.
Want to contribute? See [Appendix A, *Contribute to Beats*](https://www.elastic.co/docs/reference/beats/libbeat/contributing-to-beats).
<note>
  Elastic provides no warranty or support for community-sourced Beats.
</note>

<definitions>
  <definition term="amazonbeat">
    Reads data from a specified Amazon product.
  </definition>
  <definition term="apachebeat">
    Reads status from Apache HTTPD server-status.
  </definition>
  <definition term="apexbeat">
    Extracts configurable contextual data and metrics from Java applications via the  [APEX](http://toolkits.verticle.io) toolkit.
  </definition>
  <definition term="browserbeat">
    Reads and ships browser history (Chrome, Firefox, & Safari) to an Elastic output.
  </definition>
  <definition term="cborbeat">
    Reads from cbor encoded files (specifically log files). More: [CBOR Encoding](https://cbor.io) [Decoder](https://github.com/toravir/csd)
  </definition>
  <definition term="cloudflarebeat">
    Indexes log entries from the Cloudflare Enterprise Log Share API.
  </definition>
  <definition term="cloudfrontbeat">
    Reads log events from Amazon Web Services [CloudFront](https://aws.amazon.com/cloudfront/).
  </definition>
  <definition term="cloudtrailbeat">
    Reads events from Amazon Web Services' [CloudTrail](https://aws.amazon.com/cloudtrail/).
  </definition>
  <definition term="cloudwatchmetricbeat">
    A beat for Amazon Web Services' [CloudWatch Metrics](https://aws.amazon.com/cloudwatch/details/#other-aws-resource-monitoring).
  </definition>
  <definition term="cloudwatchlogsbeat">
    Reads log events from Amazon Web Services' [CloudWatch Logs](https://aws.amazon.com/cloudwatch/details/#log-monitoring).
  </definition>
  <definition term="collectbeat">
    Adds discovery on top of Filebeat and Metricbeat in environments like Kubernetes.
  </definition>
  <definition term="connbeat">
    Exposes metadata about TCP connections.
  </definition>
  <definition term="consulbeat">
    Reads services health checks from consul and pushes them to Elastic.
  </definition>
  <definition term="discobeat">
    Reads messages from Discord and indexes them in Elasticsearch
  </definition>
  <definition term="dockbeat">
    Reads Docker container statistics and indexes them in Elasticsearch.
  </definition>
  <definition term="earthquakebeat">
    Pulls data from [USGS](https://earthquake.usgs.gov/fdsnws/event/1/) earthquake API.
  </definition>
  <definition term="elasticbeat">
    Reads status from an Elasticsearch cluster and indexes them in Elasticsearch.
  </definition>
  <definition term="envoyproxybeat">
    Reads stats from the Envoy Proxy and indexes them into Elasticsearch.
  </definition>
  <definition term="etcdbeat">
    Reads stats from the Etcd v2 API and indexes them into Elasticsearch.
  </definition>
  <definition term="etherbeat">
    Reads blocks from Ethereum compatible blockchain and indexes them into Elasticsearch.
  </definition>
  <definition term="execbeat">
    Periodically executes shell commands and sends the standard output and standard error to Logstash or Elasticsearch.
  </definition>
  <definition term="factbeat">
    Collects facts from [Facter](https://github.com/puppetlabs/facter).
  </definition>
  <definition term="fastcombeat">
    Periodically gather internet download speed from  [fast.com](https://fast.com).
  </definition>
  <definition term="fileoccurencebeat">
    Checks for file existence recurssively under a given directory, handy while handling queues/pipeline buffers.
  </definition>
  <definition term="flowbeat">
    Collects, parses, and indexes [sflow](http://www.sflow.org/index.php) samples.
  </definition>
  <definition term="gabeat">
    Collects data from Google Analytics Realtime API.
  </definition>
  <definition term="gcsbeat">
    Reads data from [Google Cloud Storage](https://cloud.google.com/storage/) buckets.
  </definition>
  <definition term="gelfbeat">
    Collects and parses GELF-encoded UDP messages.
  </definition>
  <definition term="githubbeat">
    Easily monitors GitHub repository activity.
  </definition>
  <definition term="gpfsbeat">
    Collects GPFS metric and quota information.
  </definition>
  <definition term="hackerbeat">
    Indexes the top stories of HackerNews into an ElasticSearch instance.
  </definition>
  <definition term="hsbeat">
    Reads all performance counters in Java HotSpot VM.
  </definition>
  <definition term="httpbeat">
    Polls multiple HTTP(S) endpoints and sends the data to Logstash or Elasticsearch. Supports all HTTP methods and proxies.
  </definition>
  <definition term="hsnburrowbeat">
    Monitors Kafka consumer lag for Burrow V1.0.0(API V3).
  </definition>
  <definition term="hwsensorsbeat">
    Reads sensors information from OpenBSD.
  </definition>
  <definition term="icingabeat">
    Icingabeat ships events and states from Icinga 2 to Elasticsearch or Logstash.
  </definition>
  <definition term="IIBBeat">
    Periodically executes shell commands or batch commands to collect IBM Integration node, Integration server, app status, bar file deployment time and bar file location to Logstash or Elasticsearch.
  </definition>
  <definition term="iobeat">
    Reads IO stats from /proc/diskstats on Linux.
  </definition>
  <definition term="jmxproxybeat">
    Reads Tomcat JMX metrics exposed over *JMX Proxy Servlet* to HTTP.
  </definition>
  <definition term="journalbeat">
    Used for log shipping from systemd/journald based Linux systems.
  </definition>
  <definition term="kafkabeat">
    Reads data from Kafka topics.
  </definition>
  <definition term="kafkabeat2">
    Reads data (json or plain) from Kafka topics.
  </definition>
  <definition term="krakenbeat">
    Collect information on each transaction on the Kraken crypto platform.
  </definition>
  <definition term="lmsensorsbeat">
    Collects data from lm-sensors (such as CPU temperatures, fan speeds, and voltages from i2c and smbus).
  </definition>
  <definition term="logstashbeat">
    Collects data from Logstash monitoring API (v5 onwards) and indexes them in Elasticsearch.
  </definition>
  <definition term="macwifibeat">
    Reads various indicators for a MacBook’s WiFi Signal Strength
  </definition>
  <definition term="mcqbeat">
    Reads the status of queues from memcacheq.
  </definition>
  <definition term="merakibeat">
    Collects [wireless health](https://dashboard.meraki.com/api_docs#wireless-health) and users [location analytics](https://documentation.meraki.com/MR/Monitoring_and_Reporting/Scanning_API) data using Cisco  Meraki APIs.
  </definition>
  <definition term="mesosbeat">
    Reads stats from the Mesos API and indexes them into Elasticsearch.
  </definition>
  <definition term="mongobeat">
    Monitors MongoDB instances and can be configured to send multiple document types to Elasticsearch.
  </definition>
  <definition term="mqttbeat">
    Add messages from mqtt topics to Elasticsearch.
  </definition>
  <definition term="mysqlbeat">
    Run any query on MySQL and send results to Elasticsearch.
  </definition>
  <definition term="nagioscheckbeat">
    For Nagios checks and performance data.
  </definition>
  <definition term="natsbeat">
    Collects data from NATS monitoring endpoints
  </definition>
  <definition term="netatmobeat">
    Reads data from Netatmo weather station.
  </definition>
  <definition term="netbeat">
    Reads configurable data from SNMP-enabled devices.
  </definition>
  <definition term="nginxbeat">
    Reads status from Nginx.
  </definition>
  <definition term="nginxupstreambeat">
    Reads upstream status from nginx upstream module.
  </definition>
  <definition term="nsqbeat">
    Reads data from a NSQ topic.
  </definition>
  <definition term="nvidiagpubeat">
    Uses nvidia-smi to grab metrics of NVIDIA GPUs.
  </definition>
  <definition term="o365beat">
    Ships Office 365 logs from the O365 Management Activities API
  </definition>
  <definition term="openconfigbeat">
    Streams data from [OpenConfig](http://openconfig.net)-enabled network devices
  </definition>
  <definition term="openvpnbeat">
    Collects OpenVPN connection metrics
  </definition>
  <definition term="owmbeat">
    Open Weather Map beat to pull weather data from all around the world and store and visualize them in Elastic Stack
  </definition>
  <definition term="packagebeat">
    Collects information about system packages from package managers.
  </definition>
  <definition term="perfstatbeat">
    Collects performance metrics on the AIX operating system.
  </definition>
  <definition term="phishbeat">
    Monitors Certificate Transparency logs for phishing and defamatory domains.
  </definition>
  <definition term="phpfpmbeat">
    Reads status from PHP-FPM.
  </definition>
  <definition term="pingbeat">
    Sends ICMP pings to a list of targets and stores the round trip time (RTT) in Elasticsearch.
  </definition>
  <definition term="powermaxbeat">
    Collects performance metrics from Dell EMC PowerMax storage array.
  </definition>
  <definition term="processbeat">
    Collects process health status and performance.
  </definition>
  <definition term="prombeat">
    Indexes [Prometheus](https://prometheus.io) metrics.
  </definition>
  <definition term="prometheusbeat">
    Send Prometheus metrics to Elasticsearch via the remote write feature.
  </definition>
  <definition term="protologbeat">
    Accepts structured and unstructured logs via UDP or TCP.  Can also be used to receive syslog messages or GELF formatted messages. (To be used as a successor to udplogbeat)
  </definition>
  <definition term="pubsubbeat">
    Reads data from [Google Cloud Pub/Sub](https://cloud.google.com/pubsub/).
  </definition>
  <definition term="redditbeat">
    Collects new Reddit Submissions of one or multiple Subreddits.
  </definition>
  <definition term="redisbeat">
    Used for Redis monitoring.
  </definition>
  <definition term="retsbeat">
    Collects counts of [RETS](http://www.reso.org) resource/class records from [Multiple Listing Service](https://en.wikipedia.org/wiki/Multiple_listing_service) (MLS) servers.
  </definition>
  <definition term="rsbeat">
    Ships redis slow logs to elasticsearch and analyze by Kibana.
  </definition>
  <definition term="safecastbeat">
    Pulls data from Safecast API and store them in Elasticsearch.
  </definition>
  <definition term="saltbeat">
    Reads events from salt master event bus.
  </definition>
  <definition term="serialbeat">
    Reads from a serial device.
  </definition>
  <definition term="servicebeat">
    Send services status to Elasticsearch
  </definition>
  <definition term="springbeat">
    Collects health and metrics data from Spring Boot applications running with the actuator module.
  </definition>
  <definition term="springboot2beat">
    Query and accumulate all metrics endpoints of a Spring Boot 2 web app via the web channel, leveraging the [mircometer.io](http://micrometer.io/) metrics facade.
  </definition>
  <definition term="statsdbeat">
    Receives UDP [statsd](https://github.com/etsy/statsd/wiki) events from a statsd client.
  </definition>
  <definition term="supervisorctlbeat">
    This beat aims to parse the supervisorctl status command output and send it to elasticsearch for indexation
  </definition>
  <definition term="terminalbeat">
    Runs an external command and forwards the [stdout](https://www.computerhope.com/jargon/s/stdout.htm) for the same to Elasticsearch/Logstash.
  </definition>
  <definition term="timebeat">
    NTP and PTP clock synchonisation beat that reports accuracy metrics to elastic. Includes Kibana dashboards.
  </definition>
  <definition term="tracebeat">
    Reads traceroute output and indexes them into Elasticsearch.
  </definition>
  <definition term="trivybeat">
    Fetches Docker containers which are running on the same machine, scan CVEs of those containers using Trivy server and index them into Elasticsearch.
  </definition>
  <definition term="twitterbeat">
    Reads tweets for specified screen names.
  </definition>
  <definition term="udpbeat">
    Ships structured logs via UDP.
  </definition>
  <definition term="udplogbeat">
    Accept events via local UDP socket (in plain-text or JSON with ability to enforce schemas).  Can also be used for applications only supporting syslog logging.
  </definition>
  <definition term="unifiedbeat">
    Reads records from Unified2 binary files generated by network intrusion detection software and indexes the records in Elasticsearch.
  </definition>
  <definition term="unitybeat">
    Collects performance metrics from Dell EMC Unity storage array.
  </definition>
  <definition term="uwsgibeat">
    Reads stats from uWSGI.
  </definition>
  <definition term="varnishlogbeat">
    Reads log data from a Varnish instance and ships it to Elasticsearch.
  </definition>
  <definition term="varnishstatbeat">
    Reads stats data from a Varnish instance and ships it to Elasticsearch.
  </definition>
  <definition term="vaultbeat">
    Collects performance metrics and statistics from Hashicorp’s Vault.
  </definition>
  <definition term="wmibeat">
    Uses WMI to grab your favorite, configurable Windows metrics.
  </definition>
  <definition term="yarnbeat">
    Polls YARN and MapReduce APIs for cluster and application metrics.
  </definition>
  <definition term="zfsbeat">
    Querying ZFS Storage and Pool Status
  </definition>
</definitions>