﻿---
title: Grant privileges and roles needed to read Heartbeat data from Kibana
description: Kibana users typically need to view dashboards and visualizations that contain Heartbeat data. These users might also need to create and edit dashboards...
url: https://www.elastic.co/docs/reference/beats/heartbeat/kibana-user-privileges
products:
  - Beats
  - Heartbeat
applies_to:
  - Elastic Stack: Generally available
---

# Grant privileges and roles needed to read Heartbeat data from Kibana
Kibana users typically need to view dashboards and visualizations that contain Heartbeat data. These users might also need to create and edit dashboards and visualizations.
To grant users the required privileges:
1. Create a **reader role**, called something like `heartbeat_reader`, that has the following privilege:
   | Type   | Privilege                                              | Purpose                                                                      |
   |--------|--------------------------------------------------------|------------------------------------------------------------------------------|
   | Index  | `read` on `heartbeat-*` indices                        | Read data indexed by Heartbeat                                               |
   | Spaces | `Read` or `All` on Dashboards, Visualize, and Discover | Allow the user to view, edit, and create dashboards, as well as browse data. |
   | Spaces | `Read` or `All` on Kibana Uptime                       | Allow the use of Kibana Uptime                                               |
2. Assign the **reader role**, along with the following built-in roles, to users who need to read Heartbeat data:
   | Role              | Purpose                                                                                                     |
   |-------------------|-------------------------------------------------------------------------------------------------------------|
   | `monitoring_user` | Allow users to monitor the health of Heartbeat itself. Only assign this role to users who manage Heartbeat. |