﻿---
title: Configure index lifecycle management
description: Use the index lifecycle management (ILM) feature in Elasticsearch to manage your Heartbeat their backing indices of your data streams as they age. Heartbeat...
url: https://www.elastic.co/docs/reference/beats/heartbeat/ilm
products:
  - Beats
  - Heartbeat
applies_to:
  - Elastic Stack: Generally available
---

# Configure index lifecycle management
Use the [index lifecycle management](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/ilm-tutorials) (ILM) feature in Elasticsearch to manage your Heartbeat their backing indices of your data streams as they age. Heartbeat loads the default policy automatically and applies it to any data streams created by Heartbeat.
You can view and edit the policy in the **Index lifecycle policies** UI in Kibana. For more information about working with the UI, see [Index lifecyle policies](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management).
Example configuration:
```yaml
setup.ilm.enabled: true
```

<warning>
  If index lifecycle management is enabled (which is typically the default), `setup.template.name` and `setup.template.pattern` are ignored.
</warning>


## Configuration options

You can specify the following settings in the `setup.ilm` section of the `heartbeat.yml` config file:

### `setup.ilm.enabled`

Enables or disables index lifecycle management on any new indices created by Heartbeat. Valid values are `true` and `false`.

### `setup.ilm.policy_name`

The name to use for the lifecycle policy. The default is `heartbeat`.

### `setup.ilm.policy_file`

The path to a JSON file that contains a lifecycle policy configuration. Use this setting to load your own lifecycle policy.
For more information about lifecycle policies, see [Set up index lifecycle management policy](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/configure-lifecycle-policy) in the *Elasticsearch Reference*.

### `setup.ilm.check_exists`

When set to `false`, disables the check for an existing lifecycle policy. The default is `true`. You need to disable this check if the Heartbeat user connecting to a secured cluster doesn’t have the `read_ilm` privilege.
If you set this option to `false`, lifecycle policy will not be installed, even if `setup.ilm.overwrite` is set to `true`.

### `setup.ilm.overwrite`

When set to `true`, the lifecycle policy is overwritten at startup. The default is `false`.