﻿---
title: Heartbeat quick start: installation and configuration
description: This guide describes how to get started quickly collecting uptime data about your hosts. You’ll learn how to: install Heartbeat, specify the protocols...
url: https://www.elastic.co/docs/reference/beats/heartbeat/heartbeat-installation-configuration
products:
  - Beats
  - Heartbeat
applies_to:
  - Elastic Stack: Generally available
---

# Heartbeat quick start: installation and configuration
This guide describes how to get started quickly collecting uptime data about your hosts. You’ll learn how to:
- install Heartbeat
- specify the protocols to monitor
- send uptime data to Elasticsearch
- visualize the uptime data in Kibana

![Heartbeat HTTP monitoring dashboard](https://www.elastic.co/docs/reference/beats/heartbeat/images/heartbeat-statistics.png)

## Before you begin

You need Elasticsearch for storing and searching your data, and Kibana for visualizing and managing it.
<applies-switch>
  <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
    To get started quickly, spin up an [Elastic Cloud Hosted](https://www.elastic.co/cloud?page=docs&placement=docs-body) deployment. Elastic Cloud Hosted is available on AWS, GCP, and Azure. [Try it out for free](https://cloud.elastic.co/registration?page=docs&placement=docs-body).
  </applies-item>

  <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
    To install and run Elasticsearch and Kibana, see [Installing the Elastic Stack](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch).
  </applies-item>
</applies-switch>


## Step 1: Install Heartbeat

Unlike most Beats, which you install on edge nodes, you typically install Heartbeat as part of a monitoring service that runs on a separate machine and possibly even outside of the network where the services that you want to monitor are running.
To download and install Heartbeat, use the commands that work with your system:
<tab-set>
  <tab-item title="DEB">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/heartbeat/heartbeat-9.3.0-amd64.deb
    sudo dpkg -i heartbeat-9.3.0-amd64.deb
    ```
  </tab-item>

  <tab-item title="RPM">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/heartbeat/heartbeat-9.3.0-x86_64.rpm
    sudo rpm -vi heartbeat-9.3.0-x86_64.rpm
    ```
  </tab-item>

  <tab-item title="MacOS">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/heartbeat/heartbeat-9.3.0-darwin-x86_64.tar.gz
    tar xzvf heartbeat-9.3.0-darwin-x86_64.tar.gz
    ```
  </tab-item>

  <tab-item title="Linux">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/heartbeat/heartbeat-9.3.0-linux-x86_64.tar.gz
    tar xzvf heartbeat-9.3.0-linux-x86_64.tar.gz
    ```
  </tab-item>

  <tab-item title="Windows">
    1. Download the [Heartbeat Windows zip file](https://artifacts.elastic.co/downloads/beats/heartbeat/heartbeat-9.3.0-windows-x86_64.zip).
    2. Extract the contents of the zip file into `C:\Program Files`.
    3. Rename the `heartbeat-[version]-windows-x86_64` directory to `Heartbeat`.
    4. Open a PowerShell prompt as an Administrator (right-click the PowerShell icon and select *Run As Administrator*).
    5. From the PowerShell prompt, run the following commands to install Heartbeat as a Windows service:

    ```shell
    PS > cd 'C:\Program Files\Heartbeat'
    PS C:\Program Files\Heartbeat> .\install-service-heartbeat.ps1
    ```

    <note>
      If script execution is disabled on your system, you need to set the execution policy for the current session to allow the script to run. For example: `PowerShell.exe -ExecutionPolicy UnRestricted -File .\install-service-heartbeat.ps1`.
    </note>

    <important applies-to="Elastic Stack: Generally available since 9.0.6">
      The base folder has changed from `C:\ProgramData\` to `C:\Program Files\`
      because the latter has stricter permissions. The home path (base for
      state and logs) is now `C:\Program Files\Heartbeat-Data`.The install script (`install-service-heartbeat.ps1`) will check whether
      `C:\ProgramData\Heartbeat` exits and move it to `C:\Program Files\Heartbeat-Data`.
      For more details on the installation script refer to: [install script](https://www.elastic.co/docs/reference/beats/heartbeat/heartbeat-installation-script).
    </important>
  </tab-item>
</tab-set>

The commands shown are for AMD platforms, but ARM packages are also available. Refer to the [download page](https://www.elastic.co/downloads/beats/heartbeat) for the full list of available packages.

### Other installation options

- [APT or YUM](https://www.elastic.co/docs/reference/beats/heartbeat/setup-repositories)
- [Download page](https://www.elastic.co/downloads/beats/heartbeat)
- [Docker](https://www.elastic.co/docs/reference/beats/heartbeat/running-on-docker)


## Step 2: Connect to the Elastic Stack

Connections to Elasticsearch and Kibana are required to set up Heartbeat.
Set the connection information in `heartbeat.yml`. To locate this configuration file, see [Directory layout](https://www.elastic.co/docs/reference/beats/heartbeat/directory-layout).
<applies-switch>
  <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
    Specify the [cloud.id](https://www.elastic.co/docs/reference/beats/heartbeat/configure-cloud-id) of your Elastic Cloud Hosted deployment, and set [cloud.auth](https://www.elastic.co/docs/reference/beats/heartbeat/configure-cloud-id) to a user who is authorized to set up Heartbeat. For example:
    ```yaml
    cloud.id: "staging:dXMtZWFzdC0xLmF3cy5mb3VuZC5pbyRjZWM2ZjI2MWE3NGJmMjRjZTMzYmI4ODExYjg0Mjk0ZiRjNmMyY2E2ZDA0MjI0OWFmMGNjN2Q3YTllOTYyNTc0Mw=="
    cloud.auth: "heartbeat_setup:YOUR_PASSWORD" 
    ```
  </applies-item>

  <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
    1. Set the host and port where Heartbeat can find the Elasticsearch installation, and set the username and password of a user who is authorized to set up Heartbeat. For example:
       ```yaml
       output.elasticsearch:
         hosts: ["https://myEShost:9200"]
         username: "heartbeat_internal"
         password: "YOUR_PASSWORD" 
         ssl:
           enabled: true
           ca_trusted_fingerprint: "b9a10bbe64ee9826abeda6546fc988c8bf798b41957c33d05db736716513dc9c" 
       ```
    2. If you plan to use our pre-built Kibana dashboards, configure the Kibana endpoint. Skip this step if Kibana is running on the same host as Elasticsearch.
       ```yaml
         setup.kibana:
           host: "mykibanahost:5601" 
           username: "my_kibana_user" <2> 
           password: "YOUR_PASSWORD"
       ```
  </applies-item>
</applies-switch>

To learn more about required roles and privileges, see [*Grant users access to secured resources*](https://www.elastic.co/docs/reference/beats/heartbeat/feature-roles).
<note>
  You can send data to other [outputs](https://www.elastic.co/docs/reference/beats/heartbeat/configuring-output), such as Logstash, but that requires additional configuration and setup.
</note>


## Step 3: Configure Heartbeat monitors

Heartbeat provides monitors to check the status of hosts at set intervals. Heartbeat currently provides monitors for ICMP, TCP, and HTTP (see [*Heartbeat overview*](https://www.elastic.co/docs/reference/beats/heartbeat) for more about these monitors).
You configure each monitor individually. In `heartbeat.yml`, specify the list of monitors that you want to enable. Each item in the list begins with a dash (-). The following example configures Heartbeat to use three monitors: an `icmp` monitor, a `tcp` monitor, and an `http` monitor.
```yaml
heartbeat.monitors:
- type: icmp
  schedule: '*/5 * * * * * *' 
  hosts: ["myhost"]
  id: my-icmp-service
  name: My ICMP Service
- type: tcp
  schedule: '@every 5s' 
  hosts: ["myhost:12345"]
  mode: any 
  id: my-tcp-service
- type: http
  schedule: '@every 5s'
  urls: ["http://example.net"]
  service.name: apm-service-name 
  id: my-http-service
  name: My HTTP Service
```

<tip>
  To test your configuration file, change to the directory where the Heartbeat binary is installed, and run Heartbeat in the foreground with the following options specified: `./heartbeat test config -e`. Make sure your config files are in the path expected by Heartbeat (see [Directory layout](https://www.elastic.co/docs/reference/beats/heartbeat/directory-layout)), or use the `-c` flag to specify the path to the config file.
</tip>

For more information about configuring Heartbeat, also see:
- [Configure Heartbeat](https://www.elastic.co/docs/reference/beats/heartbeat/configuring-howto-heartbeat)
- [Config file format](https://www.elastic.co/docs/reference/beats/libbeat/config-file-format)
- [`heartbeat.reference.yml`](https://www.elastic.co/docs/reference/beats/heartbeat/heartbeat-reference-yml): This reference configuration file shows all non-deprecated options. You’ll find it in the same location as `heartbeat.yml`.


## Step 4: Configure the Heartbeat location

Heartbeat can be deployed in multiple locations so that you can detect differences in availability and response times across those locations. Configure the Heartbeat location to allow Kibana to display location-specific information on Uptime maps and perform Uptime anomaly detection based on location.
To configure the location of a Heartbeat instance, modify the `add_observer_metadata` processor in `heartbeat.yml`.  The following example specifies the `geo.name` of the `add_observer_metadata` processor as `us-east-1a`:
```yaml
# ============================ Processors ============================

processors:
  - add_observer_metadata:
      # Optional, but recommended geo settings for the location Heartbeat is running in
      geo: 
        # Token describing this location
        name: us-east-1a 
        # Lat, Lon "
        #location: "37.926868, -78.024902" 
```

<tip>
  To test your configuration file, change to the directory where the Heartbeat binary is installed, and run Heartbeat in the foreground with the following options specified: `./heartbeat test config -e`. Make sure your config files are in the path expected by Heartbeat (see [Directory layout](https://www.elastic.co/docs/reference/beats/heartbeat/directory-layout)), or use the `-c` flag to specify the path to the config file.
</tip>

For more information about configuring Heartbeat, also see:
- [Configure Heartbeat](https://www.elastic.co/docs/reference/beats/heartbeat/configuring-howto-heartbeat)
- [Config file format](https://www.elastic.co/docs/reference/beats/libbeat/config-file-format)
- [`heartbeat.reference.yml`](https://www.elastic.co/docs/reference/beats/heartbeat/heartbeat-reference-yml): This reference configuration file shows all non-deprecated options. You’ll find it in the same location as `heartbeat.yml`.


## Step 5: Set up assets

Heartbeat comes with predefined assets for parsing, indexing, and visualizing your data. To load these assets:
1. Make sure the user specified in `heartbeat.yml` is [authorized to set up Heartbeat](https://www.elastic.co/docs/reference/beats/heartbeat/privileges-to-setup-beats).
2. From the installation directory, run:

<tab-set>
  <tab-item title="DEB">
    ```sh
    heartbeat setup -e
    ```
  </tab-item>

  <tab-item title="RPM">
    ```sh
    heartbeat setup -e
    ```
  </tab-item>

  <tab-item title="MacOS">
    ```sh
    ./heartbeat setup -e
    ```
  </tab-item>

  <tab-item title="Linux">
    ```sh
    ./heartbeat setup -e
    ```
  </tab-item>

  <tab-item title="Windows">
    ```sh
    PS > .\heartbeat.exe setup -e
    ```
  </tab-item>
</tab-set>


## Step 6: Start Heartbeat

Before starting Heartbeat, modify the user credentials in heartbeat.yml and specify a user who is [authorized to publish events](https://www.elastic.co/docs/reference/beats/heartbeat/privileges-to-publish-events).
To start Heartbeat, run:
<tab-set>
  <tab-item title="DEB">
    ```sh
    sudo service heartbeat-elastic start
    ```

    <note>
      If you use an `init.d` script to start Heartbeat, you can’t specify command line flags (see [Command reference](https://www.elastic.co/docs/reference/beats/heartbeat/command-line-options)). To specify flags, start Heartbeat in the foreground.
    </note>
    Also see [Heartbeat and systemd](https://www.elastic.co/docs/reference/beats/heartbeat/running-with-systemd).
  </tab-item>

  <tab-item title="RPM">
    ```sh
    sudo service heartbeat-elastic start
    ```

    <note>
      If you use an `init.d` script to start Heartbeat, you can’t specify command line flags (see [Command reference](https://www.elastic.co/docs/reference/beats/heartbeat/command-line-options)). To specify flags, start Heartbeat in the foreground.
    </note>
    Also see [Heartbeat and systemd](https://www.elastic.co/docs/reference/beats/heartbeat/running-with-systemd).
  </tab-item>

  <tab-item title="MacOS">
    ```sh
    sudo chown root heartbeat.yml 
    sudo ./heartbeat -e
    ```
  </tab-item>

  <tab-item title="Linux">
    ```sh
    sudo chown root heartbeat.yml 
    sudo ./heartbeat -e
    ```
  </tab-item>

  <tab-item title="Windows">
    ```sh
    PS C:\Program Files\heartbeat> Start-Service heartbeat
    ```
  </tab-item>
</tab-set>

By default Windows log files are stored in `C:\Program Files\Heartbeat-Data\logs`.
<note>
  In versions before 9.0.6, the default location for Windows log files was `C:\ProgramData\heartbeat\logs`.
</note>

Heartbeat is now ready to check the status of your services and send events to your defined output.

## Step 7: View your data in Kibana

Heartbeat comes with pre-built Kibana dashboards and UIs for visualizing the status of your services. The dashboards are available in the [uptime-contrib](https://github.com/elastic/uptime-contrib) GitHub repository.
If you loaded the dashboards earlier, open them now.
To open the dashboards:
1. Launch Kibana:
   <applies-switch>
   <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
   1. [Log in](https://cloud.elastic.co/) to your Elastic Cloud account.
   2. Navigate to the Kibana endpoint in your deployment.
   </applies-item>

   <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
   Point your browser to [http://localhost:5601](http://localhost:5601), replacing `localhost` with the name of the Kibana host.
   </applies-item>
   </applies-switch>
2. In the side navigation, click **Discover**. To see Heartbeat data, make sure the predefined `heartbeat-*` data view is selected.
   <tip>
   If you don’t see data in Kibana, try changing the time filter to a larger range. By default, Kibana shows the last 15 minutes.
   </tip>
3. In the side navigation, click **Dashboard**, then select the dashboard that you want to open.

The dashboards are provided as examples. We recommend that you [customize](https://www.elastic.co/docs/explore-analyze/dashboards) them to meet your needs.

## What’s next?

Now that you have your uptime data streaming into Elasticsearch, learn how to unify your logs, metrics, uptime, and application performance data.
1. Ingest data from other sources by installing and configuring other Elastic Beats:
   | Elastic Beats                                                                                              | To capture                      |
   |------------------------------------------------------------------------------------------------------------|---------------------------------|
   | [Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-installation-configuration) | Infrastructure metrics          |
   | [Filebeat](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration)       | Logs                            |
   | [Winlogbeat](https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-installation-configuration) | Windows event logs              |
   | [APM](https://www.elastic.co/docs/solutions/observability/apm)                                             | Application performance metrics |
   | [Auditbeat](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-installation-configuration)    | Audit events                    |
2. Use the Observability apps in Kibana to search across all your data:
   | Elastic apps                                                                                                           | Use to                                                           |
   |------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------|
   | [Metrics app](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics) | Explore metrics about systems and services across your ecosystem |
   | [Logs app](https://www.elastic.co/docs/solutions/observability/logs/explore-logs)                                      | Tail related log data in real time                               |
   | [Uptime app](https://www.elastic.co/docs/solutions/observability/synthetics#monitoring-uptime)                         | Monitor availability issues across your apps and services        |
   | [APM app](https://www.elastic.co/docs/solutions/observability/apm/overviews)                                           | Monitor application performance                                  |
   | [SIEM app](https://www.elastic.co/docs/solutions/security)                                                             | Analyze security events                                          |