﻿---
title: TLS encryption layer fields
description: None TLS layer related fields. TLS layer round trip times. Time required to finish TLS handshake based on already available network connection. Detailed...
url: https://www.elastic.co/docs/reference/beats/heartbeat/exported-fields-tls
products:
  - Beats
  - Heartbeat
applies_to:
  - Elastic Stack: Generally available
---

# TLS encryption layer fields
None

## tls

TLS layer related fields.
<definitions>
  <definition term="tls.certificate_not_valid_before Elastic Stack: Deprecated since 7.8">
    Deprecated in favor of `tls.server.x509.not_before`. Earliest time at which the connection's certificates are valid.
    type: date
  </definition>
  <definition term="tls.certificate_not_valid_after Elastic Stack: Deprecated since 7.8">
    Deprecated in favor of `tls.server.x509.not_after`. Latest time at which the connection's certificates are valid.
    type: date
  </definition>
</definitions>


## rtt

TLS layer round trip times.

## handshake

Time required to finish TLS handshake based on already available network connection.
<definitions>
  <definition term="tls.rtt.handshake.us">
    Duration in microseconds
    type: long
  </definition>
</definitions>


## server

Detailed x509 certificate metadata
<definitions>
  <definition term="tls.server.version_number">
    Version of x509 format.
    type: keyword
    example: 3
  </definition>
</definitions>