﻿---
title: Monitor summary fields
description: None Present in the last event emitted during a check. If a monitor checks multiple endpoints, as is the case with mode: all. 
url: https://www.elastic.co/docs/reference/beats/heartbeat/exported-fields-summary
products:
  - Beats
  - Heartbeat
applies_to:
  - Elastic Stack: Generally available
---

# Monitor summary fields
None

## summary

Present in the last event emitted during a check. If a monitor checks multiple endpoints, as is the case with `mode: all`.
<definitions>
  <definition term="summary.up">
    The number of endpoints that succeeded
    type: integer
  </definition>
  <definition term="summary.down">
    The number of endpoints that failed
    type: integer
  </definition>
  <definition term="summary.status">
    The status of this check as a whole. Either up or down.
    type: keyword
  </definition>
  <definition term="summary.attempt">
    When performing a check this number is 1 for the first check, and increments in the event of a retry.
    type: short
  </definition>
  <definition term="summary.max_attempts">
    The maximum number of checks that may be performed. Note, the actual number may be smaller.
    type: short
  </definition>
  <definition term="summary.final_attempt">
    True if no further checks will be performed in this retry group.
    type: boolean
  </definition>
  <definition term="summary.retry_group">
    A unique token used to group checks across attempts.
    type: keyword
  </definition>
</definitions>