﻿---
title: Monitor state fields
description: state related fields Present in the last event emitted during a check. If a monitor checks multiple endpoints, as is the case with mode: all. 
url: https://www.elastic.co/docs/reference/beats/heartbeat/exported-fields-state
products:
  - Beats
  - Heartbeat
applies_to:
  - Elastic Stack: Generally available
---

# Monitor state fields
state related fields

## state

Present in the last event emitted during a check. If a monitor checks multiple endpoints, as is the case with `mode: all`.
<definitions>
  <definition term="state.id">
    ID of this state
    type: keyword
  </definition>
  <definition term="state.started_at">
    First time state with this ID was seen
    type: date
  </definition>
  <definition term="state.duration_ms">
    Length of time this state has existed in millis
    type: long
  </definition>
  <definition term="state.status">
    The current status, "up", "down", or "flapping" any state can change into flapping.
    type: keyword
  </definition>
  <definition term="state.checks">
    total checks run
    type: integer
  </definition>
  <definition term="state.up">
    total up checks run
    type: integer
  </definition>
  <definition term="state.down">
    total down checks run
    type: integer
  </definition>
  <definition term="state.flap_history">
    Object is not enabled.
  </definition>
  <definition term="state.ends">
    the state that was ended by this state
    type: object
  </definition>
</definitions>