﻿---
title: HTTP monitor fields
description: None HTTP related fields. Object is not enabled. HTTP layer round trip times. Duration between first byte of HTTP request being written and response being...
url: https://www.elastic.co/docs/reference/beats/heartbeat/exported-fields-http
products:
  - Beats
  - Heartbeat
applies_to:
  - Elastic Stack: Generally available
---

# HTTP monitor fields
None

## http

HTTP related fields.
<definitions>
  <definition term="http.url">
    Service url used by monitor.
    type: alias
    alias to: url.full
  </definition>
  <definition term="http.response.body.hash">
    Hash of the full response body. Can be used to group responses with identical hashes.
    type: keyword
  </definition>
  <definition term="http.response.redirects">
    List of redirects followed to arrive at final content. Last item on the list is the URL for which body content is shown.
    type: keyword
  </definition>
  <definition term="http.response.headers.*">
    The canonical headers of the monitored HTTP response.
    type: object
  </definition>
</definitions>

Object is not enabled.

## rtt

HTTP layer round trip times.

## validate

Duration between first byte of HTTP request being written and
response being processed by validator. Duration based on already
available network connection.
Note: if validator is not reading body or only a prefix, this
number does not fully represent the total time needed
to read the body.
<definitions>
  <definition term="http.rtt.validate.us">
    Duration in microseconds
    type: long
  </definition>
</definitions>


## validate_body

Duration of validator required to read and validate the response
body.
Note: if validator is not reading body or only a prefix, this
number does not fully represent the total time needed
to read the body.
<definitions>
  <definition term="http.rtt.validate_body.us">
    Duration in microseconds
    type: long
  </definition>
</definitions>


## write_request

Duration of sending the complete HTTP request. Duration based on already available network connection.
<definitions>
  <definition term="http.rtt.write_request.us">
    Duration in microseconds
    type: long
  </definition>
</definitions>


## response_header

Time required between sending the start of sending the HTTP request and first byte from HTTP response being read. Duration based on already available network connection.
<definitions>
  <definition term="http.rtt.response_header.us">
    Duration in microseconds
    type: long
  </definition>
  <definition term="http.rtt.content.us">
    Time required to retrieved the content in micro seconds.
    type: long
  </definition>
</definitions>


## total

Duration required to process the HTTP transaction. Starts with
the initial TCP connection attempt. Ends with after validator
did check the response.
Note: if validator is not reading body or only a prefix, this
number does not fully represent the total time needed.
<definitions>
  <definition term="http.rtt.total.us">
    Duration in microseconds
    type: long
  </definition>
</definitions>