﻿---
title: Common heartbeat monitor fields
description: None Common monitor fields. Total monitoring test duration Project info for this monitor 
url: https://www.elastic.co/docs/reference/beats/heartbeat/exported-fields-common
products:
  - Beats
  - Heartbeat
applies_to:
  - Elastic Stack: Generally available
---

# Common heartbeat monitor fields
None

## monitor

Common monitor fields.
<definitions>
  <definition term="monitor.type">
    The monitor type.
    type: keyword
  </definition>
  <definition term="monitor.name">
    The monitors configured name
    type: keyword
  </definition>
  <definition term="monitor.name.text">
    type: text
  </definition>
  <definition term="monitor.id">
    The monitors full job ID as used by heartbeat.
    type: keyword
  </definition>
  <definition term="monitor.id.text">
    type: text
  </definition>
</definitions>


## duration

Total monitoring test duration
<definitions>
  <definition term="monitor.duration.us">
    Duration in microseconds
    type: long
  </definition>
  <definition term="monitor.scheme">
    Address url scheme. For example `tcp`, `tls`, `http`, and `https`.
    type: alias
    alias to: url.scheme
  </definition>
  <definition term="monitor.host">
    Hostname of service being monitored. Can be missing, if service is monitored by IP.
    type: alias
    alias to: url.domain
  </definition>
  <definition term="monitor.ip">
    IP of service being monitored. If service is monitored by hostname, the `ip` field contains the resolved ip address for the current host.
    type: ip
  </definition>
  <definition term="monitor.status">
    Indicator if monitor could validate the service to be available.
    type: keyword
    required: True
  </definition>
  <definition term="monitor.check_group">
    A token unique to a simultaneously invoked group of checks as in the case where multiple IPs are checked for a single DNS entry.
    type: keyword
  </definition>
  <definition term="monitor.timespan">
    Time range this ping reported starting at the instant the check was started, ending at the start of the next scheduled check.
    type: date_range
  </definition>
  <definition term="monitor.origin">
    The origin of this monitor configuration, usually either "ui", or "project"
    type: keyword
  </definition>
</definitions>


## project

Project info for this monitor
<definitions>
  <definition term="monitor.project.id">
    Project ID
    type: keyword
  </definition>
  <definition term="monitor.project.name">
    Project name
    type: keyword
  </definition>
</definitions>