﻿---
title: Synthetics browser metrics fields
description: None Browser metrics and traces Absolute values of all user experience metrics in the browser relative to the navigation start event in microseconds duration...
url: https://www.elastic.co/docs/reference/beats/heartbeat/exported-fields-browser
products:
  - Beats
  - Heartbeat
applies_to:
  - Elastic Stack: Generally available
---

# Synthetics browser metrics fields
None

## browser

Browser metrics and traces

## experience

Absolute values of all user experience metrics in the browser relative to the navigation start event in microseconds

## fcp

duration of First contentful paint metric
<definitions>
  <definition term="browser.experience.fcp.us">
    type: integer
  </definition>
</definitions>


## lcp

duration of Largest contentful paint metric
<definitions>
  <definition term="browser.experience.lcp.us">
    type: integer
  </definition>
</definitions>


## dcl

duration of Document content loaded end event
<definitions>
  <definition term="browser.experience.dcl.us">
    type: integer
  </definition>
</definitions>


## load

duration of Load end event
<definitions>
  <definition term="browser.experience.load.duration">
    type: integer
  </definition>
  <definition term="browser.experience.cls">
    culumative layout shift score across all frames
    type: integer
  </definition>
</definitions>


## relative_trace

trace event with timing information that are realtive to journey timings in microseconds
<definitions>
  <definition term="browser.relative_trace.name">
    name of the trace event
    type: keyword
  </definition>
  <definition term="browser.relative_trace.type">
    could be one of mark or measure event types
    type: text
  </definition>
</definitions>


## start

monotonically increasing trace start time in microseconds
<definitions>
  <definition term="browser.relative_trace.start.us">
    type: long
  </definition>
</definitions>


## duration

duration of the trace event in microseconds.
<definitions>
  <definition term="browser.relative_trace.duration.us">
    type: integer
  </definition>
  <definition term="browser.relative_trace.score">
    weighted score of the layout shift event
    type: integer
  </definition>
</definitions>