﻿---
title: Directory layout
description: The directory layout of an installation is as follows: You can change these settings by using CLI flags or setting path options in the configuration file...
url: https://www.elastic.co/docs/reference/beats/heartbeat/directory-layout
products:
  - Beats
  - Heartbeat
applies_to:
  - Elastic Stack: Generally available
---

# Directory layout
The directory layout of an installation is as follows:
<tip>
  Archive installation has a different layout. See [zip, tar.gz, or tgz](#directory-layout-archive).
</tip>


| Type   | Description                                     | Default Location   | Config Option |
|--------|-------------------------------------------------|--------------------|---------------|
| home   | Home of the Heartbeat installation.             |                    | `path.home`   |
| bin    | The location for the binary files.              | `{path.home}/bin`  |               |
| config | The location for configuration files.           | `{path.home}`      | `path.config` |
| data   | The location for persistent data files.         | `{path.home}/data` | `path.data`   |
| logs   | The location for the logs created by Heartbeat. | `{path.home}/logs` | `path.logs`   |

You can change these settings by using CLI flags or setting [path options](https://www.elastic.co/docs/reference/beats/heartbeat/configuration-path) in the configuration file.

## Default paths

Heartbeat uses the following default paths unless you explicitly change them.

#### deb and rpm


| Type   | Description                                     | Location                   |
|--------|-------------------------------------------------|----------------------------|
| home   | Home of the Heartbeat installation.             | `/usr/share/heartbeat`     |
| bin    | The location for the binary files.              | `/usr/share/heartbeat/bin` |
| config | The location for configuration files.           | `/etc/heartbeat`           |
| data   | The location for persistent data files.         | `/var/lib/heartbeat`       |
| logs   | The location for the logs created by Heartbeat. | `/var/log/heartbeat`       |

For the deb and rpm distributions, these paths are set in the init script or in the systemd unit file.  Make sure that you start the Heartbeat service by using the preferred operating system method (init scripts or `systemctl`). Otherwise the paths might be set incorrectly.

#### docker


| Type   | Description                                     | Location                    |
|--------|-------------------------------------------------|-----------------------------|
| home   | Home of the Heartbeat installation.             | `/usr/share/heartbeat`      |
| bin    | The location for the binary files.              | `/usr/share/heartbeat`      |
| config | The location for configuration files.           | `/usr/share/heartbeat`      |
| data   | The location for persistent data files.         | `/usr/share/heartbeat/data` |
| logs   | The location for the logs created by Heartbeat. | `/usr/share/heartbeat/logs` |


#### zip, tar.gz, or tgz


| Type   | Description                                     | Location              |
|--------|-------------------------------------------------|-----------------------|
| home   | Home of the Heartbeat installation.             | `{extract.path}`      |
| bin    | The location for the binary files.              | `{extract.path}`      |
| config | The location for configuration files.           | `{extract.path}`      |
| data   | The location for persistent data files.         | `{extract.path}/data` |
| logs   | The location for the logs created by Heartbeat. | `{extract.path}/logs` |

For the zip, tar.gz, or tgz distributions, these paths are based on the location of the extracted binary file. This means that if you start Heartbeat with the following simple command, all paths are set correctly:
```sh
./heartbeat
```