﻿---
title: Configure Heartbeat
description: To configure Heartbeat, edit the configuration file. The default configuration file is called  heartbeat.yml. The location of the file varies by platform...
url: https://www.elastic.co/docs/reference/beats/heartbeat/configuring-howto-heartbeat
products:
  - Beats
  - Heartbeat
applies_to:
  - Elastic Stack: Generally available
---

# Configure Heartbeat
<tip>
  To get started quickly, read [Quick start: installation and configuration](https://www.elastic.co/docs/reference/beats/heartbeat/heartbeat-installation-configuration).
</tip>

To configure Heartbeat, edit the configuration file. The default configuration file is called  `heartbeat.yml`. The location of the file varies by platform. To locate the file, see [Directory layout](https://www.elastic.co/docs/reference/beats/heartbeat/directory-layout).
There’s also a full example configuration file called `heartbeat.reference.yml` that shows all non-deprecated options.
<tip>
  See the [Config File Format](https://www.elastic.co/docs/reference/beats/libbeat/config-file-format) for more about the structure of the config file.
</tip>

The following topics describe how to configure Heartbeat:
- [Monitors](https://www.elastic.co/docs/reference/beats/heartbeat/configuration-heartbeat-options)
- [Task scheduler](https://www.elastic.co/docs/reference/beats/heartbeat/monitors-scheduler)
- [General settings](https://www.elastic.co/docs/reference/beats/heartbeat/configuration-general-options)
- [Project paths](https://www.elastic.co/docs/reference/beats/heartbeat/configuration-path)
- [Output](https://www.elastic.co/docs/reference/beats/heartbeat/configuring-output)
- [SSL](https://www.elastic.co/docs/reference/beats/heartbeat/configuration-ssl)
- [Index lifecycle management (ILM)](https://www.elastic.co/docs/reference/beats/heartbeat/ilm)
- [Elasticsearch index template](https://www.elastic.co/docs/reference/beats/heartbeat/configuration-template)
- [Processors](https://www.elastic.co/docs/reference/beats/heartbeat/filtering-enhancing-data)
- [*Autodiscover*](https://www.elastic.co/docs/reference/beats/heartbeat/configuration-autodiscover)
- [Internal queue](https://www.elastic.co/docs/reference/beats/heartbeat/configuring-internal-queue)
- [Logging](https://www.elastic.co/docs/reference/beats/heartbeat/configuration-logging)
- [HTTP endpoint](https://www.elastic.co/docs/reference/beats/heartbeat/http-endpoint)
- [*Regular expression support*](https://www.elastic.co/docs/reference/beats/heartbeat/regexp-support)
- [Instrumentation](https://www.elastic.co/docs/reference/beats/heartbeat/configuration-instrumentation)
- [Feature flags](https://www.elastic.co/docs/reference/beats/heartbeat/configuration-feature-flags)
- [*heartbeat.reference.yml*](https://www.elastic.co/docs/reference/beats/heartbeat/heartbeat-reference-yml)