﻿---
title: Add observer and geo metadata
description: Use the heartbeat.run_from option to set the geographic location fields relevant to a given heartbeat instance. The run_from option is used to label the...
url: https://www.elastic.co/docs/reference/beats/heartbeat/configuration-observer-options
products:
  - Beats
  - Heartbeat
applies_to:
  - Elastic Stack: Generally available
---

# Add observer and geo metadata
Use the `heartbeat.run_from` option to set the geographic location fields relevant to a given heartbeat instance.
The `run_from` option is used to label the geographic location where the monitor is running. Note, you can also set the `run_from` option on an individual monitor to apply a unique setting to just that monitor.
The `run_from` option takes two top-level fields:
- `id`: A string used to uniquely identify the geographic location. It is indexed as the `observer.name` field.
- `geo`: A map conforming to [ECS geo fields](https://www.elastic.co/docs/reference/ecs/ecs-geo). It is indexed under `observer.geo`.

Example:
```yaml
heartbeat.run_from:
  id: my-custom-geo
  geo:
	name: nyc-dc1-rack2
	location: 40.7128, -74.0060
	continent_name: North America
	country_iso_code: US
	region_name: New York
	region_iso_code: NY
	city_name: New York
```