﻿---
title: Advanced usage
description: Appenders allow users to append configuration that is already built with the help of either templates or builders. Appenders can be configured to be applied...
url: https://www.elastic.co/docs/reference/beats/heartbeat/configuration-autodiscover-advanced
products:
  - Beats
  - Heartbeat
applies_to:
  - Elastic Stack: Generally available
---

# Advanced usage
## Appenders

Appenders allow users to append configuration that is already built with the help of either templates or builders. Appenders can be configured to be applied only when a required condition is matched. The kind of configuration that is applied is specific to each appender.

### Config

The config appender can apply a config on top of the config that was generated by templates or builders. The config is applied whenever a provided condition is matched. It is always applied if there is no condition provided.
```yaml
heartbeat.autodiscover:
  providers:
    - type: kubernetes
      templates:
        ...
      appenders:
        - type: config
          condition.equals:
            kubernetes.namespace: "prometheus"
          config:
            fields:
              type: monitoring
```