﻿---
title: Heartbeat command reference
description: Heartbeat provides a command-line interface for starting Heartbeat and performing common tasks, like testing configuration files. The command-line also...
url: https://www.elastic.co/docs/reference/beats/heartbeat/command-line-options
products:
  - Beats
  - Heartbeat
applies_to:
  - Elastic Stack: Generally available
---

# Heartbeat command reference
Heartbeat provides a command-line interface for starting Heartbeat and performing common tasks, like testing configuration files.
The command-line also supports [global flags](#global-flags) for controlling global behaviors.
<tip>
  Use `sudo` to run the following commands if:
  - the config file is owned by `root`, or
  - Heartbeat is configured to capture data that requires `root` access
</tip>

Some of the features described here require an Elastic license. For more information, see [[https://www.elastic.co/subscriptions](https://www.elastic.co/subscriptions)](https://www.elastic.co/subscriptions) and [License Management](https://www.elastic.co/docs/deploy-manage/license/manage-your-license-in-self-managed-cluster).

| Commands                        |                                                                                                      |
|---------------------------------|------------------------------------------------------------------------------------------------------|
| [`export`](#export-command)     | Exports the configuration, index template, or ILM policy to stdout.                                  |
| [`help`](#help-command)         | Shows help for any command.                                                                          |
| [`keystore`](#keystore-command) | Manages the [secrets keystore](https://www.elastic.co/docs/reference/beats/heartbeat/keystore).      |
| [`run`](#run-command)           | Runs Heartbeat. This command is used by default if you start Heartbeat without specifying a command. |
| [`setup`](#setup-command)       | Sets up the initial environment, including the ES index template, and ILM policy and write alias.    |
| [`test`](#test-command)         | Tests the configuration.                                                                             |
| [`version`](#version-command)   | Shows information about the current version.                                                         |

Also see [Global flags](#global-flags).

## `export` command

Exports the configuration, index template, or ILM policy to stdout. You can use this command to quickly view your configuration or see the contents of the index template or the ILM policy.
**SYNOPSIS**
```sh
heartbeat export SUBCOMMAND [FLAGS]
```

**SUBCOMMANDS**
<definitions>
  <definition term="config">
    Exports the current configuration to stdout. If you use the `-c` flag, this command exports the configuration that’s defined in the specified file.
  </definition>
  <definition term="template">
    Exports the index template to stdout. You can specify the `--es.version` flag to further define what gets exported. Furthermore you can export the template to a file instead of `stdout` by defining a directory via `--dir`.
  </definition>
</definitions>


<definitions>
  <definition term="ilm-policy">
    Exports the index lifecycle management policy to stdout. You can specify the `--es.version` and a `--dir` to which the policy should be exported as a file rather than exporting to `stdout`.
  </definition>
</definitions>

**FLAGS**
<definitions>
  <definition term="--es.version VERSION">
    When used with [`template`](#template-subcommand), exports an index template that is compatible with the specified version.  When used with [`ilm-policy`](#ilm-policy-subcommand), exports the ILM policy if the specified ES version is enabled for ILM.
  </definition>
  <definition term="-h, --help">
    Shows help for the `export` command.
  </definition>
  <definition term="--dir DIRNAME">
    Define a directory to which the template, pipelines, and ILM policy should be exported to as files instead of printing them to `stdout`.
  </definition>
</definitions>

Also see [Global flags](#global-flags).
**EXAMPLES**
```sh
heartbeat export config
heartbeat export template --es.version 9.3.0
```


## `help` command

Shows help for any command. If no command is specified, shows help for the `run` command.
**SYNOPSIS**
```sh
heartbeat help COMMAND_NAME [FLAGS]
```

<definitions>
  <definition term="COMMAND_NAME">
    Specifies the name of the command to show help for.
  </definition>
</definitions>

**FLAGS**
<definitions>
  <definition term="-h, --help">
    Shows help for the `help` command.
  </definition>
</definitions>

Also see [Global flags](#global-flags).
**EXAMPLE**
```sh
heartbeat help export
```


## `keystore` command

Manages the [secrets keystore](https://www.elastic.co/docs/reference/beats/heartbeat/keystore).
**SYNOPSIS**
```sh
heartbeat keystore SUBCOMMAND [FLAGS]
```

**SUBCOMMANDS**
<definitions>
  <definition term="add KEY">
    Adds the specified key to the keystore. Use the `--force` flag to overwrite an existing key. Use the `--stdin` flag to pass the value through `stdin`.
  </definition>
  <definition term="create">
    Creates a keystore to hold secrets. Use the `--force` flag to overwrite the existing keystore.
  </definition>
  <definition term="list">
    Lists the keys in the keystore.
  </definition>
  <definition term="remove KEY">
    Removes the specified key from the keystore.
  </definition>
</definitions>

**FLAGS**
<definitions>
  <definition term="--force">
    Valid with the `add` and `create` subcommands. When used with `add`, overwrites the specified key. When used with `create`, overwrites the keystore.
  </definition>
  <definition term="--stdin">
    When used with `add`, uses the stdin as the source of the key’s value.
  </definition>
  <definition term="-h, --help">
    Shows help for the `keystore` command.
  </definition>
</definitions>

Also see [Global flags](#global-flags).
**EXAMPLES**
```sh
heartbeat keystore create
heartbeat keystore add ES_PWD
heartbeat keystore remove ES_PWD
heartbeat keystore list
```

See [Secrets keystore](https://www.elastic.co/docs/reference/beats/heartbeat/keystore) for more examples.

## `run` command

Runs Heartbeat. This command is used by default if you start Heartbeat without specifying a command.
**SYNOPSIS**
```sh
heartbeat run [FLAGS]
```

Or:
```sh
heartbeat [FLAGS]
```

**FLAGS**
<definitions>
  <definition term="-N, --N">
    Disables publishing for testing purposes. This option disables all outputs except the [File output](https://www.elastic.co/docs/reference/beats/heartbeat/file-output).
  </definition>
  <definition term="--cpuprofile FILE">
    Writes CPU profile data to the specified file. This option is useful for troubleshooting Heartbeat.
  </definition>
  <definition term="-h, --help">
    Shows help for the `run` command.
  </definition>
  <definition term="--httpprof [HOST]:PORT">
    Starts an http server for profiling. This option is useful for troubleshooting and profiling Heartbeat.
  </definition>
  <definition term="--memprofile FILE">
    Writes memory profile data to the specified output file. This option is useful for troubleshooting Heartbeat.
  </definition>
  <definition term="--system.hostfs MOUNT_POINT">
    Specifies the mount point of the host’s filesystem for use in monitoring a host. This flag is depricated, and an alternate hostfs should be specified via the `hostfs` module config value.
  </definition>
</definitions>

Also see [Global flags](#global-flags).
**EXAMPLE**
```sh
heartbeat run -e
```

Or:
```sh
heartbeat -e
```


## `setup` command

Sets up the initial environment, including the ES index template, and ILM policy and write alias
- The index template ensures that fields are mapped correctly in Elasticsearch. If index lifecycle management is enabled it also ensures that the defined ILM policy and write alias are connected to the indices matching the index template. The ILM policy takes care of the lifecycle of an index, when to do a rollover, when to move an index from the hot phase to the next phase, etc.

This command sets up the environment without actually running Heartbeat and ingesting data. Specify optional flags to set up a subset of assets.
**SYNOPSIS**
```sh
heartbeat setup [FLAGS]
```

**FLAGS**
<definitions>
  <definition term="-h, --help">
    Shows help for the `setup` command.
  </definition>
  <definition term="--index-management">
    Sets up components related to Elasticsearch index management including template, ILM policy, and write alias (if supported and configured).
  </definition>
</definitions>

Also see [Global flags](#global-flags).
**EXAMPLES**
```sh
heartbeat setup --index-management
```


## `test` command

Tests the configuration.
**SYNOPSIS**
```sh
heartbeat test SUBCOMMAND [FLAGS]
```

**SUBCOMMANDS**
<definitions>
  <definition term="config">
    Tests the configuration settings.
  </definition>
  <definition term="output">
    Tests that Heartbeat can connect to the output by using the current settings.
  </definition>
</definitions>

**FLAGS**
<definitions>
  <definition term="-h, --help">
    Shows help for the `test` command.
  </definition>
</definitions>

Also see [Global flags](#global-flags).
**EXAMPLE**
```sh
heartbeat test config
```


## `version` command

Shows information about the current version.
**SYNOPSIS**
```sh
heartbeat version [FLAGS]
```

**FLAGS**
<definitions>
  <definition term="-h, --help">
    Shows help for the `version` command.
  </definition>
</definitions>

Also see [Global flags](#global-flags).
**EXAMPLE**
```sh
heartbeat version
```


## Global flags

These global flags are available whenever you run Heartbeat.
<definitions>
  <definition term="-E, --E "SETTING_NAME=VALUE"">
    Overrides a specific configuration setting. You can specify multiple overrides. For example:
    ```sh
    heartbeat -E "name=mybeat" -E "output.elasticsearch.hosts=['http://myhost:9200']"
    ```
    This setting is applied to the currently running Heartbeat process. The Heartbeat configuration file is not changed.
  </definition>
  <definition term="-c, --c FILE">
    Specifies the configuration file to use for Heartbeat. The file you specify here is relative to `path.config`. If the `-c` flag is not specified, the default config file, `heartbeat.yml`, is used.
  </definition>
  <definition term="-d, --d SELECTORS">
    Enables debugging for the specified selectors. For the selectors, you can specify a comma-separated list of components, or you can use `-d "*"` to enable debugging for all components. For example, `-d "publisher"` displays all the publisher-related messages.
  </definition>
  <definition term="-e, --e">
    Logs to stderr and disables syslog/file output.
  </definition>
  <definition term="--environment">
    For logging purposes, specifies the environment that Heartbeat is running in. This setting is used to select a default log output when no log output is configured. Supported values are: `systemd`, `container`, `macos_service`, and `windows_service`. If `systemd` or `container` is specified, Heartbeat will log to stdout and stderr by default.
  </definition>
  <definition term="--path.config">
    Sets the path for configuration files. See the [Directory layout](https://www.elastic.co/docs/reference/beats/heartbeat/directory-layout) section for details.
  </definition>
  <definition term="--path.data">
    Sets the path for data files. See the [Directory layout](https://www.elastic.co/docs/reference/beats/heartbeat/directory-layout) section for details.
  </definition>
  <definition term="--path.home">
    Sets the path for miscellaneous files. See the [Directory layout](https://www.elastic.co/docs/reference/beats/heartbeat/directory-layout) section for details.
  </definition>
  <definition term="--path.logs">
    Sets the path for log files. See the [Directory layout](https://www.elastic.co/docs/reference/beats/heartbeat/directory-layout) section for details.
  </definition>
  <definition term="--strict.perms">
    Sets strict permission checking on configuration files. The default is `--strict.perms=true`. See [Config file ownership and permissions](https://www.elastic.co/docs/reference/beats/libbeat/config-file-permissions) for more information.
  </definition>
  <definition term="-v, --v">
    Logs INFO-level messages.
  </definition>
</definitions>