﻿---
title: Change the index name
description: Heartbeat uses data streams named heartbeat-[version]. To use a different name, set the index option in the Elasticsearch output. You also need to configure...
url: https://www.elastic.co/docs/reference/beats/heartbeat/change-index-name
products:
  - Beats
  - Heartbeat
applies_to:
  - Elastic Stack: Generally available
---

# Change the index name
Heartbeat uses data streams named `heartbeat-[version]`. To use a different name, set the [`index`](/docs/reference/beats/heartbeat/elasticsearch-output#index-option-es) option in the Elasticsearch output. You also need to configure the `setup.template.name` and `setup.template.pattern` options to match the new name. For example:
```sh
output.elasticsearch.index: "customname-%{[agent.version]}"
setup.template.name: "customname-%{[agent.version]}"
setup.template.pattern: "customname-%{[agent.version]}"
```

For a full list of template setup options, see [Elasticsearch index template](https://www.elastic.co/docs/reference/beats/heartbeat/configuration-template).
Remember to change the index name when you load dashboards via the Kibana UI.