﻿---
title: Add network direction
description: The add_network_direction processor attempts to compute the perimeter-based network direction given an a source and destination ip address and list of...
url: https://www.elastic.co/docs/reference/beats/heartbeat/add-network-direction
products:
  - Beats
  - Heartbeat
applies_to:
  - Elastic Stack: Generally available
---

# Add network direction
The `add_network_direction` processor attempts to compute the perimeter-based network direction given an a source and destination ip address and list of internal networks. The key `internal_networks` can contain either CIDR blocks or a list of special values enumerated in the network section of [Conditions](/docs/reference/beats/heartbeat/defining-processors#conditions).
```yaml
processors:
  - add_network_direction:
      source: source.ip
      destination: destination.ip
      target: network.direction
      internal_networks: [ private ]
```

See [Conditions](/docs/reference/beats/heartbeat/defining-processors#conditions) for a list of supported conditions.