﻿---
title: Secure Filebeat
description: The following topics provide information about securing the Filebeat process and connecting to a cluster that has security features enabled. You can use...
url: https://www.elastic.co/docs/reference/beats/filebeat/securing-filebeat
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Secure Filebeat
The following topics provide information about securing the Filebeat process and connecting to a cluster that has security features enabled.
You can use role-based access control and optionally, API keys to grant Filebeat users access to secured resources.
- [*Grant users access to secured resources*](https://www.elastic.co/docs/reference/beats/filebeat/feature-roles)
- [*Grant access using API keys*](https://www.elastic.co/docs/reference/beats/filebeat/beats-api-keys).

After privileged users have been created, use authentication to connect to a secured Elastic cluster.
- [*Secure communication with Elasticsearch*](https://www.elastic.co/docs/reference/beats/filebeat/securing-communication-elasticsearch)
- [*Secure communication with Logstash*](https://www.elastic.co/docs/reference/beats/filebeat/configuring-ssl-logstash)

On Linux, Filebeat can take advantage of secure computing mode to restrict the system calls that a process can issue.
- [*Use Linux Secure Computing Mode (seccomp)*](https://www.elastic.co/docs/reference/beats/filebeat/linux-seccomp)