﻿---
title: Rename fields from events
description: The rename processor specifies a list of fields to rename. Under the fields key, each entry contains a from: old-key and a to: new-key pair, where: from...
url: https://www.elastic.co/docs/reference/beats/filebeat/rename-fields
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Rename fields from events
The `rename` processor specifies a list of fields to rename. Under the `fields` key, each entry contains a `from: old-key` and a `to: new-key` pair, where:
- `from` is the original field name. It’s supported to use `@metadata.` prefix for `from` and rename keys in the event metadata instead of event fields.
- `to` is the target field name

The `rename` processor cannot be used to overwrite fields. To overwrite fields either first rename the target field, or use the `drop_fields` processor to drop the field and then rename the field.
<tip>
  You can rename fields to resolve field name conflicts. For example, if an event has two fields, `c` and `c.b` (where `b` is a subfield of `c`), assigning scalar values results in an Elasticsearch error at ingest time. The assignment `{"c": 1, "c.b": 2}` would result in an error because `c` is an object and cannot be assigned a scalar value. To prevent this conflict, rename `c` to `c.value` before assigning values.
</tip>

```yaml
processors:
  - rename:
      fields:
        - from: "a.g"
          to: "e.d"
      ignore_missing: false
      fail_on_error: true
```

The `rename` processor has the following configuration settings:
<definitions>
  <definition term="ignore_missing">
    (Optional) If set to true, no error is logged in case a key which should be renamed is missing. Default is `false`.
  </definition>
  <definition term="fail_on_error">
    (Optional) If set to true, in case of an error the renaming of fields is stopped and the original event is returned. If set to false, renaming continues also if an error happened during renaming. Default is `true`.
  </definition>
</definitions>

See [Conditions](/docs/reference/beats/filebeat/defining-processors#conditions) for a list of supported conditions.
You can specify multiple `rename` processors under the `processors` section.