﻿---
title: Registry file is too large
description: Filebeat keeps the state of each file and persists the state to disk in the registry file. The file state is used to continue file reading at a previous...
url: https://www.elastic.co/docs/reference/beats/filebeat/reduce-registry-size
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Registry file is too large
Filebeat keeps the state of each file and persists the state to disk in the registry file. The file state is used to continue file reading at a previous position when Filebeat is restarted. If a large number of new files are produced every day, the registry file might grow to be too large. To reduce the size of the registry file, there are two configuration options available: [`clean_removed`](/docs/reference/beats/filebeat/filebeat-input-log#filebeat-input-log-clean-removed) and [`clean_inactive`](/docs/reference/beats/filebeat/filebeat-input-log#filebeat-input-log-clean-inactive).
For old files that you no longer touch and are ignored (see [`ignore_older`](/docs/reference/beats/filebeat/filebeat-input-log#filebeat-input-log-ignore-older)), we recommended that you use `clean_inactive`. If old files get removed from disk, then use the `clean_removed` option.