﻿---
title: Grant privileges and roles needed for publishing
description: Users who publish events to Elasticsearch need to create and write to Filebeat indices. To minimize the privileges required by the writer role, use the...
url: https://www.elastic.co/docs/reference/beats/filebeat/privileges-to-publish-events
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Grant privileges and roles needed for publishing
Users who publish events to Elasticsearch need to create and write to Filebeat indices. To minimize the privileges required by the writer role, use the [setup role](https://www.elastic.co/docs/reference/beats/filebeat/privileges-to-setup-beats) to pre-load dependencies. This section assumes that you’ve run the setup.
When using ILM, turn off the ILM setup check in the Filebeat config file before running Filebeat to publish events:
```yaml
setup.ilm.check_exists: false
```

To grant the required privileges:
1. Create a **writer role**, called something like `filebeat_writer`, that has the following privileges:
   <note>
   The `monitor` cluster privilege and the `create_doc` and `auto_configure` privileges on `filebeat-*` indices are required in every configuration.
   </note>
   | Type    | Privilege                                | Purpose                                                                                                                                                                                                                                                                                                      |
   |---------|------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
   | Cluster | `monitor`                                | Retrieve cluster details (e.g. version)                                                                                                                                                                                                                                                                      |
   | Cluster | `read_ilm`                               | Read the ILM policy when connecting to clusters that support ILM.Not needed when `setup.ilm.check_exists` is `false`.                                                                                                                                                                                        |
   | Cluster | `read_pipeline`                          | Check for ingest pipelines used by modules. Needed when using modules.                                                                                                                                                                                                                                       |
   | Index   | `create_doc` on `filebeat-*` indices     | Write events into Elasticsearch                                                                                                                                                                                                                                                                              |
   | Index   | `auto_configure` on `filebeat-*` indices | Update the datastream mapping. Consider either disabling entirely or adding therule `-{{beat_default_index_prefix}}-*` to the cluster settings[action.auto_create_index](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-create)to prevent unwanted indices creations from the agents. |
   Omit any privileges that aren’t relevant in your environment.
2. Assign the **writer role** to users who will index events into Elasticsearch.