﻿---
title: Use internal collection to send monitoring data
description: Use internal collectors to send Beats monitoring data directly to your monitoring cluster. Or as an alternative to internal collection, use Use Metricbeat...
url: https://www.elastic.co/docs/reference/beats/filebeat/monitoring-internal-collection
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Use internal collection to send monitoring data
Use internal collectors to send Beats monitoring data directly to your monitoring cluster. Or as an alternative to internal collection, use [Use Metricbeat collection](https://www.elastic.co/docs/reference/beats/filebeat/monitoring-metricbeat-collection). The benefit of using internal collection instead of Metricbeat is that you have fewer pieces of software to install and maintain.
1. Create an API key or user that has appropriate authority to send system-level monitoring data to Elasticsearch. For example, you can use the built-in `beats_system` user or assign the built-in `beats_system` role to another user. For more information on the required privileges, see [Create a *monitoring* user](https://www.elastic.co/docs/reference/beats/filebeat/privileges-to-publish-monitoring). For more information on how to use API keys, see [*Grant access using API keys*](https://www.elastic.co/docs/reference/beats/filebeat/beats-api-keys).
2. Add the `monitoring` settings in the Filebeat configuration file. If you configured the Elasticsearch output and want to send Filebeat monitoring events to the same Elasticsearch cluster, specify the following minimal configuration:
   ```yaml
   monitoring:
     enabled: true
     elasticsearch:
       api_key:  id:api_key 
       username: beats_system
       password: somepassword
   ```
   If you want to send monitoring events to an [Elastic Cloud](https://cloud.elastic.co/) monitoring cluster, you can use two simpler settings. When defined, these settings overwrite settings from other parts in the configuration. For example:
   ```yaml
   monitoring:
     enabled: true
     cloud.id: 'staging:dXMtZWFzdC0xLmF3cy5mb3VuZC5pbyRjZWM2ZjI2MWE3NGJmMjRjZTMzYmI4ODExYjg0Mjk0ZiRjNmMyY2E2ZDA0MjI0OWFmMGNjN2Q3YTllOTYyNTc0Mw=='
     cloud.auth: 'elastic:YOUR_PASSWORD'
   ```
   If you configured a different output, such as Logstash or you want to send Filebeat monitoring events to a separate Elasticsearch cluster (referred to as the *monitoring cluster*), you must specify additional configuration options. For example:
   ```yaml
   monitoring:
     enabled: true
     cluster_uuid: PRODUCTION_ES_CLUSTER_UUID 
     elasticsearch:
       hosts: ["<HOST_URL_1>:<PORT_1>", "<HOST_URL_2>:<PORT_2>"] 
       api_key:  id:api_key 
       username: beats_system
       password: somepassword
   ```
   If you want to use PKI authentication to send monitoring events to Elasticsearch, you must specify a different set of configuration options. For example:
   ```yaml
   monitoring:
     enabled: true
     cluster_uuid: PRODUCTION_ES_CLUSTER_UUID
     elasticsearch:
       hosts: ["<HOST_URL_1>:<PORT_1>", "<HOST_URL_2>:<PORT_2>"]
       username: ""
       ssl.certificate_authorities: ["/etc/pki/root/ca.pem"]
       ssl.certificate: "/etc/pki/client/cert.pem"
       ssl.key: "/etc/pki/client/cert.key"
   ```
   You must specify the `username` as `""` explicitly so that the username from the client certificate (`CN`) is used. See [SSL](https://www.elastic.co/docs/reference/beats/filebeat/configuration-ssl) for more information about SSL settings.
3. Start Filebeat.
4. [View the monitoring data in Kibana](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-data).