﻿---
title: Migrating from a Deprecated Filebeat Module
description: If a Filebeat module has been deprecated, there are a few options available for a path forward: Migrate to an Elastic integration, if available. The deprecation...
url: https://www.elastic.co/docs/reference/beats/filebeat/migrate-from-deprecated-module
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Migrating from a Deprecated Filebeat Module
If a Filebeat module has been deprecated, there are a few options available for a path forward:
1. Migrate to an Elastic integration, if available. The deprecation notice will link to an appropriate integration, if one exists.
2. [Migrate to Elastic Agent](https://www.elastic.co/docs/reference/fleet/migrate-from-beats-to-elastic-agent) for ingesting logs. If a specific integration for the vendor/product does not exist, then one of the custom integrations can be used for ingesting events. A [custom pipeline](https://www.elastic.co/docs/reference/fleet/data-streams-pipeline-tutorial) may also be attached to the integration for further processing.
   - [CEL Custom API](https://www.elastic.co/docs/reference/integrations/cel) - Collect events from an API using CEL (Common Expression Language)
- [Custom API](https://www.elastic.co/docs/reference/integrations/httpjson) - Collect events from an API using the HTTPJSON input
- [Custom Google Pub/Sub](https://www.elastic.co/docs/reference/integrations/gcp_pubsub) - Collect events from Google Pub/Sub topics
- [Custom HTTP Endpoint](https://www.elastic.co/docs/reference/integrations/http_endpoint) - Collect events from a listening HTTP port
- [Custom Journald](https://www.elastic.co/docs/reference/integrations/journald) - Collect events from journald
- [Custom Kafka](https://www.elastic.co/docs/reference/integrations/kafka_log) - Collect events from a Kafka topic
- [Custom Logs](https://www.elastic.co/docs/reference/integrations/log) - Collect events from files
- [Custom TCP](https://www.elastic.co/docs/reference/integrations/tcp) - Collect events from a listening TCP port
- [Custom UDP](https://www.elastic.co/docs/reference/integrations/udp) - Collect events from a listening UDP port
- [Custom Windows Event](https://www.elastic.co/docs/reference/integrations/winlog) - Collect events from a Windows Event Log channel
3. Migrate to a different Filebeat module. In some cases, a Filebeat module may be superseded by a new module. The deprecation notice will link to an appropriate module, if one exists.
4. Use a custom Filebeat input, processors, and ingest pipeline (if necessary).