﻿---
title: How to guides
description: Learn how to perform common Filebeat configuration tasks. Override configuration settings, Load the Elasticsearch index template, Change the index name,...
url: https://www.elastic.co/docs/reference/beats/filebeat/howto-guides
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# How to guides
Learn how to perform common Filebeat configuration tasks.
- [Override configuration settings](https://www.elastic.co/docs/reference/beats/filebeat/override-filebeat-config-settings)
- [*Load the Elasticsearch index template*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-template)
- [*Change the index name*](https://www.elastic.co/docs/reference/beats/filebeat/change-index-name)
- [*Load Kibana dashboards*](https://www.elastic.co/docs/reference/beats/filebeat/load-kibana-dashboards)
- [*Load ingest pipelines*](https://www.elastic.co/docs/reference/beats/filebeat/load-ingest-pipelines)
- [*Enrich events with geoIP information*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-geoip)
- [*Deduplicate data*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-deduplication)
- [*Parse data using an ingest pipeline*](https://www.elastic.co/docs/reference/beats/filebeat/configuring-ingest-node)
- [*Use environment variables in the configuration*](https://www.elastic.co/docs/reference/beats/filebeat/using-environ-vars)
- [*Avoid YAML formatting problems*](https://www.elastic.co/docs/reference/beats/filebeat/yaml-tips)
- [*Migrate `log` or `container` input configurations to `filestream`*](https://www.elastic.co/docs/reference/beats/filebeat/migrate-to-filestream)
- [*Choose file identity for `filestream`*](https://www.elastic.co/docs/reference/beats/filebeat/file-identity)
- [*Migrating from a Deprecated Filebeat Module*](https://www.elastic.co/docs/reference/beats/filebeat/migrate-from-deprecated-module)
- [*Removing ingested files with the Filestream input*](https://www.elastic.co/docs/reference/beats/filebeat/delete-file-guide)