﻿---
title: Start Filebeat
description: Before starting Filebeat: Follow the steps in Quick start: installation and configuration to install, configure, and set up the Filebeat environment.Make...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-starting
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Start Filebeat
Before starting Filebeat:
- Follow the steps in [Quick start: installation and configuration](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration) to install, configure, and set up the Filebeat environment.
- Make sure Kibana and Elasticsearch are running.
- Make sure the user specified in `filebeat.yml` is [authorized to publish events](https://www.elastic.co/docs/reference/beats/filebeat/privileges-to-publish-events).

To start Filebeat, run:
<tab-set>
  <tab-item title="DEB">
    ```sh
    sudo service filebeat start
    ```

    <note>
      If you use an `init.d` script to start Filebeat, you can’t specify command line flags (see [Command reference](https://www.elastic.co/docs/reference/beats/filebeat/command-line-options)). To specify flags, start Filebeat in the foreground.
    </note>
    Also see [Filebeat and systemd](https://www.elastic.co/docs/reference/beats/filebeat/running-with-systemd).
  </tab-item>

  <tab-item title="RPM">
    ```sh
    sudo service filebeat start
    ```

    <note>
      If you use an `init.d` script to start Filebeat, you can’t specify command line flags (see [Command reference](https://www.elastic.co/docs/reference/beats/filebeat/command-line-options)). To specify flags, start Filebeat in the foreground.
    </note>
    Also see [Filebeat and systemd](https://www.elastic.co/docs/reference/beats/filebeat/running-with-systemd).
  </tab-item>

  <tab-item title="MacOS">
    ```sh
    sudo chown root filebeat.yml 
    sudo chown root modules.d/{modulename}.yml 
    sudo ./filebeat -e
    ```
  </tab-item>

  <tab-item title="Linux">
    ```sh
    sudo chown root filebeat.yml 
    sudo chown root modules.d/{modulename}.yml 
    sudo ./filebeat -e
    ```
  </tab-item>

  <tab-item title="Windows">
    ```sh
    PS C:\Program Files\filebeat> Start-Service filebeat
    ```
    By default Windows log files are stored in `C:\Program Files\Filebeat-Data\logs`.
    <note>
      In versions before 9.0.6, the default location for Windows log files was `C:\ProgramData\filebeat\logs`.
    </note>
  </tab-item>
</tab-set>