﻿---
title: Filebeat isn't collecting lines from a file
description: Filebeat might be incorrectly configured or unable to send events to the output. To resolve the issue: If using modules, make sure the var.paths setting...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-not-collecting-lines
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Filebeat isn't collecting lines from a file
Filebeat might be incorrectly configured or unable to send events to the output. To resolve the issue:
- If using modules, make sure the `var.paths` setting points to the file. If configuring an input manually, make sure the `paths` setting is correct.
- Verify that the file is not older than the value specified by [`ignore_older`](/docs/reference/beats/filebeat/filebeat-input-log#filebeat-input-log-ignore-older). `ignore_older` is disable by default so this depends on the value you have set. You can change this behavior by specifying a different value for [`ignore_older`](/docs/reference/beats/filebeat/filebeat-input-log#filebeat-input-log-ignore-older).
- Make sure that Filebeat is able to send events to the configured output. Run Filebeat in debug mode to determine whether it’s publishing events successfully:
  ```sh
  ./filebeat -c config.yml -e -d "*"
  ```